VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsButtonNC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'------------------------------------------------
'Autor:         Leandro Ascierto
'Web:           www.leandroascierto.com.ar
'Date:          29/07/2011
'Requirements:  Windows XP Or later
'Description:   Is a Button in Not Client Area
'------------------------------------------------

'-->GDIPlus.dll
Private Declare Function GdiplusStartup Lib "GDIplus" (Token As Long, inputbuf As GdiplusStartupInput, Optional ByVal outputbuf As Long = 0) As Long
Private Declare Sub GdiplusShutdown Lib "GDIplus" (ByVal Token As Long)
Private Declare Function GdipGetImageWidth Lib "GDIplus" (ByVal Image As Long, Width As Long) As Long
Private Declare Function GdipGetImageHeight Lib "GDIplus" (ByVal Image As Long, Height As Long) As Long
Private Declare Function GdipLoadImageFromStream Lib "GDIplus" (ByVal Stream As Any, ByRef Image As Long) As Long
Private Declare Function GdipLoadImageFromFile Lib "GDIplus" (ByVal Filename As Long, Image As Long) As Long
Private Declare Function GdipDisposeImage Lib "GDIplus" (ByVal Image As Long) As Long
Private Declare Function GdipDeleteGraphics Lib "GDIplus" (ByVal graphics As Long) As Long
Private Declare Function GdipCreateFromHDC Lib "GDIplus" (ByVal hDC As Long, graphics As Long) As Long
Private Declare Function GdipDrawImageRectRectI Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mImage As Long, ByVal mDstx As Long, ByVal mDsty As Long, ByVal mDstwidth As Long, ByVal mDstheight As Long, ByVal mSrcx As Long, ByVal mSrcy As Long, ByVal mSrcwidth As Long, ByVal mSrcheight As Long, ByVal mSrcUnit As Long, ByVal mImageAttributes As Long, ByVal mcallback As Long, ByVal mcallbackData As Long) As Long
Private Declare Function GdipDrawImageI Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mImage As Long, ByVal mX As Long, ByVal mY As Long) As Long
'-->GDI32.dll
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function CreateDIBSection Lib "gdi32" (ByVal hDC As Long, pBitmapInfo As BITMAPINFO, ByVal un As Long, ByRef lplpVoid As Any, ByVal handle As Long, ByVal dw As Long) As Long
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hDC As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hDC As Long, ByVal hObject As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hDC As Long) As Long
'-->OLE32.dll
Private Declare Sub CreateStreamOnHGlobal Lib "ole32" (ByRef hGlobal As Any, ByVal fDeleteOnRelease As Long, ByRef ppstm As Any)
'--->MSVBVM60.dll
Private Declare Function VarPtrArray Lib "msvbvm60" Alias "VarPtr" (Ptr() As Any) As Long
'-->USER32.dll
Private Declare Function GetDesktopWindow Lib "user32.dll" () As Long
Private Declare Function SetParent Lib "user32.dll" (ByVal hWndChild As Long, ByVal hWndNewParent As Long) As Long
Private Declare Function CreateWindowEx Lib "user32.dll" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByRef lpParam As Any) As Long
Private Declare Function DestroyWindow Lib "user32.dll" (ByVal hWnd As Long) As Long
Private Declare Function SetWindowLongA Lib "User32" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function CallWindowProcA Lib "User32" (ByVal lpPrevWndFunc As Long, ByVal hWnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function TrackMouseEvent Lib "User32" (lpEventTrack As TRACKMOUSEEVENT_STRUCT) As Long
Private Declare Function EnableWindow Lib "user32.dll" (ByVal hWnd As Long, ByVal fEnable As Long) As Long
Private Declare Function ShowWindow Lib "user32.dll" (ByVal hWnd As Long, ByVal nCmdShow As Long) As Long
Private Declare Function GetWindowRect Lib "user32.dll" (ByVal hWnd As Long, ByRef lpRect As RECT) As Long
Private Declare Function SetWindowLong Lib "User32" Alias "SetWindowLongA" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function GetParent Lib "User32" (ByVal hWnd As Long) As Long
Private Declare Function CreateWindowExA Lib "User32" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByRef lpParam As Any) As Long
Private Declare Function SetWindowPos Lib "User32" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Private Declare Function UpdateLayeredWindow Lib "User32" (ByVal hWnd As Long, ByVal hdcDst As Long, pptDst As Any, psize As Any, ByVal hdcSrc As Long, pptSrc As Any, ByVal crKey As Long, ByRef pblend As BLENDFUNCTION, ByVal dwFlags As Long) As Long
Private Declare Function SendMessage Lib "User32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long   ' <---
Private Declare Function WindowFromPoint Lib "user32.dll" (ByVal xPoint As Long, ByVal yPoint As Long) As Long
Private Declare Function GetCursorPos Lib "user32.dll" (ByRef lpPoint As POINTAPI) As Long
'-->comctl32
Private Declare Sub InitCommonControls Lib "comctl32" ()
'-->Kernel32.dll
Private Declare Sub CopyMemory Lib "KERNEL32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal Length As Long)

'-->Types
Private Type POINTAPI
   X                        As Long
   Y                        As Long
End Type

Private Type SIZE
   cx                       As Long
   cy                       As Long
End Type

Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Private Type BITMAPINFOHEADER
   biSize                   As Long
   biWidth                  As Long
   biHeight                 As Long
   biPlanes                 As Integer
   biBitCount               As Integer
   biCompression            As Long
   biSizeImage              As Long
   biXPelsPerMeter          As Long
   biYPelsPerMeter          As Long
   biClrUsed                As Long
   biClrImportant           As Long
End Type

Private Type BITMAPINFO
   bmiHeader                As BITMAPINFOHEADER
   bmiColors(3)             As Byte
End Type

Private Type BLENDFUNCTION
   BlendOp                  As Byte
   BlendFlags               As Byte
   SourceConstantAlpha      As Byte
   AlphaFormat              As Byte
End Type

Private Type GdiplusStartupInput
   GdiplusVersion           As Long
   DebugEventCallback       As Long
   SuppressBackgroundThread As Long
   SuppressExternalCodecs   As Long
End Type

Private Type TRACKMOUSEEVENT_STRUCT
    cbSize      As Long
    dwFlags     As Long
    hwndTrack   As Long
    dwHoverTime As Long
End Type

Private Type TOOLINFO
    cbSize              As Long
    uFlags              As Long
    hWnd                As Long
    uId                 As Long
    RECT                As RECT
    hInst               As Long
    lpszText            As String
    lParam              As Long
End Type

'-->Constant
Private Const ULW_ALPHA         As Long = &H2
Private Const BI_RGB            As Long = 0&
Private Const DIB_RGB_COLORS    As Long = 0&
Private Const AC_SRC_ALPHA      As Long = &H1
Private Const SWP_NOSIZE        As Long = &H1
Private Const TME_LEAVE         As Long = &H2&

Private Const GWL_WNDPROC       As Long = -4
Private Const GWL_HWNDPARENT    As Long = -8
Private Const GWL_EXSTYLE       As Long = -20
Private Const WS_EX_TOPMOST     As Long = &H8&
Private Const WS_EX_LAYERED     As Long = &H80000
Private Const WS_CHILD          As Long = &H40000000
Private Const WS_VISIBLE        As Long = &H10000000
Private Const WS_POPUP          As Long = &H80000000

Private Const WM_USER           As Long = &H400
Private Const WM_DESTROY        As Long = &H2
Private Const WM_MOVE           As Long = &H3
Private Const WM_SIZE           As Long = &H5
Private Const WM_LBUTTONDOWN    As Long = &H201
Private Const WM_LBUTTONUP      As Long = &H202
Private Const WM_MOUSELEAVE     As Long = &H2A3
Private Const WM_MOUSEMOVE      As Long = &H200
Private Const WM_LBUTTONDBLCLK  As Long = &H203
Private Const WM_SHOWWINDOW     As Long = &H18
Private Const WM_ACTIVATE       As Long = &H6
Private Const WM_RBUTTONDOWN    As Long = &H204
Private Const WM_RBUTTONUP      As Long = &H205
Private Const WM_MBUTTONDOWN    As Long = &H207
Private Const WM_MBUTTONUP      As Long = &H208
Private Const WM_ENABLE         As Long = &HA

Private Const SW_SHOW           As Long = 5&
Private Const SW_HIDE           As Long = 0&

Private Const MK_CONTROL        As Long = &H8
Private Const MK_LBUTTON        As Long = &H1
Private Const MK_MBUTTON        As Long = &H10
Private Const MK_RBUTTON        As Long = &H2
Private Const MK_SHIFT          As Long = &H4

Private Const TTM_ADDTOOL       As Long = (WM_USER + 4)
Private Const TTM_UPDATETIPTEXT As Long = (WM_USER + 12)
Private Const TTM_SETMAXTIPWIDTH As Long = (WM_USER + 24)
Private Const TTF_SUBCLASS      As Long = &H10
Private Const TTF_IDISHWND      As Long = &H1
Private Const TTS_ALWAYSTIP     As Long = &H1
Private Const TOOLTIPS_CLASS    As String = "tooltips_class32"

'-->Enum
Public Enum EnuMoveMode
    LeftTop = 0
    TopRight = 1
    RightBottom = 2
    BottomLeft = 3
End Enum

'-->Events
Public Event Click()
Public Event MouseDown(Button As Integer, Shift As Integer, X As Long, Y As Long)
Public Event MouseUp(Button As Integer, Shift As Integer, X As Long, Y As Long)
Public Event MouseMove(Button As Integer, Shift As Integer, X As Long, Y As Long)
Public Event MouseEnter()
Public Event MouseExit()

'-->Variants
Private m_hwndTT        As Long
Private tTI             As TOOLINFO
Private tBLENDFUNCTION  As BLENDFUNCTION
Private lWidth          As Long
Private lHeight         As Long
Private tSIZE           As SIZE
Private m_bInCtrl       As Boolean
Private m_Enabled       As Boolean
Private m_Visible       As Boolean
Private m_Rect          As RECT
Private hParent         As Long
Private m_MoveMode      As EnuMoveMode
Private m_State         As Long
Private c_lhDC          As Long
Private c_lDIB          As Long
Private m_OldBmp        As Long
Private hButton         As Long
Private PrevWndProc     As Long
Private prevBtnProc     As Long
Private lpAdress        As Long
Private bvASM(40)       As Byte
Private m_bForcePress   As Boolean

'Private for the module (Dont Call!)
Public Function WindowProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    On Local Error Resume Next
    
    Dim vkButton As Integer
    Dim vkShift As Integer
    
    If hWnd = hButton Then

        Select Case uMsg
            Case WM_LBUTTONDOWN, WM_MBUTTONDOWN, WM_RBUTTONDOWN
                If uMsg = WM_LBUTTONDOWN Then pvSetState 2
                pvGetVirtualKeys wParam, vkButton, vkShift
                RaiseEvent MouseDown(vkButton, vkShift, LoWord(lParam), HiWord(lParam))

            Case WM_LBUTTONDBLCLK
                pvSetState 2
                
            Case WM_LBUTTONUP, WM_RBUTTONUP, WM_MBUTTONUP
                If (uMsg = WM_LBUTTONUP) And pvIsCursorOverWindow(hWnd) Then pvSetState 1
                pvGetVirtualKeys wParam, vkButton, vkShift
                RaiseEvent MouseUp(vkButton, vkShift, LoWord(lParam), HiWord(lParam))
                If uMsg = WM_LBUTTONUP Then
                    If pvIsCursorOverWindow(hButton) Then
                        RaiseEvent Click
                    End If
                End If
            Case WM_MOUSEMOVE
                    pvGetVirtualKeys wParam, vkButton, vkShift
            
                   If (Not m_bInCtrl) Then
                        m_bInCtrl = True
                        Call pvTrackMouseLeave(hWnd)
                        pvSetState 1
                        RaiseEvent MouseEnter
                   Else
                        If pvIsCursorOverWindow(hWnd) Then
                            If (m_State = 0) And (vkButton = vbLeftButton) Then pvSetState 2
                        Else
                            If m_State = 2 Then pvSetState 0
                        End If
                   End If
                   
                   
                   RaiseEvent MouseMove(vkButton, vkShift, LoWord(lParam), HiWord(lParam))

            Case WM_MOUSELEAVE
                m_bInCtrl = False
                If m_State = 1 Then pvSetState 0
                RaiseEvent MouseExit

        End Select
        
        WindowProc = CallWindowProcA(prevBtnProc, hWnd, uMsg, wParam, lParam)
    Else
        Select Case uMsg
            Case WM_MOVE, WM_SIZE
                Call pvUpdatePosition
            Case WM_ENABLE
                EnableWindow hButton, wParam
        End Select

        WindowProc = CallWindowProcA(PrevWndProc, hWnd, uMsg, wParam, lParam)

    End If
    
End Function


'--> Publics Functions
Public Function CreateButton(ByVal hWndParent As Long, Optional ToolTipText As String) As Boolean
 
    If hButton Then Exit Function
    
    hParent = hWndParent

    hButton = CreateWindowEx(0&, "Button", vbNullString, WS_VISIBLE Or WS_CHILD, 0&, 0&, 0&, 0&, hParent, 0&, App.hInstance, ByVal 0&)
    
    If hButton Then
        SetParent hButton, GetDesktopWindow
        SetWindowLong hButton, GWL_HWNDPARENT, hParent
        
        Call SetWindowLongA(hButton, GWL_EXSTYLE, WS_EX_LAYERED)
           
        prevBtnProc = SetWindowLongA(hButton, GWL_WNDPROC, lpAdress)
        PrevWndProc = SetWindowLongA(hParent, GWL_WNDPROC, lpAdress)
        
        m_hwndTT = CreateWindowEx(WS_EX_TOPMOST, TOOLTIPS_CLASS, vbNullString, TTS_ALWAYSTIP Or WS_POPUP, 0&, 0&, 0&, 0&, hButton, 0&, App.hInstance, ByVal 0&)
        
        If m_hwndTT Then
            With tTI
                .cbSize = Len(tTI)
                .uFlags = TTF_IDISHWND Or TTF_SUBCLASS
                .uId = hButton
                .hWnd = hButton
                .lpszText = ToolTipText
            End With
            
            Call SendMessage(m_hwndTT, TTM_SETMAXTIPWIDTH, 0, ByVal 250&)
            Call SendMessage(m_hwndTT, TTM_ADDTOOL, 0, tTI)
        End If
        
        CreateButton = True
    End If

End Function

Public Function LoadImageFromFile(ByVal sFile As String) As Boolean
    On Local Error GoTo LoadImageFromFile_Error
    Dim hImage As Long
    Dim GdipToken As Long
    Dim GdipStartupInput As GdiplusStartupInput
    
    GdipStartupInput.GdiplusVersion = 1
    Call GdiplusStartup(GdipToken, GdipStartupInput, ByVal 0)
    
    If GdipLoadImageFromFile(StrPtr(sFile), hImage) = 0 Then
        If pvCreateDIB(hImage) Then
            pvSetState m_State
            LoadImageFromFile = True
        End If
        Call GdipDisposeImage(hImage)
    End If
    
    Call GdiplusShutdown(GdipToken)

LoadImageFromFile_Error:
End Function

Public Function LoadImageFromRes(ByVal ResIndex As Variant, ByVal ResSection As Variant, Optional VBglobal As IUnknown) As Boolean
    On Local Error GoTo LoadImageFromCustomRes_Error
    
    Dim bvData()    As Byte
    Dim oVBglobal   As VB.Global

    If VBglobal Is Nothing Then
        Set oVBglobal = VB.Global
    ElseIf TypeOf VBglobal Is VB.Global Then
        Set oVBglobal = VBglobal
    ElseIf VBglobal Is Nothing Then
        Set oVBglobal = VB.Global
    End If
    
    bvData = oVBglobal.LoadResData(ResIndex, ResSection)
    LoadImageFromRes = LoadImageFromStream(bvData)

LoadImageFromCustomRes_Error:
End Function

Public Function LoadImageFromStream(ByRef bvData() As Byte) As Boolean
    On Local Error GoTo LoadImageFromStream_Error
    Dim IStream     As IUnknown
    Dim hImage    As Long
    Dim GdipToken As Long
    Dim GdipStartupInput As GdiplusStartupInput
    
    GdipStartupInput.GdiplusVersion = 1
    Call GdiplusStartup(GdipToken, GdipStartupInput, ByVal 0)
        
    If IsArrayDim(VarPtrArray(bvData)) Then
    
        Call CreateStreamOnHGlobal(bvData(0), True, IStream)
        
        If Not IStream Is Nothing Then
            If GdipLoadImageFromStream(IStream, hImage) = 0 Then
                If pvCreateDIB(hImage) Then
                    pvSetState m_State
                    LoadImageFromStream = True
                End If
                Call GdipDisposeImage(hImage)
            End If
        End If
    
    End If
    
    Call GdiplusShutdown(GdipToken)
    
LoadImageFromStream_Error:
End Function

'-->Publics Propertys
Public Property Let MoveMode(ByVal lMode As EnuMoveMode)
    m_MoveMode = lMode
End Property

Public Property Get MoveMode() As EnuMoveMode
    MoveMode = m_MoveMode
End Property

Public Property Let Enabled(ByVal Value As Boolean)
     m_Enabled = Value
     EnableWindow hButton, m_Enabled
     pvSetState IIf(m_Enabled, 0, 3)
End Property

Public Property Get Enabled() As Boolean
     Enabled = m_Enabled
End Property

Public Property Let Alpha(ByVal Value As Long)
     If Value < 0 Then Value = 0
     If Value > 255 Then Value = 255
     tBLENDFUNCTION.SourceConstantAlpha = Value
     pvSetState m_State
End Property

Public Property Get Alpha() As Long
     Alpha = tBLENDFUNCTION.SourceConstantAlpha
End Property

Public Property Let Left(ByVal Value As Long)
    m_Rect.Left = Value: pvUpdatePosition
End Property

Public Property Get Left() As Long
    Left = m_Rect.Left
End Property

Public Property Let Top(ByVal Value As Long)
     m_Rect.Top = Value: pvUpdatePosition
End Property

Public Property Get Top() As Long
    Top = m_Rect.Top
End Property

Public Property Let Right(ByVal Value As Long)
    m_Rect.Right = Value: pvUpdatePosition
End Property

Public Property Get Right() As Long
    Right = m_Rect.Right
End Property

Public Property Let Bottom(ByVal Value As Long)
     m_Rect.Bottom = Value: pvUpdatePosition
End Property

Public Property Get Bottom() As Long
    Bottom = m_Rect.Bottom
End Property

Public Property Let Visible(ByVal Value As Boolean)
     m_Visible = Value
     ShowWindow hButton, IIf(Value, SW_SHOW, SW_HIDE)
End Property

Public Property Get Visible() As Boolean
    Visible = m_Visible
End Property

Public Property Let ToolTipText(ByVal sText As String)
     tTI.lpszText = sText
     If m_hwndTT Then Call SendMessage(m_hwndTT, TTM_UPDATETIPTEXT, 0, tTI)
End Property

Public Property Get ToolTipText() As String
    ToolTipText = tTI.lpszText
End Property

Public Property Get hWnd() As Long
    hWnd = hButton
End Property

Public Property Get ButtonWidth() As Long
    ButtonWidth = tSIZE.cx
End Property

Public Property Get ButtonHeight() As Long
    ButtonHeight = tSIZE.cy
End Property

Public Property Get ImageWidth() As Long
    ImageWidth = lWidth
End Property

Public Property Get ImageHeight() As Long
    ImageHeight = lHeight
End Property

Public Property Get ForceStatePress() As Boolean
    ForceStatePress = m_bForcePress
End Property

Public Property Let ForceStatePress(ByVal Value As Boolean)
     m_bForcePress = Value
     pvSetState m_State
End Property

'-->Private Sub
Private Sub Class_Initialize()
    Call InitCommonControls
    With tBLENDFUNCTION
        .AlphaFormat = AC_SRC_ALPHA
        .SourceConstantAlpha = 255
    End With
    m_Enabled = True
    m_Visible = True
    lpAdress = GetAdressOfWindowProc(Me)
End Sub

Private Sub Class_Terminate()
    Call pvCleanUp
    If prevBtnProc Then Call SetWindowLongA(hButton, GWL_WNDPROC, prevBtnProc)
    If PrevWndProc Then Call SetWindowLongA(hParent, GWL_WNDPROC, PrevWndProc)
    If hButton Then DestroyWindow hButton
    If m_hwndTT Then DestroyWindow m_hwndTT
End Sub

Private Sub pvUpdatePosition()
    Dim REC As RECT
    GetWindowRect hParent, REC
    Select Case m_MoveMode
        Case LeftTop
            SetWindowPos hButton, 0&, REC.Left + m_Rect.Left, REC.Top + m_Rect.Top, 0&, 0&, SWP_NOSIZE
        Case TopRight
            SetWindowPos hButton, 0&, REC.Right + m_Rect.Right - tSIZE.cx, REC.Top + m_Rect.Top, 0&, 0&, SWP_NOSIZE
        Case RightBottom
            SetWindowPos hButton, 0&, REC.Right + m_Rect.Right - tSIZE.cx, REC.Bottom + m_Rect.Bottom - tSIZE.cy, 0&, 0&, SWP_NOSIZE
        Case BottomLeft
            SetWindowPos hButton, 0&, REC.Left + m_Rect.Left, REC.Bottom + m_Rect.Bottom - tSIZE.cy, 0&, 0&, SWP_NOSIZE
    End Select
End Sub

Private Sub pvSetState(ByVal Index As Long)
    Dim tPT       As POINTAPI
    
    If m_bForcePress Then
        tPT.Y = (lHeight / 4) * 2
    Else
        tPT.Y = (lHeight / 4) * Index
    End If
    Call UpdateLayeredWindow(hButton, 0&, ByVal 0&, tSIZE, c_lhDC, tPT, 0&, tBLENDFUNCTION, ULW_ALPHA)
    m_State = Index
End Sub

Private Sub pvGetVirtualKeys(wParam As Long, Button As Integer, Shift As Integer)
    If (wParam And MK_CONTROL) = MK_CONTROL Then Shift = vbCtrlMask
    If (wParam And MK_SHIFT) = MK_SHIFT Then Shift = Shift Or vbShiftMask
    'If (GetAsyncKeyState(vbKeyMenu) < 0) Then Shift = Shift Or vbAltMask
    If (wParam And MK_LBUTTON) = MK_LBUTTON Then Button = vbLeftButton
    If (wParam And MK_MBUTTON) = MK_MBUTTON Then Button = vbMiddleButton
    If (wParam And MK_RBUTTON) = MK_RBUTTON Then Button = vbRightButton
End Sub

Private Sub pvTrackMouseLeave(ByVal lng_hWnd As Long)
    'Track the mouse leaving the indicated window
  Dim uTME As TRACKMOUSEEVENT_STRUCT
    With uTME
        .cbSize = Len(uTME)
        .dwFlags = TME_LEAVE
        .hwndTrack = lng_hWnd
    End With
    Call TrackMouseEvent(uTME)
End Sub

Private Sub pvCleanUp()
    Call DeleteObject(SelectObject(c_lhDC, m_OldBmp)): c_lDIB = 0
    Call DeleteDC(c_lhDC): c_lhDC = 0
End Sub

Private Sub LongToByte(ByVal lLong As Long, ByRef bReturn() As Byte, Optional I As Integer = 0)
    bReturn(I) = lLong And &HFF
    bReturn(I + 1) = (lLong And 65280) / &H100
    bReturn(I + 2) = (lLong And &HFF0000) / &H10000
    bReturn(I + 3) = ((lLong And &HFF000000) \ &H1000000) And &HFF
End Sub

'--> Private Functions
Private Function pvCreateDIB(ByVal hImage As Long) As Boolean
    Dim hGraphics       As Long
    Dim tBITMAPINFO     As BITMAPINFO
    
    Call pvCleanUp

    Call GdipGetImageWidth(hImage, lWidth)
    Call GdipGetImageHeight(hImage, lHeight)
    
    tSIZE.cx = lWidth:    tSIZE.cy = lHeight / 4

    With tBITMAPINFO.bmiHeader
        .biSize = Len(tBITMAPINFO.bmiHeader)
        .biBitCount = 32
        .biHeight = lHeight
        .biWidth = lWidth
        .biPlanes = 1
        .biSizeImage = .biWidth * .biHeight * 4
    End With

    c_lhDC = CreateCompatibleDC(0)
    c_lDIB = CreateDIBSection(c_lhDC, tBITMAPINFO, DIB_RGB_COLORS, ByVal 0&, 0&, 0&)
    m_OldBmp = SelectObject(c_lhDC, c_lDIB)
    
    If GdipCreateFromHDC(c_lhDC, hGraphics) = 0 Then
        'pvCreateDIB = GdipDrawImageI(hGraphics, hImage, 0, 0) = 0
        pvCreateDIB = GdipDrawImageRectRectI(hGraphics, hImage, 0, 0, lWidth, lHeight, 0, 0, lWidth, lHeight, &H2, 0&, 0&, 0&) = 0
        Call GdipDeleteGraphics(hGraphics)
    End If

End Function

Private Function GetAdressOfWindowProc(Obj As Object) As Long
    Dim WindowProcAddress As Long
    Dim pObj As Long
    Dim pVar As Long
 
    Dim I As Long
 
    For I = 0 To 40
        bvASM(I) = Choose(I + 1, &H55, &H8B, &HEC, &H83, &HC4, &HFC, &H8D, &H45, &HFC, &H50, &HFF, &H75, &H14, _
                                 &HFF, &H75, &H10, &HFF, &H75, &HC, &HFF, &H75, &H8, &H68, &H0, &H0, &H0, &H0, _
                                 &HB8, &H0, &H0, &H0, &H0, &HFF, &HD0, &H8B, &H45, &HFC, &HC9, &HC2, &H10, &H0)
    Next I
 
    pObj = ObjPtr(Obj)
 
    Call CopyMemory(pVar, ByVal pObj, 4)
    Call CopyMemory(WindowProcAddress, ByVal (pVar + 28), 4)
 
    Call LongToByte(pObj, bvASM, 23)
    Call LongToByte(WindowProcAddress, bvASM, 28)
    GetAdressOfWindowProc = VarPtr(bvASM(0))
End Function

Private Function pvIsCursorOverWindow(hWnd As Long) As Boolean
    Dim PT As POINTAPI
    GetCursorPos PT
    pvIsCursorOverWindow = (WindowFromPoint(PT.X, PT.Y) = hButton)
End Function

Private Function IsArrayDim(ByVal lpArray As Long) As Boolean
    Dim lAddress As Long
    Call CopyMemory(lAddress, ByVal lpArray, &H4)
    IsArrayDim = Not (lAddress = 0)
End Function

Private Function LoWord(ByVal lNum As Long) As Long
     LoWord = lNum And &HFFFF&
End Function
 
Private Function HiWord(ByVal lNum As Long) As Long
     HiWord = lNum \ &H10000 And &HFFFF&
End Function


