Attribute VB_Name = "MdlBrowseFolder"
Option Explicit

Private Declare Sub CoTaskMemFree Lib "ole32.dll" (ByVal hMem As Long)
Private Declare Function lstrcat Lib "kernel32" Alias "lstrcatA" (ByVal lpString1 As String, ByVal lpString2 As String) As Long
Private Declare Function SHBrowseForFolder Lib "shell32" (lpBI As BrowseInfo) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32" (ByVal pidList As Long, ByVal lpBuffer As String) As Long

Private Type BrowseInfo
    hWndOwner As Long
    pIDLRoot As Long
    pszDisplayName As Long
    lpszTitle As Long
    ulFlags As Long
    lpfnCallback As Long
    lParam As Long
    iImage As Long
End Type

Private Const BIF_USENEWUI              As Long = &H40
Private Const BIF_RETURNONLYFSDIRS      As Long = 1
Private Const MAX_PATH                  As Long = 260


Public Function ShowBrowseFolder(ByVal hwnd As Long, ByVal sTitle As String, bCreateFolder As Boolean) As String

    Dim iNull As Integer, lpIDList As Long, lResult As Long
    Dim udtBI As BrowseInfo, sPath As String

    With udtBI
        .hWndOwner = hwnd
        .lpszTitle = lstrcat(sTitle, "")
        .ulFlags = BIF_RETURNONLYFSDIRS Or IIf(bCreateFolder, BIF_USENEWUI, 0)
    End With

    lpIDList = SHBrowseForFolder(udtBI)
    
    If lpIDList Then
        sPath = String$(MAX_PATH, 0)
        SHGetPathFromIDList lpIDList, sPath
        CoTaskMemFree lpIDList
        iNull = InStr(sPath, vbNullChar)
        If iNull Then
            ShowBrowseFolder = Left$(sPath, iNull - 1)
        End If
    End If

End Function
