VERSION 5.00
Begin VB.Form FrmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Desconectado"
   ClientHeight    =   1320
   ClientLeft      =   45
   ClientTop       =   645
   ClientWidth     =   3165
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1320
   ScaleWidth      =   3165
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   600
      TabIndex        =   2
      Text            =   "10.0.0.3"
      Top             =   240
      Width           =   2295
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Desconectar"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1680
      TabIndex        =   1
      Top             =   720
      Width           =   1215
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Conectar"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   720
      Width           =   1335
   End
   Begin VB.Timer Timer1 
      Left            =   2520
      Top             =   0
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "IP:"
      Height          =   195
      Left            =   240
      TabIndex        =   3
      Top             =   270
      Width           =   195
   End
End
Attribute VB_Name = "FrmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'-----------------------------------------
' Autor: LeandroA
' Este proyecto comenz el 04/09/2007 en conjunto con Cobein el cual escribi alguna de estas clases.
' Publicacin:  03/02/2010
'
' Mejoras:
' 04/02/2010 Se modifica el sistema de precionado de teclas se implementa PostMessage, SendMessage y la funcion GetFocusHandle
' 04/02/2010 Soporte para la rueda del rato remoto WM_MOUSEWHEEL
'-----------------------------------------------------------------

' Apis Windows
Private Declare Function SetCursorPos Lib "user32" (ByVal x As Long, ByVal y As Long) As Long
Private Declare Function GetCursor Lib "user32" () As Long
Private Declare Sub keybd_event Lib "user32.dll" (ByVal bVk As Byte, ByVal bScan As Byte, ByVal dwFlags As Long, ByVal dwExtraInfo As Long)
Private Declare Sub mouse_event Lib "user32" (ByVal dwFlags As Long, ByVal dx As Long, ByVal dy As Long, ByVal cButtons As Long, ByVal dwExtraInfo As Long)
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDst As Any, pSrc As Any, ByVal ByteLen As Long)
Private Declare Function SetClipboardViewer Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function IsClipboardFormatAvailable Lib "user32" (ByVal wFormat As Long) As Long
Private Declare Function GetCursorInfo Lib "user32.dll" (ByRef pci As PCURSORINFO) As Long
Private Declare Function GetIconInfo Lib "user32.dll" (ByVal hIcon As Long, ByRef piconinfo As ICONINFO) As Long
Private Declare Function GetDIBits Lib "gdi32.dll" (ByVal aHDC As Long, ByVal hBitmap As Long, ByVal nStartScan As Long, ByVal nNumScans As Long, ByRef lpBits As Any, ByRef lpBI As BITMAPINFO, ByVal wUsage As Long) As Long
Private Declare Function DeleteObject Lib "gdi32.dll" (ByVal hObject As Long) As Long
Private Declare Function RtlGetCompressionWorkSpaceSize Lib "NTDLL" (ByVal flags As Integer, WorkSpaceSize As Long, UNKNOWN_PARAMETER As Long) As Long
Private Declare Function NtAllocateVirtualMemory Lib "ntdll.dll" (ByVal ProcHandle As Long, BaseAddress As Long, ByVal NumBits As Long, regionsize As Long, ByVal flags As Long, ByVal ProtectMode As Long) As Long
Private Declare Function RtlCompressBuffer Lib "NTDLL" (ByVal flags As Integer, ByVal BuffUnCompressed As Long, ByVal UnCompSize As Long, ByVal BuffCompressed As Long, ByVal CompBuffSize As Long, ByVal UNKNOWN_PARAMETER As Long, OutputSize As Long, ByVal WorkSpace As Long) As Long
Private Declare Function RtlDecompressBuffer Lib "NTDLL" (ByVal flags As Integer, ByVal BuffUnCompressed As Long, ByVal UnCompSize As Long, ByVal BuffCompressed As Long, ByVal CompBuffSize As Long, OutputSize As Long) As Long
Private Declare Function NtFreeVirtualMemory Lib "ntdll.dll" (ByVal ProcHandle As Long, BaseAddress As Long, regionsize As Long, ByVal flags As Long) As Long
Private Declare Function PostMessage Lib "user32.dll" Alias "PostMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByRef lParam As Long) As Long
Private Declare Function GetGUIThreadInfo Lib "user32.dll" (ByVal idThread As Long, ByRef pgui As GUITHREADINFO) As Long
Private Declare Function GetForegroundWindow Lib "user32.dll" () As Long
Private Declare Function GetWindowThreadProcessId Lib "user32.dll" (ByVal hwnd As Long, ByRef lpdwProcessId As Long) As Long


Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

' Utilizado para obtener el foco de la ventana hija (parecido GetFocus pero en una aplicacion externa)
Private Type GUITHREADINFO
    cbSize As Long
    flags As Long
    hwndActive As Long
    hwndFocus As Long
    hwndCapture As Long
    hwndMenuOwner As Long
    hwndMoveSize As Long
    hwndCaret As Long
    rcCaret As RECT
End Type
Private Type POINTAPI
    x               As Long
    y               As Long
End Type

' Recupera informacin del cursor.
Private Type PCURSORINFO
    cbSize          As Long
    flags           As Long
    hCursor         As Long
    ptScreenPos     As POINTAPI
End Type

' Utilizado para obtener la imgen en bits del cursor.
Private Type BITMAPINFOHEADER
    biSize          As Long
    biWidth         As Long
    biHeight        As Long
    biPlanes        As Integer
    biBitCount      As Integer
    biCompression   As Long
    biSizeImage     As Long
    biXPelsPerMeter As Long
    biYPelsPerMeter As Long
    biClrUsed       As Long
    biClrImportant  As Long
End Type

Private Type BITMAPINFO
    bmiHeader       As BITMAPINFOHEADER
    bmiColors(1 To 256) As Long
End Type

Private Type ICONINFO
    fIcon           As Long
    xHotspot        As Long
    yHotspot        As Long
    hbmMask         As Long
    hbmColor        As Long
End Type

'// Key Envent Constates
Private Const KEYEVENTF_EXTENDEDKEY     As Long = &H1
Private Const KEYEVENTF_KEYUP           As Long = &H2

'// Mouse Envent Constates
Private Const MOUSEEVENTF_ABSOLUTE      As Long = &H8000
Private Const MOUSEEVENTF_LEFTDOWN      As Long = &H2
Private Const MOUSEEVENTF_LEFTUP        As Long = &H4
Private Const MOUSEEVENTF_MIDDLEDOWN    As Long = &H20
Private Const MOUSEEVENTF_MIDDLEUP      As Long = &H40
Private Const MOUSEEVENTF_MOVE          As Long = &H1
Private Const MOUSEEVENTF_RIGHTDOWN     As Long = &H8
Private Const MOUSEEVENTF_RIGHTUP       As Long = &H10
Private Const MOUSEEVENTF_VIRTUALDESK   As Long = &H4000
Private Const MOUSEEVENTF_WHEEL         As Long = &H800
Private Const MOUSEEVENTF_XDOWN         As Long = &H80
Private Const MOUSEEVENTF_XUP           As Long = &H100

'// Windows Envent Mesage
Private Const WM_MOUSEMOVE              As Long = &H200
Private Const WM_LBUTTONDBLCLK          As Long = &H203
Private Const WM_LBUTTONDOWN            As Long = &H201
Private Const WM_LBUTTONUP              As Long = &H202
Private Const WM_RBUTTONDBLCLK          As Long = &H206
Private Const WM_RBUTTONDOWN            As Long = &H204
Private Const WM_RBUTTONUP              As Long = &H205
Private Const WM_KEYDOWN                As Long = &H100
Private Const WM_KEYUP                  As Long = &H101
Private Const WM_SYSKEYUP               As Long = &H105
Private Const WM_SYSKEYDOWN             As Long = &H104
Private Const WM_CHAR                   As Long = &H102
Private Const WM_CONTEXTMENU            As Long = &H7B
Private Const WM_DRAWCLIPBOARD          As Long = &H308
Private Const WM_MOUSEWHEEL             As Long = &H20A

Private WithEvents cScreenScan          As cRDSC                    '// Clase que escanea la pantalla en busca de cambios (Motor principal).
Attribute cScreenScan.VB_VarHelpID = -1
Private WithEvents cSocket              As cSocket                  '// Socket.
Attribute cSocket.VB_VarHelpID = -1
Private WithEvents cSubclass            As ClsSubclass              '// Subclasificacin para el portapapeles.
Attribute cSubclass.VB_VarHelpID = -1

Private Const HFRAMES                   As Long = 8                 '// Horizontal frames.
Private Const VFRAMES                   As Long = 8                 '// Vertical frames.

' Constantes para los tipos de datos arrivados.
Private Const DATA_MSG = 1
Private Const DATA_CLIPBOARD = 2
Private Const DATA_IMAGE = 3
Private Const DATA_SCREENINFO = 4
Private Const DATA_CURSOR = 5

' Constantes para los tipos de mensajes enviados y arrivados.
Private Const MSG_UPDATESCAN = 1
Private Const MSG_SETPIXELFORMAT = 2
Private Const MSG_SETCAPTURESIZE = 3
Private Const MSG_SETCURSOR As Long = 4
Private Const MSG_SENDCURSOR As Long = 5

' Tamao de la cabecera HeaderData.
Private Const LEN_HEADERDATA = 8

' Cabecera para los datos enviados o recibidos.
Private Type HeaderData
    DataType        As Long
    DataSize        As Long
End Type

' Tipo para los datos de tipo mensaje.
Private Type UDT_MSG
    uMsg            As Long
    wParam          As Long
    lParam          As Long
End Type

' Tipo utilizado para enviar los fragmentos de imgen.
Private Type DataSend
    FrameCount      As Long
    LenData         As Long
    PT()            As POINTAPI
    Data()          As Byte
End Type

' Variables internas.
Private EnviarFrames                As Boolean
Private HDSend                      As HeaderData
Private HDReceived                  As HeaderData
Private HeaderReceived              As Boolean
Private RemoteClipboardChange       As Boolean
Private bCaptureStretch             As Boolean
Private LasthCursor                 As Long

' Devuelve el foco de la ventana hija (parecido GetFocus pero en una aplicacion externa)
Private Function GetFocusHandle() As Long
    Dim GTI As GUITHREADINFO
    GTI.cbSize = Len(GTI)
    GetGUIThreadInfo GetWindowThreadProcessId(GetForegroundWindow, 0), GTI
    GetFocusHandle = GTI.hwndFocus
End Function

' Subclasificacin para interceptar los cambios en el portapapeles.
Private Sub cSubclass_WindowProc(Cancel As Boolean, hwnd As Long, uMsg As Long, wParam As Long, lParam As Long)
    If cSocket.State <> sckConnected Then Exit Sub
    Select Case uMsg
        Case WM_DRAWCLIPBOARD
            If RemoteClipboardChange Then Exit Sub
            If IsClipboardFormatAvailable(vbCFText) <> 0 Then
                SendCilpboard
            End If
    End Select
End Sub


' Envia informacin de la pantalla.
Private Sub SendScreenInfo()

    Dim FrameSize       As POINTAPI
    Dim ScreenSize      As POINTAPI
    Dim bData()         As Byte
    
    If cSocket.State = sckConnected Then

        HDSend.DataType = DATA_SCREENINFO
        HDSend.DataSize = 16
        
        ScreenSize.x = Screen.Width / Screen.TwipsPerPixelX
        ScreenSize.y = Screen.Height / Screen.TwipsPerPixelY
        FrameSize.x = ScreenSize.x / cScreenScan.VerticalFrames
        FrameSize.y = ScreenSize.y / cScreenScan.HorizontalFrames
    
        ReDim bData(23)
        
        CopyMemory bData(0), HDSend, LEN_HEADERDATA
        CopyMemory bData(LEN_HEADERDATA), FrameSize, 8
        CopyMemory bData(16), ScreenSize, 8
        cSocket.SendData bData
    End If
    
End Sub


' Envia mensajes cortos.
Private Sub SendMSG(ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long)

    If cSocket.State = sckConnected Then

        Dim Data()      As Byte
        Dim tMSG        As UDT_MSG
        Dim LenUDT      As Long
    
        LenUDT = LenB(tMSG)                                     'Tamao de la estructura
        
        HDSend.DataSize = LenUDT
        HDSend.DataType = DATA_MSG
        
        ReDim Data(LenUDT + LEN_HEADERDATA - 1) As Byte          'Redimencionamos el array
        
        'Rellenamos la extructura con los datos.
        tMSG.uMsg = uMsg
        tMSG.wParam = wParam
        tMSG.lParam = lParam

        'Copiamos la estructura en el array DATA
        CopyMemory Data(0), HDSend, LenB(HDSend)
        CopyMemory Data(LenB(HDSend)), tMSG, LenUDT
        
        'Enviamos el array
        cSocket.SendData Data
    
    End If
End Sub


' Envia el array de bits del cursor actual.
Private Sub SendDataCursor(ByVal hCursor As Long)
On Error GoTo CursorErr

    If cSocket.State = sckConnected Then

        Dim Data()          As Byte
        Dim CursorData()    As Byte
        Dim CompressData()  As Byte

        If SaveCursorToStream(hCursor, CursorData) Then
           
            Compress CursorData, CompressData

            HDSend.DataSize = UBound(CompressData) + 4
            HDSend.DataType = DATA_CURSOR
            
            ReDim Data(LenB(HDSend) + HDSend.DataSize) As Byte
            
            CopyMemory Data(0), HDSend, LenB(HDSend)
            CopyMemory Data(LenB(HDSend)), hCursor, 4

            CopyMemory Data(LenB(HDSend) + 4), CompressData(0), UBound(CompressData) + 1
            cSocket.SendData Data
            
        End If
    
    End If
    
CursorErr:
    Debug.Print Err.Description
End Sub


' Envia el texto en el portapapeles.
Private Sub SendCilpboard()
On Error GoTo ClipBoardErr

    Dim Data()      As Byte
    Dim sText       As String


    If cSocket.State = sckConnected Then

        sText = Clipboard.GetText
        
        HDSend.DataSize = Len(sText)
        HDSend.DataType = DATA_CLIPBOARD
        
        'Redimencionamos el array
        ReDim Data(LenB(HDSend) + HDSend.DataSize - 1) As Byte
        
        'Copiamos la estructura en el array DATA
        CopyMemory Data(0), HDSend, LenB(HDSend)
        CopyMemory Data(LenB(HDSend)), ByVal sText, HDSend.DataSize
        
        'Enviamos el array
        cSocket.SendData Data
    
    End If
    
ClipBoardErr:
    Debug.Print Err.Description
End Sub


' Agrega el texto recibido al portapapeles local.
Private Sub ClipboardSetText(ByVal sText As String)

On Local Error GoTo ClipBoardErr
    RemoteClipboardChange = True
    Clipboard.Clear
    Clipboard.SetText sText
    RemoteClipboardChange = False
    Exit Sub
ClipBoardErr:
    RemoteClipboardChange = False
    Debug.Print Err.Description
    
End Sub


' Verifica si el puntero del cursor cambi su icono,
' si es as envia el handle de ste al receptor el cual verificar si ya lo posee en su cach
' de no ser as, el receptor enviar un mensaje pidiendo el array de bits sobre dicho cursor.
Private Sub CaptureCursor()
    Dim CI As PCURSORINFO
    CI.cbSize = Len(CI)
    GetCursorInfo CI
    If CI.hCursor <> LasthCursor Then
        LasthCursor = CI.hCursor
        SendMSG MSG_SETCURSOR, LasthCursor, 0
    End If
End Sub


' Rutina que procesa los mensajes arrivados.
Private Sub ProcessMsg(tMSG As UDT_MSG)
        
    Select Case tMSG.uMsg

        Case WM_MOUSEMOVE
            SetCursorPos LoWord(tMSG.lParam), HiWord(tMSG.lParam)
            CaptureCursor
            
        Case WM_LBUTTONDOWN
            mouse_event MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0
            
        Case WM_LBUTTONUP
            mouse_event MOUSEEVENTF_LEFTUP, 0, 0, 0, 0
            
        Case WM_LBUTTONDBLCLK
            mouse_event MOUSEEVENTF_LEFTDOWN Or MOUSEEVENTF_LEFTUP, 0, 0, 0, 0
            mouse_event MOUSEEVENTF_LEFTDOWN Or MOUSEEVENTF_LEFTUP, 0, 0, 0, 0
            
        Case WM_RBUTTONDOWN
            mouse_event MOUSEEVENTF_RIGHTDOWN, 0, 0, 0, 0
            
        Case WM_RBUTTONUP
           mouse_event MOUSEEVENTF_RIGHTUP, 0, 0, 0, 0
           
        Case WM_RBUTTONDBLCLK
            mouse_event MOUSEEVENTF_RIGHTDOWN Or MOUSEEVENTF_RIGHTUP, 0, 0, 0, 0
            mouse_event MOUSEEVENTF_RIGHTDOWN Or MOUSEEVENTF_RIGHTUP, 0, 0, 0, 0
            
        Case WM_CHAR, WM_CONTEXTMENU, WM_MOUSEWHEEL
            Dim Handle As Long
            Handle = GetFocusHandle
            If Handle <> 0 And tMSG.wParam <> vbKeyTab Then
                PostMessage Handle, tMSG.uMsg, tMSG.wParam, tMSG.lParam
            End If
            
        Case WM_SYSKEYUP, WM_SYSKEYDOWN

            If tMSG.uMsg = WM_SYSKEYDOWN Then
                keybd_event tMSG.wParam, 0, KEYEVENTF_EXTENDEDKEY, 0
            Else
                keybd_event tMSG.wParam, 0, KEYEVENTF_EXTENDEDKEY Or KEYEVENTF_KEYUP, 0
            End If
            
        Case WM_KEYDOWN, WM_KEYUP

            Select Case tMSG.wParam
                Case 112 To 123, 37 To 40, 92, vbKeyControl, vbKeyEscape, vbKeyScrollLock, vbKeyShift, vbKeySnapshot, vbKeyPause, vbKeyPrint, vbKeyTab, vbKeyReturn
                
                    If tMSG.wParam = vbKeySnapshot Then
                        keybd_event tMSG.wParam, 0, KEYEVENTF_EXTENDEDKEY, 0
                    End If
                
                    If tMSG.uMsg = WM_KEYDOWN Then
                        keybd_event tMSG.wParam, 0, KEYEVENTF_EXTENDEDKEY, 0
                    Else
                        keybd_event tMSG.wParam, 0, KEYEVENTF_EXTENDEDKEY Or KEYEVENTF_KEYUP, 0
                    End If
                    
                Case Else
                    Handle = GetFocusHandle
                    If Handle <> 0 Then
                        SendMessage Handle, tMSG.uMsg, tMSG.wParam, tMSG.lParam
                    Else
                        If tMSG.uMsg = WM_KEYDOWN Then
                            keybd_event tMSG.wParam, 0, KEYEVENTF_EXTENDEDKEY, 0
                        Else
                            keybd_event tMSG.wParam, 0, KEYEVENTF_EXTENDEDKEY Or KEYEVENTF_KEYUP, 0
                        End If
                    End If
                    
            End Select
            
        Case MSG_UPDATESCAN
            EnviarFrames = True
            cScreenScan.UpdateViewport
            
        Case MSG_SETPIXELFORMAT
            SetPixelFormat tMSG.wParam
        
        Case MSG_SETCAPTURESIZE
            cScreenScan.ScreenWidth = tMSG.wParam
            cScreenScan.ScreenHeight = tMSG.lParam
            cScreenScan.AdjustedCapture = (tMSG.wParam + tMSG.lParam) > 0
            EnviarFrames = True
            cScreenScan.UpdateViewport
            
        Case MSG_SENDCURSOR
            SendDataCursor tMSG.wParam
            
    End Select

End Sub


'// evento que devuelve las cabeseras de las cordenadas y el binario de los cuadros modificados en la pantalla
Private Sub cScreenScan_FrameChanged(ByVal Change As Boolean, FramesCount As Long, bCoordData() As Byte, bImageData() As Byte)

    Dim DS As DataSend
    Dim bData() As Byte
    

    If Change Then

        If cSocket.State <> sckConnected Then Exit Sub
        
        If EnviarFrames = False Then Exit Sub
        
        EnviarFrames = False
        Timer1.Enabled = False

        HDSend.DataType = DATA_IMAGE
        HDSend.DataSize = UBound(bCoordData) + UBound(bImageData)
        
        DS.FrameCount = FramesCount
        DS.LenData = UBound(bImageData) + 1
        
        ReDim bData(16 + HDSend.DataSize)
        
        CopyMemory bData(0), HDSend, LenB(HDSend)
        CopyMemory bData(LEN_HEADERDATA), DS, LEN_HEADERDATA
        CopyMemory bData(16), bCoordData(0), UBound(bCoordData) + 1
        CopyMemory bData(16 + UBound(bCoordData)), bImageData(0), UBound(bImageData) + 1

        cSocket.SendData bData

    Else
        EnviarFrames = True
        Timer1.Enabled = True
    End If
End Sub

' Botn para desconectar.
Private Sub Command2_Click()

    Timer1.Enabled = False
    Timer1.Interval = 0

    Command2.Enabled = False
    Command1.Enabled = True
    Me.Caption = "Desconectado"

    cSocket.CloseSocket
        
    cScreenScan.ScreenWidth = 0
    cScreenScan.ScreenHeight = 0
    cScreenScan.AdjustedCapture = False ' Default.
    cScreenScan.PixelFormatCompress = PixelFormat4bppIndexed    ' Default.
    
    cScreenScan.ResetFrames
    
End Sub

' Botn para conectar.
Private Sub Command1_Click()
    cSocket.CloseSocket
    cSocket.Connect Text1, 100
End Sub


Private Sub Form_Load()
    Set cScreenScan = New cRDSC         ' Clase para interceptar los cambios en la pantalla y generar una tira de imgenes.
    Set cSocket = New cSocket           ' Clase para manejo de socket.
    Set cSubclass = New ClsSubclass     ' Clase para subclasificar el portapapeles.
    
    SetClipboardViewer Me.hwnd
    
    If cSubclass.ssc_Subclass(Me.hwnd) Then
        cSubclass.ssc_AddMsg Me.hwnd, WM_DRAWCLIPBOARD, MSG_AFTER
    End If
    
    cScreenScan.PixelFormatCompress = PixelFormat4bppIndexed    ' Default.

End Sub


' Descargamos todo.
Private Sub Form_Unload(Cancel As Integer)
    Set cSocket = Nothing
    Set cScreenScan = Nothing
    Set cSubclass = Nothing
End Sub


' Calidad de los fragmentos.
Private Sub SetPixelFormat(ByVal Value As Long)
    With cScreenScan
        Select Case Value
            Case 0: .PixelFormatCompress = PixelFormat1bppIndexed
            Case 1: .PixelFormatCompress = PixelFormat4bppIndexed
            Case 2: .PixelFormatCompress = PixelFormat8bppIndexed
            Case 3: .PixelFormatCompress = PixelFormat16bppRGB
            Case 4: .PixelFormatCompress = PixelFormat24bppRGB
            Case 5: .PixelFormatCompress = PixelFormat32bppRGB
        End Select
        .ResetFrames
    End With
End Sub


' Datos arrivados.
Private Sub cSocket_OnDataArrival(ByVal bytesTotal As Long)
    
    Dim tMSG As UDT_MSG
    Dim Data() As Byte
    
    Do While cSocket.BytesReceived > 0
        
        ' Obtiene la cabecera de los datos.
        If HeaderReceived = False Then
            If bytesTotal >= LenB(HDReceived) Then
                cSocket.GetData Data, vbArray + vbByte, LenB(HDReceived)
                CopyMemory HDReceived, Data(0), LenB(HDReceived)
                bytesTotal = bytesTotal - LenB(HDReceived)
                HeaderReceived = True
            End If
        End If
        
        If HeaderReceived = False Then Exit Sub
                
        ' Si el tamao recibido es igual al de la cabecera entonces...
        If bytesTotal >= HDReceived.DataSize Then

                cSocket.GetData Data, vbArray + vbByte, HDReceived.DataSize
                
                ' Segn el tipo de datos...
                Select Case HDReceived.DataType
                    Case DATA_MSG
                        CopyMemory tMSG, Data(0), LenB(tMSG)
                        ProcessMsg tMSG
                    Case DATA_CLIPBOARD
                         Dim sText As String
                         sText = String(HDReceived.DataSize, Chr(0))
                         CopyMemory ByVal sText, Data(0), HDReceived.DataSize
                         ClipboardSetText sText
                End Select
                
                bytesTotal = bytesTotal - HDReceived.DataSize
                HeaderReceived = False

        Else
            Exit Sub
        End If
    Loop
End Sub



Private Sub cSocket_OnClose()
    Command2_Click
End Sub

Private Sub cSocket_OnConnect()

    Command1.Enabled = False
    Command2.Enabled = True
    Me.Caption = "Conectado"

    Call SendScreenInfo
    
    EnviarFrames = True
    Timer1.Interval = 500
    Timer1.Enabled = True
 
End Sub

Private Sub cSocket_OnError(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    Command2_Click
    MsgBox Number & ": " & Description
End Sub

' Timer para ir verificando cambios en la pantalla.
Private Sub Timer1_Timer()
    cScreenScan.UpdateViewport
End Sub


'// Devuelve el DWord de dos nmero pasado como parmetro
Function MakeDWord(LoWord As Long, HiWord As Long) As Long
      MakeDWord = (HiWord * &H10000) Or (LoWord And &HFFFF&)
End Function


 '// Devuelve el LoWord del nmero pasado como parmetro
Private Function LoWord(ByVal Numero As Long) As Long
    LoWord = Numero And &HFFFF&
End Function


'// Devuelve el HiWord del nmero pasado como parmetro
Private Function HiWord(ByVal Numero As Long) As Long
    HiWord = Numero \ &H10000 And &HFFFF&
End Function

' Funcin para comprimir un array de bits.
Public Function Compress(Data() As Byte, Out() As Byte) As Long
    Dim WorkSpaceSize As Long
    Dim WorkSpace As Long
    ReDim Out(UBound(Data) * 1.13 + 4)
 
    RtlGetCompressionWorkSpaceSize 2, WorkSpaceSize, 0
    NtAllocateVirtualMemory -1, WorkSpace, 0, WorkSpaceSize, 4096, 64
    RtlCompressBuffer 2, VarPtr(Data(0)), UBound(Data) + 1, VarPtr(Out(0)), (UBound(Data) * 1.13 + 4), 0, Compress, WorkSpace
    NtFreeVirtualMemory -1, WorkSpace, 0, 16384
    ReDim Preserve Out(Compress)
 
End Function
 
' Funcin para obtener el icono del cursor en un array de bits.
' By LaVolpe
Private Function SaveCursorToStream(ByVal hIcon As Long, bData() As Byte) As Boolean

    If hIcon = 0 Then Exit Function

    Dim bits() As Long, pow2(0 To 8) As Long
    Dim scanWidth As Long, maskScan As Long, clrScan As Long
    Dim bNewColor As Boolean
    Dim x As Long, y As Long, palIndex As Long, palShift As Long, palPtr As Long
    Dim ICI As ICONINFO, BHI As BITMAPINFO
      
    If GetIconInfo(hIcon, ICI) = 0& Then Exit Function

    If ICI.hbmColor = 0& Then
        ' black and white image, already in needed format
        BHI.bmiHeader.biSize = 40
        If GetDIBits(Me.hdc, ICI.hbmMask, 0&, 0&, ByVal 0&, BHI, 0&) Then
            BHI.bmiColors(2) = vbWhite
            With BHI.bmiHeader
                maskScan = ByteAlignOnWord(1, .biWidth)
                .biBitCount = 1
                .biClrImportant = 2
                .biClrUsed = 2
                .biCompression = 0&
                .biSizeImage = maskScan * .biHeight
                ReDim bData(0 To .biSizeImage + 69&)
                
                ReDim b(0 To .biSizeImage)
                If GetDIBits(Me.hdc, ICI.hbmMask, 0&, .biHeight, bData(70), BHI, 0&) Then
                    DeleteObject ICI.hbmMask: ICI.hbmMask = 0&
                    .biClrImportant = 2&
                    .biClrUsed = 2&
                    bData(8) = .biClrUsed
                    bData(2) = 2  ' type: cursor' icon = 1
                    bData(4) = 1  ' count
                    If .biWidth < 256 Then bData(6) = .biWidth
                    If .biHeight < 512 Then bData(7) = .biHeight \ 2
                    bData(10) = ICI.xHotspot '   1 ' planes
                    bData(12) = ICI.yHotspot '.biBitCount
                    CopyMemory bData(14), CLng(UBound(bData) - 21&), 4& ' bytes in resource
                    bData(18) = 22 ' offset into directory where BHI starts
                    CopyMemory bData(bData(18)), BHI, 48&
                    SaveCursorToStream = True
                End If
            End With
        End If

    Else
        BHI.bmiHeader.biSize = 40
        If GetDIBits(Me.hdc, ICI.hbmColor, 0&, 0&, ByVal 0&, BHI, 0&) Then
            With BHI.bmiHeader
                scanWidth = .biWidth * 4&
                maskScan = ByteAlignOnWord(1, .biWidth)
                .biBitCount = 32&
                .biSize = 40
                .biCompression = 0&
                .biSizeImage = scanWidth * .biHeight
                ReDim bits(0 To .biWidth * .biHeight - 1&)
            End With
            If GetDIBits(Me.hdc, ICI.hbmColor, 0&, BHI.bmiHeader.biHeight, bits(0), BHI, 0&) Then
                DeleteObject ICI.hbmColor: ICI.hbmColor = 0&
                With BHI.bmiHeader
                    For x = 0& To .biWidth * .biHeight - 1&
                        If bits(x) <> (bits(x) And &HFFFFFF) Then
                            .biClrImportant = 0&
                            Exit For
                        End If
                        If .biBitCount = 32 Then
                            palIndex = FindColor(BHI.bmiColors(), bits(x), .biClrImportant, bNewColor)
                            If bNewColor Then
                                If .biClrImportant = 256& Then ' either 24 bit or 32 bit icon
                                    .biBitCount = 24
                                    .biClrImportant = 0&
                                ElseIf bNewColor Then
                                    .biClrImportant = .biClrImportant + 1
                                    If palIndex < .biClrImportant Then
                                        CopyMemory BHI.bmiColors(palIndex + 1&), BHI.bmiColors(palIndex), (.biClrImportant - palIndex) * 4&
                                    End If
                                    BHI.bmiColors(palIndex) = bits(x)
                                End If
                            End If
                        End If
                    Next
                End With
                If BHI.bmiHeader.biClrImportant Then
                    With BHI.bmiHeader
                        Select Case .biClrImportant
                            Case Is < 3: .biBitCount = 1
                            Case Is < 17: .biBitCount = 4
                            Case Else: .biBitCount = 8
                        End Select
                        pow2(0) = 1&
                        For x = 1& To .biBitCount
                            pow2(x) = pow2(x - 1&) * 2&
                        Next
                        clrScan = ByteAlignOnWord(.biBitCount, .biWidth)
                        .biClrUsed = pow2(.biBitCount)
                        .biSizeImage = clrScan * .biHeight
                        ReDim bData(0 To .biSizeImage + maskScan * .biHeight + .biClrUsed * 4& + 61&)
                        x = 0&
                        For y = x To .biHeight - 1&
                            palShift = 8& - .biBitCount
                            palPtr = 62& + .biClrUsed * 4& + y * clrScan
                            For x = x To x + .biWidth - 1&
                                palIndex = FindColor(BHI.bmiColors(), bits(x), .biClrImportant, bNewColor) - 1&
                                bData(palPtr) = bData(palPtr) Or (palIndex * pow2(palShift))
                                If palShift = 0& Then
                                    palPtr = palPtr + 1&
                                    palShift = 8& - .biBitCount
                                Else
                                    palShift = palShift - .biBitCount
                                End If
                            Next
                        Next
                        If .biClrUsed < 256 Then bData(8) = .biClrUsed
                    End With
                Else ' can be 24 or 32 bit color
                    With BHI.bmiHeader
                        clrScan = ByteAlignOnWord(.biBitCount, .biWidth)
                        .biSizeImage = clrScan * .biHeight
                        ReDim bData(0 To .biSizeImage + maskScan * .biHeight + 61&)
                        If .biBitCount = 32 Then
                            CopyMemory bData(62), bits(0), .biSizeImage
                        Else
                            x = 0&
                            For y = x To .biHeight - 1&
                                palPtr = y * clrScan + 62&
                                For x = x To .biWidth - 1&
                                    CopyMemory bData(palPtr), bits(x), 3&
                                    palPtr = palPtr + 3&
                                Next
                            Next
                        End If
                    End With
                End If
                Erase bits()
                
                bData(2) = 2  ' type: icon
                bData(4) = 1  ' count
                If BHI.bmiHeader.biWidth < 256 Then bData(6) = BHI.bmiHeader.biWidth
                If BHI.bmiHeader.biHeight < 256 Then bData(7) = BHI.bmiHeader.biHeight
                BHI.bmiHeader.biHeight = BHI.bmiHeader.biHeight + BHI.bmiHeader.biHeight
                'bData(10) = 1 ' planes
                'bData(12) = BHI.bmiHeader.biBitCount
                
                bData(10) = ICI.xHotspot '   1 ' planes
                bData(12) = ICI.yHotspot '.biBitCount
                
                CopyMemory bData(14), CLng(UBound(bData) - 21&), 4& ' bytes in resource
                bData(18) = 22 ' offset into directory where BHI starts
                CopyMemory bData(bData(18)), BHI, BHI.bmiHeader.biClrUsed * 4& + 40&
                If ICI.hbmMask Then
                    BHI.bmiColors(2) = vbWhite
                    With BHI.bmiHeader
                        .biBitCount = 1
                        .biClrImportant = 2
                        .biClrUsed = 2
                        .biHeight = .biHeight \ 2
                        .biSizeImage = 0&
                        palPtr = UBound(bData) - maskScan * .biHeight + 1&
                    End With
                    GetDIBits Me.hdc, ICI.hbmMask, 0&, BHI.bmiHeader.biHeight, bData(palPtr), BHI, 0&
                    DeleteObject ICI.hbmMask: ICI.hbmMask = 0&
                End If
                SaveCursorToStream = True
            End If
        End If
    End If
        
    If ICI.hbmColor Then DeleteObject ICI.hbmColor
    If ICI.hbmMask Then DeleteObject ICI.hbmMask

End Function

Private Function FindColor(ByRef PaletteItems() As Long, ByVal Color As Long, ByVal Count As Long, ByRef isNew As Boolean) As Long

    ' MODIFIED BINARY SEARCH ALGORITHM -- Divide and conquer.
    ' Binary search algorithms are about the fastest on the planet, but
    ' its biggest disadvantage is that the array must already be sorted.
    ' Ex: binary search can find a value among 1 million values between 1 and 20 iterations
    
    ' [in] PaletteItems(). Long Array to search within. Array must be 1-bound
    ' [in] Color. A value to search for. Order is always ascending
    ' [in] Count. Number of items in PaletteItems() to compare against
    ' [out] isNew. If Color not found, isNew is True else False
    ' [out] Return value: The Index where Color was found or where the new Color should be inserted

    Dim UB As Long, LB As Long
    Dim newIndex As Long
    
    If Count = 0& Then
        FindColor = 1&
        isNew = True
        Exit Function
    End If
    
    UB = Count
    LB = 1&
    
    Do Until LB > UB
        newIndex = LB + ((UB - LB) \ 2&)
        If PaletteItems(newIndex) = Color Then
            Exit Do
        ElseIf PaletteItems(newIndex) > Color Then ' new color is lower in sort order
            UB = newIndex - 1&
        Else ' new color is higher in sort order
            LB = newIndex + 1&
        End If
    Loop

    If LB > UB Then  ' color was not found
            
        If Color > PaletteItems(newIndex) Then newIndex = newIndex + 1&
        isNew = True
        
    Else
        isNew = False
    End If
    
    FindColor = newIndex

End Function

Private Function ByteAlignOnWord(ByVal bitDepth As Byte, ByVal Width As Long) As Long
    ' function to align any bit depth on dWord boundaries
    ByteAlignOnWord = (((Width * bitDepth) + &H1F&) And Not &H1F&) \ &H8&
End Function

