VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cBitmap"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : cBitmap
' DateTime  : 04/09/2007 03:36
' Authors   : LeandroA, Cobein
' Purpose   : A class to store a bitmap.
'---------------------------------------------------------------------------------------
'
'This class is a modified version of SP McMahon's cBitmap.cls

Option Explicit

Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal hdc As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function GetDesktopWindow Lib "user32" () As Long
Private Declare Function GetDC Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function ReleaseDC Lib "user32" (ByVal hWnd As Long, ByVal hdc As Long) As Long
    
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long

' Memory DC & Bitmap to hold the bitmap
Private lCDC                As Long
Private c_lhDC              As Long
Private c_lhBitmap          As Long
Private c_lhBitmapOld       As Long

' Width & Height of the bitmap
Private c_lWidth            As Long
Private c_lHeight           As Long


Public Property Get hBitmap() As Long
    hBitmap = c_lhBitmap
End Property


Public Function CreateAtSize(ByVal lDX As Long, ByVal lDY As Long) As Boolean

    If c_lhBitmap Then
        SelectObject c_lhDC, c_lhBitmapOld
        DeleteObject c_lhBitmap
        c_lhBitmap = 0
    End If
    
    If (c_lhDC <> 0) Then
        c_lhBitmap = CreateCompatibleBitmap(lCDC, lDX, lDY)
        If (c_lhBitmap <> 0) Then
            c_lhBitmapOld = SelectObject(c_lhDC, c_lhBitmap)
        End If
    End If
    
    c_lWidth = lDX:    c_lHeight = lDY
    
End Function


Property Get Width() As Long
    Width = c_lWidth
End Property


Property Get Height() As Long
    Height = c_lHeight
End Property


Property Get hdc() As Long
    hdc = c_lhDC
End Property


Private Sub Class_Initialize()
    lCDC = GetDC(GetDesktopWindow)
    c_lhDC = CreateCompatibleDC(lCDC)
End Sub


Private Sub Class_Terminate()
    SelectObject c_lhDC, c_lhBitmapOld
    DeleteDC lCDC
    DeleteDC c_lhDC
    DeleteObject c_lhBitmap
    
End Sub



