VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cPNG"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Verwendet das IStream-Interface
' Download IStream-TLB von MadMax unter
' http://mitglied.lycos.de/real51/directdl.php?file=IStream.zip
' Project/References/ -> IStream Interface TypeLibrary

' ----==== GDI+ Const ====----
Private Const ClsIdPNG As String = "{557CF406-1A04-11D3-9A73-0000F81EF32E}"
Private Const GdiPlusVersion As Long = 1&

' ----==== sonstige Const ====----
Private Const DIB_RGB_COLORS As Long = 0&
Private Const BI_RGB As Long = 0&

' ----==== GDI+ Enums ====----
Private Enum Status
    OK = 0
    GenericError = 1
    InvalidParameter = 2
    OutOfMemory = 3
    ObjectBusy = 4
    InsufficientBuffer = 5
    NotImplemented = 6
    Win32Error = 7
    WrongState = 8
    Aborted = 9
    FileNotFound = 10
    ValueOverflow = 11
    AccessDenied = 12
    UnknownImageFormat = 13
    FontFamilyNotFound = 14
    FontStyleNotFound = 15
    NotTrueTypeFont = 16
    UnsupportedGdiplusVersion = 17
    GdiplusNotInitialized = 18
    PropertyNotFound = 19
    PropertyNotSupported = 20
    ProfileNotFound = 21
End Enum

' ----==== sonstige Enums ====----
Public Enum PixelFormat
    PixelFormat1bppIndexed = 1
    PixelFormat4bppIndexed = 4
    PixelFormat8bppIndexed = 8
    PixelFormat16bppRGB = 16
    PixelFormat24bppRGB = 24
    PixelFormat32bppRGB = 32
End Enum

' ----==== GDI+ Types ====----
Private Type GDIPlusStartupInput
    GdiPlusVersion              As Long
    DebugEventCallback          As Long
    SuppressBackgroundThread    As Long
    SuppressExternalCodecs      As Long
End Type

' ----==== sonstige Types ====----
Private Type BITMAP
    bmType                      As Long
    bmWidth                     As Long
    bmHeight                    As Long
    bmWidthBytes                As Long
    bmPlanes                    As Integer
    bmBitsPixel                 As Integer
    bmBits                      As Long
End Type

Private Type BitmapInfoHeader
    biSize                      As Long
    biWidth                     As Long
    biHeight                    As Long
    biPlanes                    As Integer
    biBitCount                  As Integer
    biCompression               As Long
    biSizeImage                 As Long
    biXPelsPerMeter             As Long
    biYPelsPerMeter             As Long
    biClrUsed                   As Long
    biClrImportant              As Long
End Type

Private Type RGBQUAD
    rgbBlue                     As Byte
    rgbGreen                    As Byte
    rgbRed                      As Byte
    rgbReserved                 As Byte
End Type

Private Type BITMAPINFO256
    bmiHeader                   As BitmapInfoHeader
    bmiColors(0 To 255)         As RGBQUAD
End Type

Private Type GUID
    Data1                       As Long
    Data2                       As Integer
    Data3                       As Integer
    Data4(0 To 7)               As Byte
End Type

' ----==== GDI+ Deklarationen ====----
Private Declare Function GdiplusShutdown Lib "gdiplus" ( _
                         ByVal token As Long) As Status
                         
Private Declare Function GdiplusStartup Lib "gdiplus" ( _
                         ByRef token As Long, _
                         ByRef lpInput As GDIPlusStartupInput, _
                         ByRef lpOutput As Any) As Status
                         
Private Declare Function GdipCreateBitmapFromGdiDib256 Lib "gdiplus" _
                         Alias "GdipCreateBitmapFromGdiDib" ( _
                         ByRef mGdiBitmapInfo As BITMAPINFO256, _
                         ByVal mGdiBitmapData As Long, _
                         ByRef mBitmap As Long) As Status
                         
Private Declare Function GdipDisposeImage Lib "gdiplus" ( _
                         ByVal mImage As Long) As Status
                         
Private Declare Function GdipSaveImageToStream Lib "gdiplus" ( _
                         ByVal Image As Long, _
                         ByVal Stream As IStream, _
                         ByRef ClsidEncoder As GUID, _
                         ByRef EncoderParams As Any) As Status
                         
Private Declare Function GdipLoadImageFromStream Lib "gdiplus" ( _
                         ByVal Stream As IUnknown, _
                         ByRef Image As Long) As Status
                         
Private Declare Function GdipCreateFromHDC Lib "gdiplus" ( _
                         ByVal hdc As Long, _
                         ByRef graphics As Long) As Status
                         
Private Declare Function GdipDeleteGraphics Lib "gdiplus" ( _
                         ByVal graphics As Long) As Status
                         
Private Declare Function GdipDrawImageI Lib "gdiplus" ( _
                         ByVal graphics As Long, _
                         ByVal Image As Long, _
                         ByVal x As Long, _
                         ByVal y As Long) As Status
                         
' ----==== GDI32 Deklarationen ====----
Private Declare Function GetDIBits256 Lib "gdi32" _
                         Alias "GetDIBits" ( _
                         ByVal aHDC As Long, _
                         ByVal hBitmap As Long, _
                         ByVal nStartScan As Long, _
                         ByVal nNumScans As Long, _
                         ByRef lpBits As Any, _
                         ByRef lpBI As BITMAPINFO256, _
                         ByVal wUsage As Long) As Long
                         
Private Declare Function GetObject Lib "gdi32" _
                         Alias "GetObjectA" ( _
                         ByVal hObject As Long, _
                         ByVal nCount As Long, _
                         ByRef lpObject As Any) As Long
                         
' ----==== OLE32 Deklarationen ====----
Private Declare Function CLSIDFromString Lib "ole32" ( _
                         ByVal str As Long, _
                         ByRef id As GUID) As Long

Private Declare Function CreateStreamOnHGlobal Lib "ole32.dll" ( _
                         ByRef hGlobal As Any, _
                         ByVal fDeleteOnRelease As Long, _
                         ByRef ppstm As Any) As Long

' ----==== USER32 Deklarationen ====----
Private Declare Function GetDC Lib "user32" ( _
                         ByVal hwnd As Long) As Long
                         
Private Declare Function ReleaseDC Lib "user32" ( _
                         ByVal hwnd As Long, _
                         ByVal hdc As Long) As Long

' ----==== USER32 Deklarationen ====----
Private Declare Sub GetSafeArrayPointer Lib "msvbvm60.dll" _
                    Alias "GetMem4" ( _
                    ByRef pArray() As Any, _
                    ByRef sfaPtr As Long)
                    
' ----==== Variablen ====----
Private lngToken As Long


Public Function RenderPNGFromStream(ByVal DestHdc As Long, ByVal x As Long, ByVal y As Long, pngStream() As Byte) As Boolean
    
    Dim memStream           As IUnknown
    Dim lngBitmap           As Long
    Dim lngGraphics         As Long
    Dim lngPtr              As Long
    
    ' ist GDI+ initialisiert
    If lngToken <> 0 Then
    
        Call GetSafeArrayPointer(pngStream(), lngPtr)
        
        If lngPtr > 0 Then
            ' Stream vom Bytearray erstellen
            If CreateStreamOnHGlobal(pngStream(0), 0&, memStream) = 0 Then
                ' GDI+ Bitmap aus dem Stream erstellen
                If GdipLoadImageFromStream(memStream, lngBitmap) = OK Then
                    ' ist ein DC vorhanden
                    If DestHdc <> 0 Then
                        ' Graphics-Objekt von DC erstellen
                        If GdipCreateFromHDC(DestHdc, lngGraphics) = OK Then
                            ' lngBitmap in lngGraphics zeichnen
                            If GdipDrawImageI(lngGraphics, lngBitmap, x, y) = OK Then
                                RenderPNGFromStream = True
                            End If
                            ' lngGraphics lschen
                            Call GdipDeleteGraphics(lngGraphics)
                        End If
                    End If
                    ' lngBitmap lschen
                    Call GdipDisposeImage(lngBitmap)
                End If
                Set memStream = Nothing
            End If
        End If
    End If
    
End Function


Public Function GetStreamFromBitmap(ByVal hBitmap As Long, ByVal BitsPerPixel As PixelFormat, ByRef OutStream() As Byte, Optional ByVal Width As Long, Optional ByVal Height As Long) As Boolean
    
    Dim lngDC               As Long
    Dim lngBitmap           As Long
    Dim lngStride           As Long
    Dim tBitmap             As BITMAP
    Dim tBITMAPINFO         As BITMAPINFO256
    Dim tGUID               As GUID
    Dim bytData()           As Byte
    Dim memStream           As IStream '<- IStream-Interface
    Dim curSize             As Currency
    Dim lngSize             As Long
    Dim lngBytesRead        As Long
    
    ' ist GDI+ initialisiert
    If lngToken <> 0 Then
    
        ' BitsPerPixel auf gltige Werte prfen
        Select Case BitsPerPixel
        
            Case 1, 4, 8, 16, 24, 32
                ' wenn kein Bild vorhanden ist
                If hBitmap = 0 Then
                    ' Funktion verlassen
                    Exit Function
                End If
                
            Case Else
                MsgBox "Fehler!" & vbCrLf & "Dieses Bildformat wird nicht untersttzt!"
                ' Funktion verlassen
                Exit Function
            
        End Select
        
        ' InPicture.Handle -> tBitmap
        If GetObject(hBitmap, Len(tBitmap), tBitmap) <> 0 Then
        
        'Width = IIf(Width, Width, tBitmap.bmWidth)
        
            tBITMAPINFO.bmiHeader.biHeight = IIf(Height, Height, tBitmap.bmHeight)
            tBITMAPINFO.bmiHeader.biWidth = IIf(Width, Width, tBitmap.bmWidth)
            tBITMAPINFO.bmiHeader.biPlanes = tBitmap.bmPlanes
            tBITMAPINFO.bmiHeader.biBitCount = BitsPerPixel
            tBITMAPINFO.bmiHeader.biSize = Len(tBITMAPINFO.bmiHeader)
            tBITMAPINFO.bmiHeader.biCompression = BI_RGB
            
            ' Breite einer Zeile, inklusiv eventuell vorhander PadBytes, in
            ' Abhngigkeit vom PixelFormat berechnen

            Select Case BitsPerPixel
            
                Case 1
                    lngStride = ((tBitmap.bmWidth + 31) And Not 31) \ 8
                Case 4
                    lngStride = ((tBitmap.bmWidth + 7) And Not 7) \ 2
                Case 8
                    lngStride = (tBitmap.bmWidth + 3) And Not 3
                Case 16
                    lngStride = ((tBitmap.bmWidth * 2) + 2) And Not 2
                Case 24
                    lngStride = ((tBitmap.bmWidth * 3) + 3) And Not 3
                Case 32
                    lngStride = tBitmap.bmWidth * 4
                
            End Select
            
            ' ByteArray zur Aufnahme der DIB-Daten dimensionieren
            ReDim bytData((tBitmap.bmHeight * lngStride) - 1)
            
            ' DC des Desktop ermitteln
            lngDC = GetDC(0&)
            
            ' ist ein DC vorhanden
            If lngDC <> 0 Then
            
                ' DIB-Daten auslesen -> bytData
                If GetDIBits256(lngDC, hBitmap, 0&, tBitmap.bmHeight, bytData(0), _
                    tBITMAPINFO, DIB_RGB_COLORS) <> 0 Then
                    ' GDI+ Bitmap aus den DIB-Daten erstellen -> lngBitmap
                    If GdipCreateBitmapFromGdiDib256(tBITMAPINFO, VarPtr(bytData( _
                        0)), lngBitmap) = OK Then
                        ' Stream erstellen
                        If CreateStreamOnHGlobal(ByVal 0&, 0&, memStream) = 0 Then
                            ' CLSID fr PNG
                            If CLSIDFromString(StrPtr(ClsIdPNG), tGUID) = 0 Then
                                If GdipSaveImageToStream(lngBitmap, _
                                    memStream, tGUID, ByVal 0&) = OK Then
                                    ' Gre des Streams ermitteln
                                    If memStream.Seek(ByVal 0, STREAM_SEEK_END, _
                                        curSize) = 0 Then
                                        ' Zurck zum Anfang des Streams
                                        If memStream.Seek(ByVal 0, STREAM_SEEK_SET, _
                                            ByVal 0) = 0 Then
                                            ' Gre berechnen
                                            lngSize = CLng(curSize * 10000)
                                            ' Bytearray dimensionieren
                                            ReDim OutStream(0 To lngSize - 1)
                                            ' Daten aus dem Stream in das Bytearray
                                            ' kopieren
                                            If memStream.Read(OutStream(0), lngSize, _
                                                lngBytesRead) = 0 Then
                                                Call memStream.SetSize(0) ' <- This Line
                                                GetStreamFromBitmap = True
                                            End If
                                        End If
                                    End If
                                End If
                            End If
                            ' Stream lschen
                            Set memStream = Nothing
                        End If
                        ' lngBitmap lschen
                        Call GdipDisposeImage(lngBitmap)
                    End If
                End If
                ' DC freigeben
                Call ReleaseDC(0&, lngDC)
            End If
        End If
    End If
    
End Function


Private Sub Class_Initialize()
    Dim GdipStartupInput As GDIPlusStartupInput
    GdipStartupInput.GdiPlusVersion = GdiPlusVersion
    If GdiplusStartup(lngToken, GdipStartupInput, ByVal 0&) <> OK Then
        MsgBox "GDI+ konnte nicht initialisiert werden.", vbOKOnly Or _
            vbInformation, "GDI+ Error"
    End If
End Sub


Private Sub Class_Terminate()
    If lngToken <> 0 Then
        Call GdiplusShutdown(lngToken)
    End If
End Sub


