VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cRDSC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'---------------------------------------------------------------------------------------
' Module    : cRDSC, Remote Desktop Screen Capture
' DateTime  : 05/09/2007 00:35
' Authors   : LeandroA, Cobein
' Purpose   :
'---------------------------------------------------------------------------------------

Option Explicit

Private Const HFRAMES                   As Long = 8 '// Horizontal frames
Private Const VFRAMES                   As Long = 8 '// Vertical frames

Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal Length As Long)
Private Declare Function GetDC Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function GetDesktopWindow Lib "user32" () As Long
Private Declare Function BitBlt Lib "gdi32.dll" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function StretchBlt Lib "gdi32.dll" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long
Private Declare Function SetStretchBltMode Lib "gdi32" (ByVal hdc As Long, ByVal nStretchMode As Long) As Long
Private Declare Function DeleteDC Lib "gdi32.dll" (ByVal hdc As Long) As Long
Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Private Const CAPTUREBLT    As Long = &H40000000
Private Const SRCCOPY       As Long = &HCC0020

Private Type POINTAPI
    x As Long
    y As Long
End Type

Private Type DataSend
    FrameCount As Long
    LenData As Long
    PT() As POINTAPI
    Data() As Byte
End Type


'Public Event FrameChanged(ByVal Change As Boolean, bData() As Byte)
Public Event FrameChanged(ByVal Change As Boolean, FramesCount As Long, bCoordData() As Byte, bImageData() As Byte)

Private c_lHFrames          As Long         '// Horizontal frames count
Private c_lVFrames          As Long         '// Vertical frames count

Private c_lFrameW           As Long         '// Frame width
Private c_lFrameH           As Long         '// Frame height

Private c_cTempScreen       As cBitmap
Private c_CaptureScreen     As cBitmap

Private c_lvCRCTable()      As Long         '// CRC Checksum Table
Private LastCRCTable()      As Long         '// CRC Checksum Table

Dim m_PixelFormat           As PixelFormat
Dim DeskDC                  As Long
Dim cDib                    As New cDIBSection
Dim c_cPNG                  As cPNG
Dim m_AdjustedCapture       As Boolean
Dim m_ScreenWidth           As Long
Dim m_ScreenHeight          As Long

Property Let AdjustedCapture(ByVal Value As Boolean)
    m_AdjustedCapture = Value
    ResetFrames
End Property

Property Get AdjustedCapture() As Boolean
    AdjustedCapture = m_AdjustedCapture
End Property

Property Let HorizontalFrames(ByVal lFrames As Long)
    c_lHFrames = lFrames
    ResetFrames
End Property

Property Get HorizontalFrames() As Long
    HorizontalFrames = c_lHFrames
End Property

Property Let VerticalFrames(ByVal lFrames As Long)
    c_lVFrames = lFrames
    ResetFrames
End Property

Property Get VerticalFrames() As Long
    VerticalFrames = c_lVFrames
End Property

Property Let PixelFormatCompress(ByVal New_PixelFormat As PixelFormat)
    m_PixelFormat = New_PixelFormat
End Property

Property Get PixelFormatCompress() As PixelFormat
    PixelFormatCompress = m_PixelFormat
End Property

Property Let ScreenWidth(ByVal Value As Long)
    If Value = 0 Then
        m_ScreenWidth = Screen.Width / Screen.TwipsPerPixelX
    Else
        m_ScreenWidth = Value
    End If
    
    ResetFrames
End Property

Property Get ScreenWidth() As Long
    ScreenWidth = m_ScreenWidth
End Property

Property Let ScreenHeight(ByVal Value As Long)
    If Value = 0 Then
        m_ScreenHeight = Screen.Height / Screen.TwipsPerPixelY
    Else
        m_ScreenHeight = Value
    End If
    
    ResetFrames
End Property

Property Get ScreenHeight() As Long
    ScreenHeight = m_ScreenHeight
End Property


Public Sub ResetFrames()

    c_lFrameW = m_ScreenWidth / c_lHFrames   '// Get default frame width
    c_lFrameH = m_ScreenHeight / c_lVFrames  '// Get default frame height

    ReDim c_lvCRCTable(c_lHFrames, c_lVFrames) '// Redim CRC Checksum Table
    ReDim LastCRCTable(c_lHFrames, c_lVFrames)
    
    cDib.Init c_lFrameW, c_lFrameH
    
    c_cTempScreen.CreateAtSize c_lFrameW, c_lFrameH * (c_lHFrames * c_lVFrames)

    c_CaptureScreen.CreateAtSize m_ScreenWidth, m_ScreenHeight
    
    If m_AdjustedCapture Then
        SetStretchBltMode c_CaptureScreen.hdc, vbPaletteModeNone
    End If
    
End Sub


Private Sub Class_Initialize()
    Set c_cTempScreen = New cBitmap

    c_lHFrames = HFRAMES '// Set default frames
    c_lVFrames = VFRAMES '// Set default frames
    
    m_ScreenWidth = Screen.Width / Screen.TwipsPerPixelX
    m_ScreenHeight = Screen.Height / Screen.TwipsPerPixelY
    
    m_PixelFormat = PixelFormat8bppIndexed

    
    DeskDC = GetDC(GetDesktopWindow)

    Set c_cPNG = New cPNG
    
    Set c_CaptureScreen = New cBitmap
    
    ResetFrames
End Sub


Private Sub Class_Terminate()
    '// Cleanup
    DeleteDC DeskDC
    Set cDib = Nothing
    Set c_cPNG = Nothing
    Set c_cTempScreen = Nothing
    Set c_CaptureScreen = Nothing

End Sub


Public Sub UpdateViewport() 'As Boolean
Attribute UpdateViewport.VB_UserMemId = 0

    Dim x               As Integer
    Dim y               As Integer
    Dim lRet            As Long
    Dim yPos            As Long
    Dim StrHeather      As String
    Dim bytCoord()        As Byte
    Dim bytData()       As Byte
    Dim FrameCount      As Long
    Dim DS              As DataSend
    Dim i               As Long

    If m_AdjustedCapture = False Then
        BitBlt c_CaptureScreen.hdc, 0, 0, c_CaptureScreen.Width, c_CaptureScreen.Height, DeskDC, 0, 0, SRCCOPY Or CAPTUREBLT
    Else
        'deshabilit CAPTUREBLT para no producir mucho el parpadeo del mouse.
        'para solucionarlo hay que crear otra cBitmap con el tamao de la pantalla,
        'pintarlo con BitBlt + SRCCOPY Or CAPTUREBLT y luego utlizar StretchBlt + SRCCOPY sobre c_CaptureScreen
        StretchBlt c_CaptureScreen.hdc, 0, 0, c_CaptureScreen.Width, c_CaptureScreen.Height, DeskDC, 0, 0, Screen.Width / Screen.TwipsPerPixelX, Screen.Height / Screen.TwipsPerPixelY, SRCCOPY 'Or CAPTUREBLT
    End If
    
    ReDim DS.PT(0)

    For x = 0 To c_lHFrames - 1
                
        For y = 0 To c_lVFrames - 1

            BitBlt cDib.hdc, 0, 0, c_lFrameW, c_lFrameH, c_CaptureScreen.hdc, c_lFrameW * x, c_lFrameH * y, vbSrcCopy
            lRet = cDib.CRC
           
            If Not lRet = c_lvCRCTable(x, y) Then
                
                c_lvCRCTable(x, y) = lRet
                
                DS.PT(i).x = c_lFrameW * x
                DS.PT(i).y = c_lFrameH * y
                
                i = i + 1
                
                ReDim Preserve DS.PT(i)

                BitBlt c_cTempScreen.hdc, 0, yPos, c_lFrameW, c_lFrameH, cDib.hdc, 0, 0, vbSrcCopy
                yPos = yPos + c_lFrameH
                
            End If
            
        Next y
    Next x


    If yPos Then
        c_cPNG.GetStreamFromBitmap c_cTempScreen.hBitmap, m_PixelFormat, DS.Data, c_lFrameW, yPos
        
        FrameCount = UBound(DS.PT)

        ReDim bytCoord(FrameCount * 8) As Byte
        CopyMemory bytCoord(0), DS.PT(0), FrameCount * 8

        RaiseEvent FrameChanged(True, FrameCount, bytCoord, DS.Data)
    Else
        RaiseEvent FrameChanged(False, 0, bytCoord, DS.Data)
    End If
    
    
    
End Sub




