VERSION 5.00
Begin VB.Form FrmMain 
   BackColor       =   &H00404040&
   Caption         =   "Esperando conexin ..."
   ClientHeight    =   8925
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   10140
   Icon            =   "FmrMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   8925
   ScaleWidth      =   10140
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox PicSize 
      BorderStyle     =   0  'None
      Height          =   350
      Left            =   9600
      MousePointer    =   8  'Size NW SE
      Picture         =   "FmrMain.frx":058A
      ScaleHeight     =   345
      ScaleWidth      =   345
      TabIndex        =   3
      Top             =   8400
      Visible         =   0   'False
      Width           =   350
   End
   Begin VB.HScrollBar HScroll1 
      Height          =   350
      LargeChange     =   100
      Left            =   0
      Max             =   100
      TabIndex        =   2
      Top             =   8640
      Visible         =   0   'False
      Width           =   2895
   End
   Begin VB.VScrollBar VScroll1 
      Height          =   3135
      LargeChange     =   100
      Left            =   9840
      Max             =   100
      TabIndex        =   1
      Top             =   0
      Visible         =   0   'False
      Width           =   350
   End
   Begin VB.PictureBox PicRender 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Height          =   7215
      Left            =   120
      ScaleHeight     =   7215
      ScaleWidth      =   9600
      TabIndex        =   0
      Top             =   600
      Width           =   9600
   End
   Begin VB.Menu MnuConexion 
      Caption         =   "Conexin"
      Begin VB.Menu SubMnuConexion 
         Caption         =   "Conectar"
      End
   End
   Begin VB.Menu MnuVer 
      Caption         =   "Ver"
      Begin VB.Menu SubMnuVer 
         Caption         =   "Pixel Format 1bpp"
         Index           =   0
      End
      Begin VB.Menu SubMnuVer 
         Caption         =   "Pixel Format 4bpp"
         Checked         =   -1  'True
         Index           =   1
      End
      Begin VB.Menu SubMnuVer 
         Caption         =   "Pixel Format 8bpp"
         Index           =   2
      End
      Begin VB.Menu SubMnuVer 
         Caption         =   "Pixel Format 16bpp"
         Index           =   3
      End
      Begin VB.Menu SubMnuVer 
         Caption         =   "Pixel Format 24bpp"
         Index           =   4
      End
      Begin VB.Menu SubMnuVer 
         Caption         =   "-"
         Index           =   5
      End
      Begin VB.Menu SubMnuVer 
         Caption         =   "Ajustar a la Ventana"
         Index           =   6
      End
      Begin VB.Menu SubMnuVer 
         Caption         =   "-"
         Index           =   7
      End
      Begin VB.Menu SubMnuVer 
         Caption         =   "FullScreen"
         Index           =   8
         Shortcut        =   {F11}
      End
   End
   Begin VB.Menu MnuAyuda 
      Caption         =   "Ayuda"
      Begin VB.Menu SubMnuAyuda 
         Caption         =   "Acerca de"
      End
   End
End
Attribute VB_Name = "FrmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'-----------------------------------------------------------------
' Autor: LeandroA
' Web: www.leandroascierto.com.ar
' Este proyecto comenz el 04/09/2007 en conjunto con Cobein.
' Publicacin:  03/02/2010
'
' Mejoras:
' 04/02/2010 Se modifica el sistema de precionado de teclas se implementa PostMessage, SendMessage y la funcion GetFocusHandle
' 04/02/2010 Soporte para la rueda del rato remoto WM_MOUSEWHEEL
'-----------------------------------------------------------------

Private Declare Sub InitCommonControls Lib "comctl32" ()
Private Declare Function LoadLibrary Lib "kernel32.dll" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Private Declare Function FreeLibrary Lib "kernel32.dll" (ByVal hLibModule As Long) As Long
Private Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" (ByVal hwnd As Long, ByVal Msg As Long, wParam As Any, lParam As Any) As Long
Private Declare Function GetSystemMetrics Lib "user32" (ByVal nIndex As Long) As Long
Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal Length As Long)
Private Declare Function SetClipboardViewer Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function IsClipboardFormatAvailable Lib "user32" (ByVal wFormat As Long) As Long
Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function SetWindowPos Lib "user32.dll" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Private Declare Function GetIconInfo Lib "user32.dll" (ByVal hIcon As Long, ByRef piconinfo As ICONINFO) As Long
Private Declare Function DeleteObject Lib "gdi32.dll" (ByVal hObject As Long) As Long
Private Declare Function CreateIconIndirect Lib "user32.dll" (ByRef piconinfo As ICONINFO) As Long
Private Declare Function CreateIconFromResourceEx Lib "user32.dll" (ByRef presbits As Any, ByVal dwResSize As Long, ByVal fIcon As Long, ByVal dwVer As Long, ByVal cxDesired As Long, ByVal cyDesired As Long, ByVal flags As Long) As Long
Private Declare Function DestroyIcon Lib "user32.dll" (ByVal hIcon As Long) As Long
Private Declare Function DestroyCursor Lib "user32.dll" (ByVal hCursor As Long) As Long
Private Declare Function SetCursor Lib "user32.dll" (ByVal hCursor As Long) As Long
Private Declare Function RtlGetCompressionWorkSpaceSize Lib "NTDLL" (ByVal flags As Integer, WorkSpaceSize As Long, UNKNOWN_PARAMETER As Long) As Long
Private Declare Function NtAllocateVirtualMemory Lib "ntdll.dll" (ByVal ProcHandle As Long, BaseAddress As Long, ByVal NumBits As Long, regionsize As Long, ByVal flags As Long, ByVal ProtectMode As Long) As Long
Private Declare Function RtlCompressBuffer Lib "NTDLL" (ByVal flags As Integer, ByVal BuffUnCompressed As Long, ByVal UnCompSize As Long, ByVal BuffCompressed As Long, ByVal CompBuffSize As Long, ByVal UNKNOWN_PARAMETER As Long, OutputSize As Long, ByVal WorkSpace As Long) As Long
Private Declare Function RtlDecompressBuffer Lib "NTDLL" (ByVal flags As Integer, ByVal BuffUnCompressed As Long, ByVal UnCompSize As Long, ByVal BuffCompressed As Long, ByVal CompBuffSize As Long, OutputSize As Long) As Long
Private Declare Function NtFreeVirtualMemory Lib "ntdll.dll" (ByVal ProcHandle As Long, BaseAddress As Long, regionsize As Long, ByVal flags As Long) As Long
Private Declare Function GetMenu Lib "user32.dll" (ByVal hwnd As Long) As Long
Private Declare Function SetMenu Lib "user32.dll" (ByVal hwnd As Long, ByVal hMenu As Long) As Long
Private Declare Function ClientToScreen Lib "user32.dll" (ByVal hwnd As Long, ByRef lpPoint As POINTAPI) As Long
Private Declare Function ScreenToClient Lib "user32.dll" (ByVal hwnd As Long, ByRef lpPoint As POINTAPI) As Long

Private Const HWND_TOPMOST          As Long = -1
Private Const HWND_NOTOPMOST        As Long = -2

Private Const SWP_NOACTIVATE        As Long = &H10
Private Const SWP_NOSIZE            As Long = &H1
Private Const SWP_NOMOVE            As Long = &H2
Private Const SWP_SHOWWINDOW        As Long = &H40

Private Const GWL_STYLE             As Long = (-16)

Private Const WS_MAXIMIZEBOX        As Long = &H10000
Private Const WS_MINIMIZEBOX        As Long = &H20000
Private Const WS_THICKFRAME         As Long = &H40000
Private Const WS_SYSMENU            As Long = &H80000
Private Const WS_CAPTION            As Long = &HC00000

'// SystemMetrics Constantes (usado en el ancho y alto del los Scroll).
Private Const SM_CYHSCROLL          As Long = 3
Private Const SM_CXVSCROLL          As Long = 2

'// Windows Constantes (para interceptar los eventos del PicRender).
Private Const WM_MOUSEMOVE          As Long = &H200
Private Const WM_LBUTTONDBLCLK      As Long = &H203
Private Const WM_LBUTTONDOWN        As Long = &H201
Private Const WM_LBUTTONUP          As Long = &H202
Private Const WM_RBUTTONDBLCLK      As Long = &H206
Private Const WM_RBUTTONDOWN        As Long = &H204
Private Const WM_RBUTTONUP          As Long = &H205
Private Const WM_KEYDOWN            As Long = &H100
Private Const WM_KEYUP              As Long = &H101
Private Const WM_SYSKEYUP           As Long = &H105
Private Const WM_SYSKEYDOWN         As Long = &H104
Private Const WM_CHAR               As Long = &H102
Private Const WM_CONTEXTMENU        As Long = &H7B
Private Const WM_MOUSEWHEEL         As Long = &H20A
Private Const WM_DRAWCLIPBOARD      As Long = &H308
Private Const WM_ENTERSIZEMOVE      As Long = &H231
Private Const WM_EXITSIZEMOVE       As Long = &H232
Private Const WM_SIZING             As Long = &H214

Private Const ICRESVER              As Long = &H30000
Private Const LR_DEFAULTSIZE        As Long = &H40



' Utilizado para la creacin del icono del cursor.
Private Type ICONINFO
    fIcon       As Long
    xHotspot    As Long
    yHotspot    As Long
    hbmMask     As Long
    hbmColor    As Long
End Type

Private Type POINTAPI
    x           As Long
    y           As Long
End Type

' Cabecera para los datos enviados o recibidos.
Private Type HeaderData
    DataType    As Long
    DataSize    As Long
End Type

' Tipo utilizado para recibir los fragmentos de imgen.
Private Type DataGraphic
    FrameCount  As Long
    LenData     As Long
    PT()        As POINTAPI
    Data()      As Byte
End Type

' Tipo para los datos de tipo mensaje.
Private Type UDT_MSG
    uMsg        As Long
    wParam      As Long
    lParam      As Long
End Type

' Tipo para almacenar las medidas de la pantalla remota.
Private Type RemoteScreenInfo
    Width       As Long
    Height      As Long
End Type

' Tipo para almacenar los cursores en memoria.
Private Type CacheCursors
    id          As Long
    hCursor     As Long
End Type

' Constantes para los tipos de datos arrivados.
Private Const DATA_MSG              As Long = 1
Private Const DATA_CLIPBOARD        As Long = 2
Private Const DATA_IMAGE            As Long = 3
Private Const DATA_SCREENINFO       As Long = 4
Private Const DATA_CURSOR           As Long = 5

' Constantes para los tipos de mensajes arrivados.
Private Const MSG_UPDATESCAN        As Long = 1
Private Const MSG_SETPIXELFORMAT    As Long = 2
Private Const MSG_SETCAPTURESIZE    As Long = 3
Private Const MSG_SETCURSOR         As Long = 4
Private Const MSG_SENDCURSOR        As Long = 5

Private Const LEN_HEADERDATA        As Long = 8

' Subclasificacin (PicRender, VScrollBar1, HScrollBar1).
Private WithEvents cSubclass        As ClsSubclass
Attribute cSubclass.VB_VarHelpID = -1
Private WithEvents cSubclassSroll   As ClsSubclass
Attribute cSubclassSroll.VB_VarHelpID = -1
Private WithEvents cSocket          As cSocket                  '// Socket
Attribute cSocket.VB_VarHelpID = -1
Private cPNG                        As clsGDIPlus

' Variables internas.
Dim HDSend                  As HeaderData
Dim HDReceived              As HeaderData
Dim RSI                     As RemoteScreenInfo
Dim CC()                    As CacheCursors
Dim HeaderReceived          As Boolean
Dim RemoteClipboardChange   As Boolean
Dim bFullScreen             As Boolean
Dim bAdjustedCapture        As Boolean
Dim bDrawPicture            As Boolean
Dim bIsMaximezed            As Boolean
Dim hCurrentCursor          As Long
Dim hMenu                   As Long
Dim mIndexPixelFormat       As Long
Dim hModShell32             As Long
Dim c_lFrameW               As Long
Dim c_lFrameH               As Long



' Almacena en un array el handle del cursor creado.
Private Function AddCursorToCache(id As Long, hCursor As Long) As Boolean
    Dim lCount As Long
    lCount = UBound(CC)
    CC(lCount).id = id
    CC(lCount).hCursor = hCursor
    ReDim Preserve CC(lCount + 1)
    hCurrentCursor = hCursor
    SetCursor hCursor
End Function


' Verifica mediante el id (handle del cursor remoto) si el handle ya fue enviado.
Private Function ExistCursorInCache(ByVal id As Long) As Long
    Dim i As Long
    ExistCursorInCache = -1
    For i = 0 To UBound(CC)
        If CC(i).id = id Then
            ExistCursorInCache = i
            Exit Function
        End If
    Next
End Function


' Elimina todos los cursores de la memoria.
Private Sub ClearCacheCursor()
    Dim i As Long
    For i = 0 To UBound(CC)
        DestroyCursor CC(i).hCursor
    Next
    ReDim CC(0)
    hCurrentCursor = 0
End Sub


' Funcin para descomprimir un array (utilizado para el cursor).
Public Function DeCompress(Data() As Byte, dest() As Byte) As Long
    If UBound(Data) Then
        ReDim dest(UBound(Data) * 12.5)
        RtlDecompressBuffer 2, VarPtr(dest(0)), (UBound(Data) * 12.5), VarPtr(Data(0)), UBound(Data), DeCompress
        ReDim Preserve dest(DeCompress - 1)
    End If
End Function


Private Sub cSocket_OnError(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    MsgBox Number & ": " & Description
    cSocket_onClose
End Sub


' Agrega el estilo XP esto es para los Scrollbars o controles que puedan agregarse.
Private Sub Form_Initialize()
    hModShell32 = LoadLibrary("shell32.dll")
    InitCommonControls
End Sub


Private Sub Form_Load()
On Error GoTo ERR_HANDLER
    ' Subclasifica los Scrollbar para interceptar la rueda del mouse (para uso interno de esta ventana).
    Set cSubclassSroll = New ClsSubclass
    Set cSocket = New cSocket
    Set cPNG = New clsGDIPlus
    
    ' Inicializa GDI+ de forma segura para prevenir crash en el IDE de VB.
    cPNG.ManageGDIToken Me.hwnd
    
    With cSubclassSroll
        .ssc_Subclass HScroll1.hwnd
        .ssc_Subclass VScroll1.hwnd
        .ssc_Subclass Me.hwnd
        .ssc_AddMsg HScroll1.hwnd, WM_MOUSEWHEEL, MSG_AFTER
        .ssc_AddMsg VScroll1.hwnd, WM_MOUSEWHEEL, MSG_AFTER
        .ssc_AddMsg Me.hwnd, WM_SIZING, MSG_BEFORE
        .ssc_AddMsg Me.hwnd, WM_EXITSIZEMOVE, MSG_AFTER
    End With

    ' Toma las medidas de los Scroll del sistema.
    HScroll1.Height = GetSystemMetrics(SM_CYHSCROLL) * Screen.TwipsPerPixelY
    VScroll1.Width = GetSystemMetrics(SM_CYHSCROLL) * Screen.TwipsPerPixelY
    PicSize.Width = VScroll1.Width: PicSize.Height = HScroll1.Height

    ' Api para que lleguen los cambios del portapapeles a la ventana.
    SetClipboardViewer PicRender.hwnd

    ' Subclasifica los PicRender para interceptar todos los eventos que enviaremos (Mouse y Teclado).
    Set cSubclass = New ClsSubclass
    
    ' Agrega los MSG necesarios.
    With cSubclass
        .ssc_Subclass PicRender.hwnd                                ' Start Subclass.
        .ssc_AddMsg PicRender.hwnd, WM_MOUSEMOVE, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_LBUTTONDOWN, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_LBUTTONUP, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_LBUTTONDBLCLK, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_RBUTTONDOWN, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_RBUTTONUP, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_RBUTTONDBLCLK, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_KEYDOWN, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_KEYUP, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_DRAWCLIPBOARD, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_SYSKEYUP, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_SYSKEYDOWN, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_CHAR, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_CONTEXTMENU, MSG_AFTER
        .ssc_AddMsg PicRender.hwnd, WM_MOUSEWHEEL, MSG_AFTER
        
        
    End With

    mIndexPixelFormat = 1       'PixelFormat4bppIndexed Default.
    ReDim CC(0)

    cSocket.LocalPort = 100     ' Puerto default y nico.
    cSocket.Listen

    Exit Sub
ERR_HANDLER:
    MsgBox Err.Number & ": " & Err.Description
    Unload Me
End Sub


' Rutina para poner o quitar el formulario de pantalla completa.
Private Sub FormFullScreen(ByVal Value As Boolean)
    Dim WndStyle As Long
    WndStyle = GetWindowLong(hwnd, GWL_STYLE)
    If Value Then
        SetWindowLong hwnd, GWL_STYLE, WndStyle And Not WS_MAXIMIZEBOX And Not WS_MINIMIZEBOX And Not WS_THICKFRAME And Not WS_CAPTION
        If Me.WindowState = vbMaximized Then
            SetWindowPos hwnd, HWND_TOPMOST, 0, 0, Screen.Width / Screen.TwipsPerPixelX, Screen.Height / Screen.TwipsPerPixelY, SWP_NOACTIVATE
        Else
            SetWindowPos hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE Or SWP_NOSIZE Or SWP_NOMOVE
        End If
        hMenu = GetMenu(Me.hwnd)
        SetMenu Me.hwnd, 0
        Me.WindowState = vbMaximized
        bFullScreen = True
    Else
        SetWindowPos hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE Or SWP_NOSIZE Or SWP_NOMOVE
        SetWindowLong hwnd, GWL_STYLE, WndStyle Or WS_MAXIMIZEBOX Or WS_MINIMIZEBOX Or WS_THICKFRAME Or WS_CAPTION
        SetMenu Me.hwnd, hMenu
        Me.WindowState = vbNormal
        bFullScreen = False
    End If
End Sub


' Eventos recibidos del sublcass del PicRender.
Private Sub cSubclass_WindowProc(Cancel As Boolean, hwnd As Long, uMsg As Long, wParam As Long, lParam As Long)

    If bFullScreen = True And uMsg = WM_KEYUP And wParam = vbKeyEscape Then
        FormFullScreen False
    End If
    
    'If uMsg = WM_KEYUP And wParam = vbKeyF11 Then
    '    If bFullScreen = False Then
            'FormFullScreen True
    '    Else
            'FormFullScreen False
    '    End If
    '    Exit Sub
    'End If
                     
    If cSocket.State <> sckConnected Then Exit Sub
    
    Select Case uMsg
    
        Case WM_MOUSEMOVE
            If hCurrentCursor <> 0 Then SetCursor hCurrentCursor
            If bAdjustedCapture Then
                Dim PT As POINTAPI
                Dim PercentX As Single
                Dim PercentY As Single
                
                PT.x = LoWord(lParam)
                PT.y = HiWord(lParam)
                
                PercentX = (PT.x * 100) / (PicRender.ScaleWidth / Screen.TwipsPerPixelX)
                PT.x = (RSI.Width * PercentX) / 100
                
                PercentY = (PT.y * 100) / (PicRender.ScaleHeight / Screen.TwipsPerPixelY)
                PT.y = (RSI.Height * PercentY) / 100
    
                SendMSG uMsg, wParam, MakeDWord(PT.x, PT.y)
            Else
                SendMSG uMsg, wParam, lParam
            End If
            
        Case WM_LBUTTONDOWN, WM_LBUTTONUP, WM_LBUTTONDBLCLK, WM_RBUTTONDOWN, WM_RBUTTONUP, WM_RBUTTONDBLCLK, WM_KEYUP, WM_SYSKEYUP, WM_SYSKEYDOWN, WM_CONTEXTMENU, WM_CHAR, WM_KEYDOWN, WM_MOUSEWHEEL
            If hCurrentCursor <> 0 Then SetCursor hCurrentCursor
            SendMSG uMsg, wParam, lParam
            
        Case WM_DRAWCLIPBOARD
            If RemoteClipboardChange Then Exit Sub
            If IsClipboardFormatAvailable(vbCFText) <> 0 Then
                SendCilpboard
            End If
            
    End Select

End Sub


' Rutina para enviar el texto del portapapeles local.
Private Sub SendCilpboard()

On Error GoTo ClipBoardErr
    If cSocket.State = sckConnected Then

        Dim Data()      As Byte
        Dim sText       As String
    
        sText = Clipboard.GetText
        
        HDSend.DataSize = Len(sText)
        HDSend.DataType = DATA_CLIPBOARD
        
        ReDim Data(LenB(HDSend) + HDSend.DataSize - 1) As Byte           'Redimencionamos el array
        
        'Copiamos la estructura en el array DATA
        CopyMemory Data(0), HDSend, LenB(HDSend)
        CopyMemory Data(LenB(HDSend)), ByVal sText, HDSend.DataSize
        
        'Enviamos el array
        cSocket.SendData Data
    
    End If
    
ClipBoardErr:
    Debug.Print Err.Description
End Sub


' Envia mensajes cortos al receptor.
Private Sub SendMSG(ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long)

    If cSocket.State = sckConnected Then
        Dim Data()      As Byte
        Dim tMSG        As UDT_MSG
        Dim LenUDT      As Long
        
        LenUDT = LenB(tMSG)                                     ' Tamao de la estructura.
        
        HDSend.DataSize = LenUDT
        HDSend.DataType = DATA_MSG
        
        ReDim Data(LenUDT + LenB(HDSend) - 1) As Byte           ' Redimencionamos el array.
        
        ' Rellenamos la extructura con los datos.
        tMSG.uMsg = uMsg
        tMSG.wParam = wParam
        tMSG.lParam = lParam

        ' Copiamos la estructura en el array DATA.
        CopyMemory Data(0), HDSend, LenB(HDSend)
        CopyMemory Data(LenB(HDSend)), tMSG, LenUDT
        
        ' Enviamos el array.
        cSocket.SendData Data
    End If
End Sub


' Subclasificacin para los ScrollBars y el formulario.
Private Sub cSubclassSroll_WindowProc(Cancel As Boolean, hwnd As Long, uMsg As Long, wParam As Long, lParam As Long)

    Select Case hwnd
        ' Cuando la captura es de modo ajustado y se cambia el tamao del formulario,
        ' se crea un efecto estirando y repintando la ltima captura recibida.
        Case Me.hwnd
            If uMsg = WM_SIZING Then
                If cSocket.State = sckConnected And bAdjustedCapture = True Then
                    If bDrawPicture = False Then
                        PicRender = PicRender.Image
                        bDrawPicture = True
                    End If
                End If
            End If
            
            If uMsg = WM_EXITSIZEMOVE Then
                If bAdjustedCapture = True And bDrawPicture Then
                    bDrawPicture = False
                    c_lFrameW = (PicRender.ScaleWidth / Screen.TwipsPerPixelX) / 8
                    c_lFrameH = (PicRender.ScaleHeight / Screen.TwipsPerPixelY) / 8
                    SendMSG MSG_SETCAPTURESIZE, PicRender.ScaleWidth / Screen.TwipsPerPixelX, PicRender.ScaleHeight / Screen.TwipsPerPixelY
                End If
            End If

        Case Else
            ' El Mouse Wheel slo funcionar en modo local.
            If uMsg = WM_MOUSEWHEEL Then
                If wParam < 0 Then
                    SendMessage hwnd, 256, ByVal vbKeyDown, ByVal 0
                    SendMessage hwnd, 257, ByVal vbKeyDown, ByVal 0
                Else
                    SendMessage hwnd, 256, ByVal vbKeyUp, ByVal 0
                    SendMessage hwnd, 257, ByVal vbKeyUp, ByVal 0
                End If
            End If
    End Select

End Sub


' Si est en FullScreen el men se har visible si el mouse se encuentra en la parte superior de la pantalla.
Private Sub Form_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
    If bFullScreen Then
        If y < 3 Then
            SetMenu Me.hwnd, hMenu
        Else
            If GetMenu(Me.hwnd) <> 0 Then SetMenu Me.hwnd, 0
        End If
    End If
End Sub


'// Ajuestes de los Scrollbar, PicRender y PicSize
Private Sub Form_Resize()
On Error Resume Next
    Dim VSW As Long
    Dim HSH As Long
    
    If Me.WindowState = vbMinimized Then Exit Sub
    
    If bAdjustedCapture Then
        If RSI.Width > 0 And RSI.Height > 0 Then
 
            Dim PLeft As Long, PTop As Long
            Dim ReqWidth As Long, ReqHeight As Long
            Dim HScale As Double, VScale As Double
            Dim MyScale As Double
    
            HScale = Me.ScaleWidth / RSI.Width
            VScale = Me.ScaleHeight / RSI.Height
            
            MyScale = IIf(VScale >= HScale, HScale, VScale)
    
            ReqWidth = RSI.Width * MyScale
            ReqHeight = RSI.Height * MyScale
        
            PLeft = (Me.ScaleWidth - ReqWidth) / 2
            PTop = (Me.ScaleHeight - ReqHeight) / 2
            
            PicRender.Move PLeft, PTop, ReqWidth, ReqHeight
            
            If bDrawPicture Then
                PicRender.PaintPicture PicRender.Picture, 0, 0, PicRender.ScaleWidth, PicRender.ScaleHeight
            End If

            c_lFrameW = (PicRender.ScaleWidth / Screen.TwipsPerPixelX) / 8
            c_lFrameH = (PicRender.ScaleHeight / Screen.TwipsPerPixelY) / 8
            
            If Me.WindowState = vbMaximized Then
                bIsMaximezed = True
                DoEvents
                SendMSG MSG_SETCAPTURESIZE, PicRender.ScaleWidth / Screen.TwipsPerPixelX, PicRender.ScaleHeight / Screen.TwipsPerPixelY
            Else
                If bIsMaximezed Then
                    bIsMaximezed = False
                    DoEvents
                    SendMSG MSG_SETCAPTURESIZE, PicRender.ScaleWidth / Screen.TwipsPerPixelX, PicRender.ScaleHeight / Screen.TwipsPerPixelY
                End If
            End If
            
            HScroll1.Visible = False
            VScroll1.Visible = False
            PicSize.Visible = False
            
            Exit Sub
        End If
    End If
    
    c_lFrameW = (PicRender.ScaleWidth / Screen.TwipsPerPixelX) / 8
    c_lFrameH = (PicRender.ScaleHeight / Screen.TwipsPerPixelY) / 8

    VSW = IIf(VScroll1.Visible, VScroll1.Width, 0)
    HSH = IIf(HScroll1.Visible, HScroll1.Height, 0)
    
    HScroll1.Visible = PicRender.ScaleWidth > Me.ScaleWidth - VSW
    VScroll1.Visible = PicRender.ScaleHeight > Me.ScaleHeight - HSH
    
    HScroll1.Move 0, Me.ScaleHeight - HScroll1.Height, Me.ScaleWidth - VSW
    VScroll1.Move Me.ScaleWidth - VScroll1.Width, 0, VScroll1.Width, Me.ScaleHeight - HSH
    
    If PicRender.ScaleWidth < Me.ScaleWidth Then
        PicRender.Left = (Me.ScaleWidth / 2) - (PicRender.ScaleWidth / 2)
    Else
        PicRender.Left = 0
    End If
    
    If PicRender.ScaleHeight < Me.ScaleHeight Then
        PicRender.Top = (Me.ScaleHeight / 2) - (PicRender.ScaleHeight / 2)
    Else
        PicRender.Top = 0
    End If

    HScroll1.Max = (PicRender.ScaleWidth - Me.ScaleWidth + VSW) / 120
    VScroll1.Max = (PicRender.ScaleHeight - Me.ScaleHeight + HSH) / 120
    
    If HScroll1.Visible And VScroll1.Visible Then
        PicSize.Move Me.ScaleWidth - PicSize.ScaleWidth, Me.ScaleHeight - PicSize.ScaleHeight
        PicSize.Visible = True
    Else
        PicSize.Visible = False
    End If
End Sub


'// Detiene las sublcasificaciones y descarga las clases.
Private Sub Form_Unload(Cancel As Integer)
    
    cSubclassSroll.ssc_UnSubclass HScroll1.hwnd
    cSubclassSroll.ssc_UnSubclass VScroll1.hwnd
    cSubclassSroll.ssc_UnSubclass Me.hwnd
    
    Set cSubclassSroll = Nothing
    
    cSubclass.ssc_UnSubclass PicRender.hwnd
    Set cSubclass = Nothing
    
    cSocket.CloseSocket
    Set cSocket = Nothing

    cPNG.DeleteGraphics
    
    ClearCacheCursor
    
    FreeLibrary hModShell32
End Sub


Private Sub cSocket_onClose()
    Me.Caption = "Esperando conexin ..."
    PicRender.Picture = Nothing
    ClearCacheCursor
    c_lFrameW = 0
    c_lFrameH = 0
    cSocket.CloseSocket
    cSocket.Listen
End Sub


Private Sub cSocket_onConnectionRequest(ByVal requestID As Long)
    cSocket.CloseSocket
    cSocket.Accept requestID
    
    ' Informa la calidad de imgen que queremos visualizar.
    If mIndexPixelFormat <> 1 Then SendMSG MSG_SETPIXELFORMAT, mIndexPixelFormat, 0

    ' Informa si estamos trabajando de forma "pantalla ajustada".
    If bAdjustedCapture Then
        SendMSG MSG_SETCAPTURESIZE, PicRender.ScaleWidth / Screen.TwipsPerPixelX, PicRender.ScaleHeight / Screen.TwipsPerPixelY
    End If

    Me.Caption = "Conectado con " & cSocket.RemoteHostIP
    Beep
End Sub


Private Sub cSocket_onDataArrival(ByVal bytesTotal As Long)
On Error GoTo ERR_HANDLER

Dim bData() As Byte

Do While cSocket.BytesReceived > 0

    If HeaderReceived = False Then
        If bytesTotal >= LenB(HDReceived) Then
            cSocket.GetData bData, vbArray + vbByte, LenB(HDReceived)
            CopyMemory HDReceived, bData(0), LenB(HDReceived)
            bytesTotal = bytesTotal - LenB(HDReceived)
            HeaderReceived = True
        End If
    End If
    
    If HeaderReceived = False Then Exit Sub
    
    If bytesTotal >= HDReceived.DataSize Then
    
        Select Case HDReceived.DataType
        
            Case DATA_IMAGE
                Dim DG As DataGraphic
                cSocket.GetData DG.FrameCount, vbLong, 4
                cSocket.GetData DG.LenData, vbLong, 4
                cSocket.GetData bData, vbArray + vbByte, (DG.FrameCount * 8)
                ReDim DG.PT(DG.FrameCount)
                CopyMemory DG.PT(0), bData(0), (DG.FrameCount * 8)
                cSocket.GetData DG.Data, vbArray + vbByte, DG.LenData
                Draw DG
                HeaderReceived = False
                SendMSG MSG_UPDATESCAN, 0, 0
                
            Case DATA_CLIPBOARD
                Dim sText As String
                cSocket.GetData bData, vbArray + vbByte, HDReceived.DataSize
                sText = String(HDReceived.DataSize, Chr(0))
                CopyMemory ByVal sText, bData(0), HDReceived.DataSize
                ClipboardSetText sText
                HeaderReceived = False
                
            Case DATA_SCREENINFO
                cSocket.GetData c_lFrameW, vbLong, 4
                cSocket.GetData c_lFrameH, vbLong, 4
                cSocket.GetData RSI.Width, vbLong, 4
                cSocket.GetData RSI.Height, vbLong, 4
                PicRender.Width = (RSI.Width * Screen.TwipsPerPixelX) '/ 2
                PicRender.Height = (RSI.Height * Screen.TwipsPerPixelY) '/ 2
                Form_Resize
                Form_Resize
                HeaderReceived = False
                
            Case DATA_MSG
                Dim tMSG As UDT_MSG
                cSocket.GetData bData, vbArray + vbByte, HDReceived.DataSize
                CopyMemory tMSG, bData(0), LenB(tMSG)
                ProcessMsg tMSG
                HeaderReceived = False
                
            Case DATA_CURSOR
                Dim IdCursor As Long
                Dim hCursor As Long
                Dim BitCursor() As Byte
                
                cSocket.GetData IdCursor, vbLong, 4
                cSocket.GetData bData, vbArray + vbByte, HDReceived.DataSize - 3
                Debug.Print UBound(bData)
                DeCompress bData, BitCursor
                hCursor = LoadCursorFromStream(BitCursor)
                
                If hCursor <> 0 Then
                    AddCursorToCache IdCursor, hCursor
                End If
                HeaderReceived = False
        End Select

    Else
        Exit Sub
    End If
        
Loop
Exit Sub
ERR_HANDLER:
    Debug.Print "onDataArrival", Err.Description

End Sub


' Funcin para crear un cursor a partir de un array de bytes.
Public Function LoadCursorFromStream(bData() As Byte) As Long

    Dim hIcon As Long
    Dim dwOffset As Long, dwSize As Long
    Dim ICI As ICONINFO

    dwSize = VarPtr(bData(14&))             ' Get size of icon resource
    dwOffset = VarPtr(bData(bData(18&)))    ' Get offset into the array

    hIcon = CreateIconFromResourceEx(ByVal dwOffset, ByVal dwSize, 1, ICRESVER, 0&, 0&, LR_DEFAULTSIZE)
    
    If hIcon Then

        Call GetIconInfo(hIcon, ICI)
        
        ICI.xHotspot = bData(10&)
        ICI.yHotspot = bData(12&)
        ICI.fIcon = 0
        
        LoadCursorFromStream = CreateIconIndirect(ICI)
        
        If ICI.hbmColor <> 0 Then DeleteObject ICI.hbmColor
        If ICI.hbmMask <> 0 Then DeleteObject ICI.hbmMask
        
        DestroyIcon hIcon

    End If

End Function


' Procesa los mensajes arrivados.
Private Sub ProcessMsg(tMSG As UDT_MSG)
    Dim Index As Long
    
    Select Case tMSG.uMsg
        Case MSG_SETCURSOR
            Index = ExistCursorInCache(tMSG.wParam)
            If Index <> -1 Then
                hCurrentCursor = CC(Index).hCursor
                SetCursor hCurrentCursor
            Else
                SendMSG MSG_SENDCURSOR, tMSG.wParam, 0
            End If
    End Select
    
End Sub


' Agrega el texto arrivado al portapapeles local.
Private Sub ClipboardSetText(ByVal sText As String)
On Local Error GoTo ClipBoardErr
    RemoteClipboardChange = True
    Clipboard.Clear
    Clipboard.SetText sText
    RemoteClipboardChange = False
    Exit Sub
ClipBoardErr:
    RemoteClipboardChange = False
    Debug.Print Err.Description
End Sub


' Rutina principal que se encarga de dibujar los fragmentos arrivados al PictureBox (PicRender).
Private Sub Draw(DG As DataGraphic)
    Dim i As Long
    Dim NewFrame As Long
    
    If bDrawPicture Then Exit Sub
    
    If cPNG.LoadPNGFromSteam(DG.Data) Then

        PicRender.AutoRedraw = True
        cPNG.CreateGraphics PicRender.HDC
    
        For i = 0 To DG.FrameCount
            cPNG.Render DG.PT(i).x, DG.PT(i).y, c_lFrameW, c_lFrameH, 0, c_lFrameH * NewFrame, c_lFrameW, c_lFrameH
            NewFrame = NewFrame + 1
        Next
        
        cPNG.DeleteGraphics
        PicRender.Refresh
        PicRender.AutoRedraw = False
        
        cPNG.DisposeImage
    End If
End Sub


Private Sub HScroll1_Change()
    PicRender.Left = -HScroll1.Value * 120
End Sub


Private Sub HScroll1_Scroll()
    HScroll1_Change
End Sub


Private Sub MnuConexion_Click()
    If cSocket.State = sckConnected Then
        SubMnuConexion.Caption = "Desconectar"
    Else
        SubMnuConexion.Checked = True
        SubMnuConexion.Caption = "Listen"
    End If
End Sub


Private Sub PicSize_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
On Error Resume Next
    Static lX As Long, lY As Long
    Dim PT As POINTAPI
    
    If Button = 1 Then
        ClientToScreen PicSize.hwnd, PT
        Me.Move Me.Left, Me.Top, (PT.x * Screen.TwipsPerPixelX) - Me.Left + x + lX, (PT.y * Screen.TwipsPerPixelY) - Me.Top + y + lY
    Else
        lX = x: lY = y
    End If
End Sub


Private Sub SubMnuAyuda_Click()
    MsgBox "Realizado por: Leandro Ascierto." & vbCrLf & "Agradecimiento a Cobein en las creacin de algunos Mdulos"
End Sub


Private Sub SubMnuConexion_Click()
    If SubMnuConexion.Caption = "Desconectar" Then
        cSocket.CloseSocket
        SubMnuConexion.Checked = False
    End If
End Sub


Private Sub SubMnuVer_Click(Index As Integer)
    Dim i As Integer
    Select Case Index
        Case Is < 5 ' Calidad de la captura.
            mIndexPixelFormat = Index
            SendMSG MSG_SETPIXELFORMAT, mIndexPixelFormat, 0
            For i = 0 To 4
                 SubMnuVer(i).Checked = Index = i
            Next
            
        Case 6  ' Ajustar a la ventana.
            bAdjustedCapture = Not SubMnuVer(Index).Checked
            
            SubMnuVer(Index).Checked = bAdjustedCapture
            
            If bAdjustedCapture Then
                Form_Resize
                PicRender.Picture = PicRender.Image
                SendMSG MSG_SETCAPTURESIZE, PicRender.ScaleWidth / Screen.TwipsPerPixelX, PicRender.ScaleHeight / Screen.TwipsPerPixelY
            Else
                PicRender.Picture = Nothing
                PicRender.Width = (RSI.Width * Screen.TwipsPerPixelX) '/ 2
                PicRender.Height = (RSI.Height * Screen.TwipsPerPixelY) '/ 2
                Form_Resize
                
                SendMSG MSG_SETCAPTURESIZE, 0, 0
            End If
            
        Case 8  'FullScreen
            If bFullScreen = False Then
                FormFullScreen True
                bFullScreen = True
            Else
                FormFullScreen False
                bFullScreen = False
            End If
            SubMnuVer(Index).Checked = bFullScreen
    End Select
End Sub


Private Sub VScroll1_Change()
    PicRender.Top = -CSng(VScroll1.Value) * 120
End Sub


Private Sub VScroll1_Scroll()
    VScroll1_Change
End Sub


' Devuelve el DWord de dos nmeros pasado como parmetro.
Function MakeDWord(LoWord As Long, HiWord As Long) As Long
      MakeDWord = (HiWord * &H10000) Or (LoWord And &HFFFF&)
End Function

 ' Devuelve el LoWord del nmero pasado como parmetro.
Private Function LoWord(ByVal Numero As Long) As Long
    LoWord = Numero And &HFFFF&
End Function


' Devuelve el HiWord del nmero pasado como parmetro.
Private Function HiWord(ByVal Numero As Long) As Long
    HiWord = Numero \ &H10000 And &HFFFF&
End Function

