VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsGDIPlus"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Verwendet das IStream-Interface
' Download IStream-TLB von MadMax unter
' http://mitglied.lycos.de/real51/directdl.php?file=IStream.zip
' Project/References/ -> IStream Interface TypeLibrary

' ----==== GDI+ Const ====----
Private Const ClsIdPNG As String = "{557CF406-1A04-11D3-9A73-0000F81EF32E}"
Private Const GdiplusVersion As Long = 1&

' ----==== sonstige Const ====----
Private Const DIB_RGB_COLORS As Long = 0&
Private Const BI_RGB As Long = 0&

' ----==== GDI+ Enums ====----
Private Enum Status
    OK = 0
    GenericError = 1
    InvalidParameter = 2
    OutOfMemory = 3
    ObjectBusy = 4
    InsufficientBuffer = 5
    NotImplemented = 6
    Win32Error = 7
    WrongState = 8
    Aborted = 9
    FileNotFound = 10
    ValueOverflow = 11
    AccessDenied = 12
    UnknownImageFormat = 13
    FontFamilyNotFound = 14
    FontStyleNotFound = 15
    NotTrueTypeFont = 16
    UnsupportedGdiplusVersion = 17
    GdiplusNotInitialized = 18
    PropertyNotFound = 19
    PropertyNotSupported = 20
    ProfileNotFound = 21
End Enum

' ----==== sonstige Enums ====----
Public Enum PixelFormat
    PixelFormat1bppIndexed = 1
    PixelFormat4bppIndexed = 4
    PixelFormat8bppIndexed = 8
    PixelFormat16bppRGB = 16
    PixelFormat24bppRGB = 24
    PixelFormat32bppRGB = 32
End Enum

' ----==== GDI+ Types ====----
Private Type GdiplusStartupInput
    GdiplusVersion              As Long
    DebugEventCallback          As Long
    SuppressBackgroundThread    As Long
    SuppressExternalCodecs      As Long
End Type

' ----==== sonstige Types ====----
Private Type BITMAP
    bmType                      As Long
    bmWidth                     As Long
    bmHeight                    As Long
    bmWidthBytes                As Long
    bmPlanes                    As Integer
    bmBitsPixel                 As Integer
    bmBits                      As Long
End Type

Private Type BitmapInfoHeader
    biSize                      As Long
    biWidth                     As Long
    biHeight                    As Long
    biPlanes                    As Integer
    biBitCount                  As Integer
    biCompression               As Long
    biSizeImage                 As Long
    biXPelsPerMeter             As Long
    biYPelsPerMeter             As Long
    biClrUsed                   As Long
    biClrImportant              As Long
End Type

Private Type RGBQUAD
    rgbBlue                     As Byte
    rgbGreen                    As Byte
    rgbRed                      As Byte
    rgbReserved                 As Byte
End Type

Private Type BITMAPINFO256
    bmiHeader                   As BitmapInfoHeader
    bmiColors(0 To 255)         As RGBQUAD
End Type

Private Type GUID
    Data1                       As Long
    Data2                       As Integer
    Data3                       As Integer
    Data4(0 To 7)               As Byte
End Type

' ----==== GDI+ Deklarationen ====----
Private Declare Function GdiplusStartup Lib "gdiplus" (Token As Long, inputbuf As GdiplusStartupInput, Optional ByVal outputbuf As Long = 0) As Long
Private Declare Sub GdiplusShutdown Lib "gdiplus" (ByVal Token As Long)
Private Declare Function GdipCreateBitmapFromGdiDib256 Lib "gdiplus" Alias "GdipCreateBitmapFromGdiDib" (ByRef mGdiBitmapInfo As BITMAPINFO256, ByVal mGdiBitmapData As Long, ByRef mBitmap As Long) As Status
Private Declare Function GdipDisposeImage Lib "gdiplus" (ByVal mImage As Long) As Status
Private Declare Function GdipSaveImageToStream Lib "gdiplus" (ByVal Image As Long, ByVal Stream As IStream, ByRef ClsidEncoder As GUID, ByRef EncoderParams As Any) As Status
Private Declare Function GdipLoadImageFromStream Lib "gdiplus" (ByVal Stream As IUnknown, ByRef Image As Long) As Status
Private Declare Function GdipCreateFromHDC Lib "gdiplus" (ByVal HDC As Long, ByRef graphics As Long) As Status
Private Declare Function GdipDeleteGraphics Lib "gdiplus" (ByVal graphics As Long) As Status
Private Declare Function GdipDrawImageRectRectI Lib "gdiplus" (ByVal graphics As Long, ByVal Image As Long, ByVal DstX As Long, ByVal DstY As Long, ByVal DstWidth As Long, ByVal DstHeight As Long, ByVal SrcX As Long, ByVal SrcY As Long, ByVal SrcWidth As Long, ByVal SrcHeight As Long, ByVal srcUnit As Long, ByVal imageAttributes As Long, Optional ByVal callback As Long = 0, Optional ByVal callbackData As Long = 0) As Long
Private Declare Function GdipDrawImageI Lib "gdiplus" (ByVal graphics As Long, ByVal Image As Long, ByVal x As Long, ByVal y As Long) As Status
Private Declare Function GetDIBits256 Lib "gdi32" Alias "GetDIBits" (ByVal aHDC As Long, ByVal hBitmap As Long, ByVal nStartScan As Long, ByVal nNumScans As Long, ByRef lpBits As Any, ByRef lpBI As BITMAPINFO256, ByVal wUsage As Long) As Long
Private Declare Function GetObject Lib "gdi32" Alias "GetObjectA" (ByVal hObject As Long, ByVal nCount As Long, ByRef lpObject As Any) As Long
Private Declare Function CLSIDFromString Lib "ole32" (ByVal str As Long, ByRef id As GUID) As Long
Private Declare Function CreateStreamOnHGlobal Lib "ole32.dll" (ByRef hGlobal As Any, ByVal fDeleteOnRelease As Long, ByRef ppstm As Any) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal HDC As Long) As Long
Private Declare Sub GetSafeArrayPointer Lib "msvbvm60.dll" Alias "GetMem4" (ByRef pArray() As Any, ByRef sfaPtr As Long)
Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal Length As Long)
Private Declare Function CreateWindowExA Lib "user32.dll" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByRef lpParam As Any) As Long
Private Declare Sub RtlMoveMemory Lib "kernel32" (ByVal Destination As Long, ByVal Source As Long, ByVal Length As Long)
Private Declare Function VirtualAlloc Lib "kernel32" (ByVal lpAddress As Long, ByVal dwSize As Long, ByVal flAllocationType As Long, ByVal flProtect As Long) As Long
Private Declare Function VirtualFree Lib "kernel32" (ByVal lpAddress As Long, ByVal dwSize As Long, ByVal dwFreeType As Long) As Long
Private Declare Function GetModuleHandleA Lib "kernel32" (ByVal lpModuleName As String) As Long
Private Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long
Private Declare Function LoadLibrary Lib "kernel32.dll" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Private Declare Function SetWindowLong Lib "user32.dll" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function GetParent Lib "user32.dll" (ByVal hwnd As Long) As Long
Private Declare Function GetWindow Lib "user32.dll" (ByVal hwnd As Long, ByVal wCmd As Long) As Long
Private Declare Function FindWindowEx Lib "user32.dll" Alias "FindWindowExA" (ByVal hWnd1 As Long, ByVal hWnd2 As Long, ByVal lpsz1 As String, ByVal lpsz2 As String) As Long
Private Const GWL_WNDPROC As Long = -4
Private Const GW_OWNER As Long = 4
Private Const WS_CHILD As Long = &H40000000

Private Const UnitPixel As Long = 2

Private lGraphics As Long
Private lngBitmap As Long
Dim memStream           As IUnknown

Public Function CreateGraphics(HDC As Long) As Boolean
    If lGraphics Then DeleteGraphics
    CreateGraphics = GdipCreateFromHDC(HDC, lGraphics) = OK
End Function

Public Sub DeleteGraphics()
    Call GdipDeleteGraphics(lGraphics)
    lGraphics = 0
End Sub

Public Function LoadPNGFromSteam(pngStream() As Byte) As Boolean
    

    Dim lngPtr              As Long
    
    If lngBitmap <> 0 Then DisposeImage
    
    Call GetSafeArrayPointer(pngStream(), lngPtr)
        
    If lngPtr > 0 Then

        If CreateStreamOnHGlobal(pngStream(0), 0&, memStream) = 0 Then

            If GdipLoadImageFromStream(memStream, lngBitmap) = OK Then
                LoadPNGFromSteam = True

            End If
        
        End If
    
    End If
    
    'Set memStream = Nothing
End Function

Public Sub DisposeImage()
    Call GdipDisposeImage(lngBitmap)
    lngBitmap = 0
    Set memStream = Nothing
End Sub
 
Public Sub Render(ByVal DstX As Long, ByVal DstY As Long, ByVal DstWidth As Long, ByVal DstHeight As Long, ByVal SrcX As Long, ByVal SrcY As Long, ByVal SrcWidth As Long, ByVal SrcHeight As Long)
    GdipDrawImageRectRectI lGraphics, lngBitmap, DstX, DstY, DstWidth, DstHeight, SrcX, SrcY, SrcWidth, SrcHeight, UnitPixel, 0
End Sub


Public Function RenderPNGFromStream(ByVal DestHdc As Long, ByVal x As Long, ByVal y As Long, pngStream() As Byte) As Boolean
    
    Dim memStream           As IUnknown
    Dim lngBitmap           As Long
    Dim lngGraphics         As Long
    Dim lngPtr              As Long
    
    ' ist GDI+ initialisiert

    
        Call GetSafeArrayPointer(pngStream(), lngPtr)
        
        If lngPtr > 0 Then
            ' Stream vom Bytearray erstellen
            If CreateStreamOnHGlobal(pngStream(0), 0&, memStream) = 0 Then
                ' GDI+ Bitmap aus dem Stream erstellen
                If GdipLoadImageFromStream(memStream, lngBitmap) = OK Then
                    ' ist ein DC vorhanden
                    If DestHdc <> 0 Then
                        ' Graphics-Objekt von DC erstellen
                        If GdipCreateFromHDC(DestHdc, lngGraphics) = OK Then
                            ' lngBitmap in lngGraphics zeichnen
                            If GdipDrawImageI(lngGraphics, lngBitmap, x, y) = OK Then
                                RenderPNGFromStream = True
                            End If
                            ' lngGraphics lschen
                            Call GdipDeleteGraphics(lngGraphics)
                        End If
                    End If
                    ' lngBitmap lschen
                    Call GdipDisposeImage(lngBitmap)
                End If
                Set memStream = Nothing
            End If
        End If
    'End If
    
End Function


Public Function GetStreamFromBitmap(ByVal hBitmap As Long, ByVal BitsPerPixel As PixelFormat, ByRef OutStream() As Byte, Optional ByVal Width As Long) As Boolean
    
    Dim lngDC               As Long
    Dim lngBitmap           As Long
    Dim lngStride           As Long
    Dim tBitmap             As BITMAP
    Dim tBITMAPINFO         As BITMAPINFO256
    Dim tGUID               As GUID
    Dim bytData()           As Byte
    Dim memStream           As IStream '<- IStream-Interface
    Dim curSize             As Currency
    Dim lngSize             As Long
    Dim lngBytesRead        As Long
    
    ' ist GDI+ initialisiert
    'If lngToken <> 0 Then
    
        ' BitsPerPixel auf gltige Werte prfen
        Select Case BitsPerPixel
        
            Case 1, 4, 8, 16, 24, 32
                ' wenn kein Bild vorhanden ist
                If hBitmap = 0 Then
                    ' Funktion verlassen
                    Exit Function
                End If
                
            Case Else
                MsgBox "Fehler!" & vbCrLf & "Dieses Bildformat wird nicht untersttzt!"
                ' Funktion verlassen
                Exit Function
            
        End Select
        
        ' InPicture.Handle -> tBitmap
        If GetObject(hBitmap, Len(tBitmap), tBitmap) <> 0 Then
        
        Width = IIf(Width, Width, tBitmap.bmWidth)
        
            tBITMAPINFO.bmiHeader.biHeight = tBitmap.bmHeight
            tBITMAPINFO.bmiHeader.biWidth = IIf(Width, Width, tBitmap.bmWidth)
            tBITMAPINFO.bmiHeader.biPlanes = tBitmap.bmPlanes
            tBITMAPINFO.bmiHeader.biBitCount = BitsPerPixel
            tBITMAPINFO.bmiHeader.biSize = Len(tBITMAPINFO.bmiHeader)
            tBITMAPINFO.bmiHeader.biCompression = BI_RGB
            
            ' Breite einer Zeile, inklusiv eventuell vorhander PadBytes, in
            ' Abhngigkeit vom PixelFormat berechnen

            Select Case BitsPerPixel
            
                Case 1
                    lngStride = ((tBitmap.bmWidth + 31) And Not 31) \ 8
                Case 4
                    lngStride = ((tBitmap.bmWidth + 7) And Not 7) \ 2
                Case 8
                    lngStride = (tBitmap.bmWidth + 3) And Not 3
                Case 16
                    lngStride = ((tBitmap.bmWidth * 2) + 2) And Not 2
                Case 24
                    lngStride = ((tBitmap.bmWidth * 3) + 3) And Not 3
                Case 32
                    lngStride = tBitmap.bmWidth * 4
                
            End Select
            
            ' ByteArray zur Aufnahme der DIB-Daten dimensionieren
            ReDim bytData((tBitmap.bmHeight * lngStride) - 1)
            
            ' DC des Desktop ermitteln
            lngDC = GetDC(0&)
            
            ' ist ein DC vorhanden
            If lngDC <> 0 Then
            
                ' DIB-Daten auslesen -> bytData
                If GetDIBits256(lngDC, hBitmap, 0&, tBitmap.bmHeight, bytData(0), _
                    tBITMAPINFO, DIB_RGB_COLORS) <> 0 Then
                    ' GDI+ Bitmap aus den DIB-Daten erstellen -> lngBitmap
                    If GdipCreateBitmapFromGdiDib256(tBITMAPINFO, VarPtr(bytData( _
                        0)), lngBitmap) = OK Then
                        ' Stream erstellen
                        If CreateStreamOnHGlobal(ByVal 0&, 0&, memStream) = 0 Then
                            ' CLSID fr PNG
                            If CLSIDFromString(StrPtr(ClsIdPNG), tGUID) = 0 Then
                                If GdipSaveImageToStream(lngBitmap, _
                                    memStream, tGUID, ByVal 0&) = OK Then
                                    ' Gre des Streams ermitteln
                                    If memStream.Seek(ByVal 0, STREAM_SEEK_END, _
                                        curSize) = 0 Then
                                        ' Zurck zum Anfang des Streams
                                        If memStream.Seek(ByVal 0, STREAM_SEEK_SET, _
                                            ByVal 0) = 0 Then
                                            ' Gre berechnen
                                            lngSize = CLng(curSize * 10000)
                                            ' Bytearray dimensionieren
                                            ReDim OutStream(0 To lngSize - 1)
                                            ' Daten aus dem Stream in das Bytearray
                                            ' kopieren
                                            If memStream.Read(OutStream(0), lngSize, _
                                                lngBytesRead) = 0 Then
                                                Call memStream.SetSize(0) ' <- This Line
                                                GetStreamFromBitmap = True
                                            End If
                                        End If
                                    End If
                                End If
                            End If
                            ' Stream lschen
                            Set memStream = Nothing
                        End If
                        ' lngBitmap lschen
                        Call GdipDisposeImage(lngBitmap)
                    End If
                End If
                ' DC freigeben
                Call ReleaseDC(0&, lngDC)
            End If
        End If
    'End If
    
End Function



Public Function ManageGDIToken(ByVal projectHwnd As Long) As Long
        
    ' Parameters
    ' projectHwnd :: any hWnd within your current project
        
    ' Return value is an hWnd to the GDI+ IDE-safe monitor.
    ' If return value is zero, then GDI+ is not installed on the O/S
        
    ' So this function will create (if needed) only one API window for the entire
    ' VB instance and remains as long as VB is opened. The API window is a child
    ' of a hidden VB top-level window and when that window closes, so will the
    ' API window which then will release GDI+. By keeping its own reference to
    ' the GDI+ library, there is no way for that library to be unloaded without
    ' the API window closing.
        
    If projectHwnd = 0& Then Exit Function
    
    Dim hwndGDIsafe     As Long                 'API window to monitor IDE shutdown
    
    ' find the hidden VB owner window. All VB apps have this (run-time & design-time).
    Do
        hwndGDIsafe = GetParent(projectHwnd)
        If Not hwndGDIsafe = 0& Then projectHwnd = hwndGDIsafe
    Loop Until hwndGDIsafe = 0&
    ' ok, got the highest level parent, now find highest level owner
    Do
        hwndGDIsafe = GetWindow(projectHwnd, GW_OWNER)
        If Not hwndGDIsafe = 0& Then projectHwnd = hwndGDIsafe
    Loop Until hwndGDIsafe = 0&
    
    hwndGDIsafe = FindWindowEx(projectHwnd, 0&, "Static", "GDI+Safe Patch")
    If hwndGDIsafe Then
        ManageGDIToken = hwndGDIsafe    ' we already have a manager running for this VB instance
        Exit Function                   ' can abort
    End If
    
    Dim gdiSI           As GdiplusStartupInput  'GDI+ startup info
    Dim gToken          As Long                 'GDI+ instance token
    
    On Error Resume Next
    gdiSI.GdiplusVersion = 1                    ' attempt to start GDI+
    GdiplusStartup gToken, gdiSI
    If gToken = 0& Then                         ' failed to start
        If Err Then Err.Clear
        Exit Function
    End If
    On Error GoTo 0

    Dim z_ScMem         As Long                 'Thunk base address
    Dim z_Code()        As Long                 'Thunk machine-code initialised here
    Dim nAddr           As Long                 'hwndGDIsafe prev window procedure

    Const WNDPROC_OFF   As Long = &H30          'Offset where window proc starts from z_ScMem
    Const PAGE_RWX      As Long = &H40&         'Allocate executable memory
    Const MEM_COMMIT    As Long = &H1000&       'Commit allocated memory
    Const MEM_RELEASE   As Long = &H8000&       'Release allocated memory flag
    Const MEM_LEN       As Long = &HD4          'Byte length of thunk
        
    z_ScMem = VirtualAlloc(0, MEM_LEN, MEM_COMMIT, PAGE_RWX) 'Allocate executable memory
    If z_ScMem <> 0 Then                                     'Ensure the allocation succeeded
        
        ' we make the api window a child so we can use FindWindowEx to locate it easily
        hwndGDIsafe = CreateWindowExA(0&, "Static", "GDI+Safe Patch", WS_CHILD, 0&, 0&, 0&, 0&, projectHwnd, 0&, App.hInstance, ByVal 0&)
        If hwndGDIsafe <> 0 Then
        
            ReDim z_Code(0 To MEM_LEN \ 4 - 1)
        
            z_Code(12) = &HD231C031: z_Code(13) = &HBBE58960: z_Code(14) = &H12345678: z_Code(15) = &H3FFF631: z_Code(16) = &H74247539: z_Code(17) = &H3075FF5B: z_Code(18) = &HFF2C75FF: z_Code(19) = &H75FF2875
            z_Code(20) = &H2C73FF24: z_Code(21) = &H890853FF: z_Code(22) = &HBFF1C45: z_Code(23) = &H2287D81: z_Code(24) = &H75000000: z_Code(25) = &H443C707: z_Code(26) = &H2&: z_Code(27) = &H2C753339: z_Code(28) = &H2047B81: z_Code(29) = &H75000000
            z_Code(30) = &H2C73FF23: z_Code(31) = &HFFFFFC68: z_Code(32) = &H2475FFFF: z_Code(33) = &H681C53FF: z_Code(34) = &H12345678: z_Code(35) = &H3268&: z_Code(36) = &HFF565600: z_Code(37) = &H43892053: z_Code(38) = &H90909020: z_Code(39) = &H10C261
            z_Code(40) = &H562073FF: z_Code(41) = &HFF2453FF: z_Code(42) = &H53FF1473: z_Code(43) = &H2873FF18: z_Code(44) = &H581053FF: z_Code(45) = &H89285D89: z_Code(46) = &H45C72C75: z_Code(47) = &H800030: z_Code(48) = &H20458B00: z_Code(49) = &H89145D89
            z_Code(50) = &H81612445: z_Code(51) = &H4C4&: z_Code(52) = &HC63FF00

            z_Code(1) = 0                                                   ' shutDown mode; used internally by ASM
            z_Code(2) = zFnAddr("user32", "CallWindowProcA")                ' function pointer CallWindowProc
            z_Code(3) = zFnAddr("kernel32", "VirtualFree")                  ' function pointer VirtualFree
            z_Code(4) = zFnAddr("kernel32", "FreeLibrary")                  ' function pointer FreeLibrary
            z_Code(5) = gToken                                              ' Gdi+ token
            z_Code(10) = LoadLibrary("gdiplus")                             ' library pointer (add reference)
            z_Code(6) = GetProcAddress(z_Code(10), "GdiplusShutdown")       ' function pointer GdiplusShutdown
            z_Code(7) = zFnAddr("user32", "SetWindowLongA")                 ' function pointer SetWindowLong
            z_Code(8) = zFnAddr("user32", "SetTimer")                       ' function pointer SetTimer
            z_Code(9) = zFnAddr("user32", "KillTimer")                      ' function pointer KillTimer
        
            z_Code(14) = z_ScMem                                            ' ASM ebx start point
            z_Code(34) = z_ScMem + WNDPROC_OFF                              ' subclass window procedure location
        
            RtlMoveMemory z_ScMem, VarPtr(z_Code(0)), MEM_LEN               'Copy the thunk code/data to the allocated memory
        
            nAddr = SetWindowLong(hwndGDIsafe, GWL_WNDPROC, z_ScMem + WNDPROC_OFF) 'Subclass our API window
            RtlMoveMemory z_ScMem + 44, VarPtr(nAddr), 4& ' Add prev window procedure to the thunk
            gToken = 0& ' zeroize so final check below does not release it
            
            ManageGDIToken = hwndGDIsafe    ' return handle of our GDI+ manager
        
        Else
        
            VirtualFree z_ScMem, 0, MEM_RELEASE     ' failure - release memory
            z_ScMem = 0&
            'MsgBox "Failed to create monitoring window", vbExclamation + vbOKOnly, "Error"
            
        End If
    
    Else
        
      VirtualFree z_ScMem, 0, MEM_RELEASE           ' failure - release memory
      z_ScMem = 0&
      'MsgBox "Failed to initialize thunk memory", vbExclamation + vbOKOnly, "Error"
        
    End If
    
    If gToken Then GdiplusShutdown gToken       ' release token if error occurred
    
End Function

Private Function zFnAddr(ByVal sDLL As String, ByVal sProc As String) As Long
'Return the address of the specified DLL/procedure

  zFnAddr = GetProcAddress(GetModuleHandleA(sDLL), sProc)  'Get the specified procedure address
  Debug.Assert zFnAddr                                     'In the IDE, validate that the procedure address was located
  ' ^^ FYI VB5 users. Search for zFnAddr("vba6", "EbMode") and replace with zFnAddr("vba5", "EbMode")

End Function





