Attribute VB_Name = "modGdipThumbnailStream"
Option Explicit

Private Declare Function GdiplusStartup Lib "gdiplus" (Token As Long, inputbuf As GdiplusStartupInput, Optional ByVal outputbuf As Long = 0) As Long
Private Declare Function GdipDisposeImage Lib "gdiplus" (ByVal Image As Long) As Long
Private Declare Function GdipSaveImageToStream Lib "gdiplus" (ByVal Image As Long, ByVal Stream As IUnknown, clsidEncoder As GUID, encoderParams As Any) As Long
Private Declare Function GdipGetImageBounds Lib "GdiPlus.dll" (ByVal nImage As Long, srcRect As RECTF, srcUnit As Long) As Long
Private Declare Function GdipDeleteGraphics Lib "gdiplus" (ByVal Graphics As Long) As Long
Private Declare Sub GdiplusShutdown Lib "gdiplus" (ByVal Token As Long)
Private Declare Function GdipDrawImageRect Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mImage As Long, ByVal mX As Single, ByVal mY As Single, ByVal mWidth As Single, ByVal mHeight As Single) As Long
Private Declare Function GdipGetImageGraphicsContext Lib "gdiplus" (ByVal Image As Long, ByRef Graphics As Long) As Long
Private Declare Function GdipCreateBitmapFromScan0 Lib "gdiplus" (ByVal Width As Long, ByVal Height As Long, ByVal stride As Long, ByVal PixelFormat As Long, scan0 As Any, Bitmap As Long) As Long
Private Declare Function GdipGraphicsClear Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mColor As Long) As Long
Private Declare Function GdipCreatePen1 Lib "GdiPlus.dll" (ByVal mColor As Long, ByVal mWidth As Single, ByVal mUnit As Long, ByRef mPen As Long) As Long
Private Declare Function GdipDrawRectangle Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mPen As Long, ByVal mX As Single, ByVal mY As Single, ByVal mWidth As Single, ByVal mHeight As Single) As Long
Private Declare Function GdipDeletePen Lib "GdiPlus.dll" (ByVal mPen As Long) As Long
Private Declare Function GdipCreateBitmapFromHBITMAP Lib "gdiplus" (ByVal hbm As Long, ByVal hpal As Long, ByRef Bitmap As Long) As Long

'Private Declare Function LoadLibrary Lib "kernel32" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
'Private Declare Function FreeLibrary Lib "kernel32" (ByVal hLibModule As Long) As Long
'Private Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long
Private Declare Function VarPtrArray Lib "msvbvm60.dll" Alias "VarPtr" (ByRef Ptr() As Any) As Long
Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal Length As Long)
Private Declare Function GlobalAlloc Lib "KERNEL32" (ByVal uFlags As Long, ByVal dwBytes As Long) As Long
Private Declare Function GlobalLock Lib "KERNEL32" (ByVal hMem As Long) As Long
Private Declare Function GlobalUnlock Lib "KERNEL32" (ByVal hMem As Long) As Long
Private Declare Function GlobalSize Lib "KERNEL32" (ByVal hMem As Long) As Long
Private Declare Function GetHGlobalFromStream Lib "ole32" (ByVal ppstm As Long, hGlobal As Long) As Long
Private Declare Function CreateStreamOnHGlobal Lib "ole32" (ByVal hGlobal As Long, ByVal fDeleteOnRelease As Long, ppstm As Any) As Long
Private Declare Function CLSIDFromString Lib "ole32" (ByVal str As Long, ID As GUID) As Long
Private Declare Function OleCreatePictureIndirect Lib "olepro32.dll" (PicDesc As PicBmp, RefIID As UUID, ByVal fPictureOwnsHandle As Long, IPic As IPicture) As Long
Private Declare Function SHGetDesktopFolder Lib "shell32.dll" (ppshf As IVBShellFolder) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32.dll" Alias "SHGetPathFromIDListA" (ByVal pidl As Long, ByVal pszPath As String) As Long
Private Declare Sub CoTaskMemFree Lib "ole32.dll" (ByVal pv As Long)

Private Type PicBmp
    SIZE As Long
    Type As Long
    hBmp As Long
    hpal As Long
    Reserved As Long
End Type



Private Type RECTF
    nLeft           As Single
    nTop            As Single
    nWidth          As Single
    nHeight         As Single
End Type

Private Type GUID
    Data1           As Long
    Data2           As Integer
    Data3           As Integer
    Data4(0 To 7)   As Byte
End Type
 
Private Type EncoderParameter
    GUID            As GUID
    NumberOfValues  As Long
    Type            As Long
    Value           As Long
End Type
 
Private Type EncoderParameters
    Count           As Long
    Parameter(15)   As EncoderParameter
End Type
 
Private Type GdiplusStartupInput
    GdiplusVersion           As Long
    DebugEventCallback       As Long
    SuppressBackgroundThread As Long
    SuppressExternalCodecs   As Long
End Type

Private Const MAX_PATH                  As Long = 260
Private Const PixelFormat16bppARGB1555  As Long = &H61007
Private Const PixelFormat24bppRGB       As Long = &H21808
Private Const PixelFormat32bppRGB       As Long = &H22009
Private Const UnitPixel                 As Long = &H2&

Private Const ImageCodecJPG = "{557CF401-1A04-11D3-9A73-0000F81EF32E}"
Private Const EncoderQuality = "{1D5BE4B5-FA4A-452D-9CDD-5DB35105E7EB}"
Private Const EncoderParameterValueTypeLong As Long = 4


Public Function CreateListThumbnail(ByVal cCol As Collection, ByVal lSize As Long, outStream() As Byte) As Boolean
    Dim GDIsi       As GdiplusStartupInput
    Dim hGraphics   As Long
    Dim gToken      As Long
    Dim hBitmap     As Long
    Dim tEncoder    As GUID
    Dim tParams     As EncoderParameters
    Dim IIStream    As IUnknown
    Dim tRect       As RECTF
    Dim hImg        As Long
    Dim PLeft       As Double
    Dim PTop        As Double
    Dim hPen        As Long
 
    Dim ReqWidth As Long, ReqHeight As Long
    Dim HScale As Double, VScale As Double
    Dim MyScale As Double
    Dim JPG_Quality As Long
    Dim i As Long

    JPG_Quality = 80
    
    GDIsi.GdiplusVersion = 1&
    
    GdiplusStartup gToken, GDIsi
    
    If GdipCreateBitmapFromScan0(lSize * cCol.Count, lSize, 0&, PixelFormat24bppRGB, ByVal 0&, hImg) = 0 Then
    
        If GdipGetImageGraphicsContext(hImg, hGraphics) = 0 Then
            GdipGraphicsClear hGraphics, &HFFFFFFFF
            GdipCreatePen1 &HFFCCCCCC, 1, UnitPixel, hPen

            For i = 1 To cCol.Count
                If GdipCreateBitmapFromHBITMAP(cCol(i).Handle, 0, hBitmap) = 0 Then
                
                    GdipGetImageBounds hBitmap, tRect, UnitPixel
                    
                    HScale = lSize / tRect.nWidth
                    VScale = lSize / tRect.nHeight
                    
                    MyScale = IIf(VScale >= HScale, HScale, VScale)
                    
                    ReqWidth = tRect.nWidth * MyScale
                    ReqHeight = tRect.nHeight * MyScale
                    
                    PLeft = (lSize - ReqWidth) / 2
                    PTop = (lSize - ReqHeight) / 2
            
                    Call GdipDrawImageRect(hGraphics, hBitmap, (lSize * (i - 1)) + PLeft, PTop, ReqWidth, ReqHeight)
                    Call GdipDrawRectangle(hGraphics, hPen, (lSize * (i - 1)), 0, lSize - 1, lSize - 1)
            
                    Call GdipDisposeImage(hBitmap)
                End If
            Next
            
            GdipDeletePen hPen
            GdipDeleteGraphics hGraphics
        End If
        
        Erase outStream
           
        Set IIStream = CreateStream(outStream)

        If Not IIStream Is Nothing Then
        
            CLSIDFromString StrPtr(ImageCodecJPG), tEncoder

            With tParams
                .Count = 1
                .Parameter(0).NumberOfValues = 1
                .Parameter(0).Type = EncoderParameterValueTypeLong
                .Parameter(0).Value = VarPtr(JPG_Quality)
                CLSIDFromString StrPtr(EncoderQuality), .Parameter(0).GUID
            End With

            If GdipSaveImageToStream(hImg, IIStream, tEncoder, tParams) = 0& Then

                ArrayFromStream IIStream, outStream()
                
                CreateListThumbnail = True

            End If
            
        End If
        
        Call GdipDisposeImage(hImg)
    End If
    
    GdiplusShutdown gToken
End Function

Private Function CreateStream(byteContent() As Byte, Optional byteOffset As Long = 0&) As stdole.IUnknown
    
    ' Purpose: Create an IStream-compatible IUnknown interface containing the
    ' passed byte aray. This IUnknown interface can be passed to GDI+ functions
    ' that expect an IStream interface -- neat hack
    
    On Error GoTo HandleError
    Dim o_lngLowerBound As Long
    Dim o_lngByteCount  As Long
    Dim o_hMem As Long
    Dim o_lpMem  As Long
     
    If iparseIsArrayEmpty(VarPtrArray(byteContent)) = 0& Then ' create a growing stream as needed
         Call CreateStreamOnHGlobal(0, 1, CreateStream)
    Else                                        ' create a fixed stream
         o_lngByteCount = UBound(byteContent) - byteOffset + 1
         o_hMem = GlobalAlloc(&H2&, o_lngByteCount)
         If o_hMem <> 0 Then
             o_lpMem = GlobalLock(o_hMem)
             If o_lpMem <> 0 Then
                 CopyMemory ByVal o_lpMem, byteContent(byteOffset), o_lngByteCount
                 Call GlobalUnlock(o_hMem)
                 Call CreateStreamOnHGlobal(o_hMem, 1, CreateStream)
             End If
         End If
     End If
    
HandleError:
End Function

Public Function GetThumbNail(ByRef sFilePath As String, ByVal lWidth As Long, ByVal lHeight As Long) As IPicture
    
    On Error Resume Next
    
    Dim Folder          As IVBShellFolder
    Dim Item            As IVBShellFolder
    Dim ExtractImage    As IExtractImage
    Dim idEnum          As IVBEnumIDList
    Dim iidShellFolder  As UUID
    Dim iiDispatch      As UUID
    Dim iidExtractImage As UUID
    Dim tSize           As SIZE
    Dim lpPic           As PicBmp
    Dim sRet            As String
    Dim sPath           As String
    Dim sFileName       As String
    Dim sName           As String
    Dim pidlMain        As Long
    Dim pidl            As Long
    Dim hRes            As Long
    
    sPath = Left$(sFilePath, InStrRev(sFilePath, "\"))
    
    sFileName = UCase$(Mid$(sFilePath, Len(sPath) + 1))

    Call SHGetDesktopFolder(Folder)

    Folder.ParseDisplayName 0&, 0&, sPath, 0&, pidlMain, 0&
    
    IIDFromString "{000214E6-0000-0000-C000-000000000046}", iidShellFolder

    Folder.BindToObject pidlMain, 0&, iidShellFolder, Item

    If pidlMain Then CoTaskMemFree pidlMain
      
    Item.EnumObjects 0&, SHCONTF_FOLDERS Or SHCONTF_NONFOLDERS Or SHCONTF_INCLUDEHIDDEN, idEnum
      
    Do While idEnum.Next(1, pidl, 0&) = 0

        sPath = PathFromPidl(pidl)
        
        sName = UCase$(Right$(sPath, Len(sPath) - InStrRev(sPath, "\")))

        If (sName = sFileName) Then
        
            IIDFromString "{BB2E617C-0920-11d1-9A0B-00C04FC2D6C1}", iidExtractImage
            
            Item.GetUIObjectOf 0&, 1&, pidl, iidExtractImage, 0&, ExtractImage
            
            CoTaskMemFree pidl
            
            If ExtractImage Is Nothing Then Exit Function
            
            sRet = String$(MAX_PATH, 0)
            
            tSize.cx = lWidth
            tSize.cy = lHeight
            
            ExtractImage.GetLocation sRet, MAX_PATH, 0&, tSize, 32, IEIFLAG_NOBORDER Or IEIFLAG_SCREEN Or IEIFLAG_OFFLINE
            
            IIDFromString "{00020400-0000-0000-C000-000000000046}", iiDispatch
            
            If Err.Number Then Err.Clear
            
            With lpPic
                .SIZE = Len(lpPic)
                .Type = vbPicTypeBitmap
                ExtractImage.Extract .hBmp
                If .hBmp = 0 Then Exit Function
            End With
            
            If Err.Number Then
                Err.Clear
                Exit Function
            End If
  
            OleCreatePictureIndirect lpPic, iiDispatch, 1, GetThumbNail
            
            Exit Do
        Else
            If pidl Then CoTaskMemFree pidl
        End If

    Loop
    
End Function

Public Function PathFromPidl(ByVal pidl As Long) As String
   Dim sPath As String * MAX_PATH
   If SHGetPathFromIDList(pidl, sPath) Then
      PathFromPidl = Left$(sPath, InStr(sPath, Chr$(0)) - 1)
   End If
End Function

 Private Function ArrayFromStream(Stream As IUnknown, arrayBytes() As Byte) As Boolean

    ' Purpose: Return the array contained in an IUnknown interface
    
    Dim o_hMem As Long, o_lpMem As Long
    Dim o_lngByteCount As Long
    
    If Not Stream Is Nothing Then
    
        If GetHGlobalFromStream(ByVal ObjPtr(Stream), o_hMem) = 0 Then
            o_lngByteCount = GlobalSize(o_hMem)
            If o_lngByteCount > 0 Then
                o_lpMem = GlobalLock(o_hMem)
                If o_lpMem <> 0 Then
                    ReDim arrayBytes(0 To o_lngByteCount - 1)
                    CopyMemory arrayBytes(0), ByVal o_lpMem, o_lngByteCount
                    GlobalUnlock o_hMem
                    ArrayFromStream = True
                End If
            End If
        End If

    End If
    
End Function
 
Public Function IsGdiPlusInstaled() As Boolean
'    Dim hLib As Long
'
'    hLib = LoadLibrary("gdiplus.dll")
'    If hLib Then
'        If GetProcAddress(hLib, "GdiplusStartup") Then
'            IsGdiPlusInstaled = True
'        End If
'        FreeLibrary hLib
'    End If
'
End Function



Public Function iparseIsArrayEmpty(FarPointer As Long) As Long
  ' test to see if an array has been initialized
  CopyMemory iparseIsArrayEmpty, ByVal FarPointer, 4&
End Function
