VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsRegHotKey"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'Pequea Reforma del cRegHotKey de VBAcelerator a gusto.
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal Length As Long)
Private Declare Function SetWindowLongA Lib "user32" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function CallWindowProcA Lib "user32" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function RegisterHotKey Lib "user32" (ByVal hwnd As Long, ByVal id As Long, ByVal fsModifiers As Long, ByVal vk As Long) As Long
Private Declare Function UnregisterHotKey Lib "user32" (ByVal hwnd As Long, ByVal id As Long) As Long
Private Declare Function GlobalAddAtom Lib "kernel32" Alias "GlobalAddAtomA" (ByVal lpString As String) As Integer
Private Declare Function GlobalDeleteAtom Lib "kernel32" (ByVal nAtom As Integer) As Integer
Private Declare Function GetTickCount Lib "kernel32" () As Long
Private Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByRef lParam As Any) As Long
Private Declare Function IsIconic Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function IsWindowVisible Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function ShowWindow Lib "user32" (ByVal hwnd As Long, ByVal nCmdShow As Long) As Long
Private Declare Function CreateWindowEx Lib "user32.dll" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByRef lpParam As Any) As Long
Private Declare Function DestroyWindow Lib "user32.dll" (ByVal hwnd As Long) As Long


Private Const WM_SYSCOMMAND = &H112
Private Const SC_RESTORE = &HF120&
Private Const SW_SHOW = 5

Private Const GWL_WNDPROC As Long = -4

Private Const IDHOT_SNAPWINDOW = -1          '/* SHIFT-PRINTSCRN  */
Private Const IDHOT_SNAPDESKTOP = -2         '/* PRINTSCRN        */
Private Const WM_HOTKEY = &H312&

Private Type tHotKeyInfo
   sName As String
   sAtomName As String
   lID As Long
   eKey As KeyCodeConstants
   eModifiers As EHKModifiers
End Type

Public Enum EHKModifiers
   MOD_ALT = &H1&
   MOD_CONTROL = &H2&
   MOD_SHIFT = &H4&
   MOD_WIN = &H8&
End Enum

Public Event HotKeyPress(ByVal sName As String, ByVal eModifiers As EHKModifiers, ByVal eKey As KeyCodeConstants)

Private m_tAtoms() As tHotKeyInfo
Private m_iAtomCount As Long
Private m_hWnd As Long
Private PrevWndProc As Long
Private bvASM(40) As Byte

Public Function WindowProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    WindowProc = CallWindowProcA(PrevWndProc, hwnd, uMsg, wParam, lParam)
 
    Dim i As Long
    Dim lIndex As Long

   If (uMsg = WM_HOTKEY) Then
      ' Interpret the hotkey.  wParam is the id, the
      ' loword of lParam is the key modifier and the
      ' hiword of lParam is the key code:
      Select Case wParam
      Case IDHOT_SNAPWINDOW
         RaiseEvent HotKeyPress("Window Snapshot", MOD_SHIFT, vbKeySnapshot)
      Case IDHOT_SNAPDESKTOP
         RaiseEvent HotKeyPress("Desktop Snapshot", 0, vbKeySnapshot)
      Case Else
         ' Try to find id:
         For i = 1 To m_iAtomCount
            If (m_tAtoms(i).lID = wParam) Then
               lIndex = i
               Exit For
            End If
         Next i
         If (lIndex <> 0) Then
            RaiseEvent HotKeyPress(m_tAtoms(lIndex).sName, m_tAtoms(lIndex).eModifiers, m_tAtoms(lIndex).eKey)
         Else
            ' What has happened?
            RaiseEvent HotKeyPress("Unknown HotKey", (lParam And &HFFFF&), (lParam \ &H10000))
         End If
      End Select
    End If
 

End Function

 
Private Sub SetSubclassing(Obj As Object, hwnd As Long)
    Dim WindowProcAddress As Long
    Dim pObj As Long
    Dim pVar As Long
    Dim i As Long

    For i = 0 To 40
        bvASM(i) = Choose(i + 1, &H55, &H8B, &HEC, &H83, &HC4, &HFC, &H8D, &H45, &HFC, &H50, &HFF, &H75, &H14, _
                                 &HFF, &H75, &H10, &HFF, &H75, &HC, &HFF, &H75, &H8, &H68, &H0, &H0, &H0, &H0, _
                                 &HB8, &H0, &H0, &H0, &H0, &HFF, &HD0, &H8B, &H45, &HFC, &HC9, &HC2, &H10, &H0)
    Next i
 
    pObj = ObjPtr(Obj)
 
    Call CopyMemory(pVar, ByVal pObj, 4)
    Call CopyMemory(WindowProcAddress, ByVal (pVar + 28), 4)
 
    Call LongToByte(pObj, bvASM, 23)
    Call LongToByte(WindowProcAddress, bvASM, 28)
 
    PrevWndProc = SetWindowLongA(hwnd, GWL_WNDPROC, VarPtr(bvASM(0)))
End Sub
 

Private Sub LongToByte(ByVal lLong As Long, ByRef bReturn() As Byte, Optional i As Integer = 0)
    bReturn(i) = lLong And &HFF
    bReturn(i + 1) = (lLong And 65280) / &H100
    bReturn(i + 2) = (lLong And &HFF0000) / &H10000
    bReturn(i + 3) = ((lLong And &HFF000000) \ &H1000000) And &HFF
End Sub
 
Public Sub Clear()
   Dim i As Long
   ' Remove all hot keys and atoms:
   For i = m_iAtomCount To 1 Step -1
      UnregisterKey m_tAtoms(i).sName
   Next i

End Sub

Public Function RegisterKey(ByVal sName As String, ByVal eKey As KeyCodeConstants, ByVal eModifiers As EHKModifiers) As Boolean
    Dim lID As Long
    Dim lErr As Long
    Dim lR As Long
    Dim sError As String
    Dim sMsg As String
    Dim i As Long
    Dim sAtomName As String

   ' Check for valid user name:
   If Len(sName) > 32 Then Exit Function
 
    For i = 1 To m_iAtomCount
       If (m_tAtoms(i).sName = sName) Then Exit Function
    Next i

   sAtomName = sName & "_" & App.EXEName & "_" & GetTickCount()
   
   If (Len(sAtomName) > 254) Then sAtomName = Left$(sAtomName, 254)
   
   ' Create a new atom:
   lID = GlobalAddAtom(sAtomName)
   If (lID = 0) Then Exit Function

   lR = RegisterHotKey(m_hWnd, lID, eModifiers, eKey)
   
   If (lR = 0) Then
       GlobalDeleteAtom lID
    Else
       m_iAtomCount = m_iAtomCount + 1
       ReDim Preserve m_tAtoms(1 To m_iAtomCount) As tHotKeyInfo
       With m_tAtoms(m_iAtomCount)
          .sName = sName
          .sAtomName = sAtomName
          .lID = lID
          .eModifiers = eModifiers
          .eKey = eKey
       End With
       RegisterKey = True
    End If
         
End Function

Public Function UnregisterKey(ByVal sName As String) As Boolean
    Dim lIndex As Long
    Dim i As Long
    lIndex = AtomIndex(sName)
    If (lIndex > 0) Then
       ' Unregister the key:
       UnregisterHotKey m_hWnd, m_tAtoms(lIndex).lID
       ' Unregister the atom:
       GlobalDeleteAtom m_tAtoms(lIndex).lID
       ' Remove from internal array:
       If (m_iAtomCount > 1) Then
          For i = lIndex To m_iAtomCount - 1
             LSet m_tAtoms(lIndex) = m_tAtoms(lIndex + 1)
          Next i
          m_iAtomCount = m_iAtomCount - 1
          ReDim Preserve m_tAtoms(1 To m_iAtomCount) As tHotKeyInfo
       Else
          m_iAtomCount = 0
          Erase m_tAtoms
       End If
       UnregisterKey = True
    End If
End Function

Private Property Get AtomIndex(ByVal sName As String) As Long
    Dim i As Long
    For i = 1 To m_iAtomCount
       If (m_tAtoms(i).sName = sName) Then
          AtomIndex = i
          Exit Property
       End If
    Next i
    Err.Raise vbObjectError + 1048 + 1, App.EXEName & ".cRegHotKey", "No hot key registered under the name '" & sName & "'"
End Property


Public Property Get ModifiersByName(ByVal sName As String) As EHKModifiers
    Dim i As Long
    For i = 1 To m_iAtomCount
       If (m_tAtoms(i).sName = sName) Then
          ModifiersByName = m_tAtoms(i).eModifiers
          Exit Property
       End If
    Next i
    Err.Raise vbObjectError + 1048 + 1, App.EXEName & ".cRegHotKey", "No hot key registered under the name '" & sName & "'"
End Property

Public Property Get KeyByName(ByVal sName As String) As KeyCodeConstants
    Dim i As Long
    For i = 1 To m_iAtomCount
       If (m_tAtoms(i).sName = sName) Then
          KeyByName = m_tAtoms(i).eKey
          Exit Property
       End If
    Next i
    Err.Raise vbObjectError + 1048 + 1, App.EXEName & ".cRegHotKey", "No hot key registered under the name '" & sName & "'"
End Property


Public Sub RestoreAndActivate(ByVal hwnd As Long)
   If (IsWindowVisible(hwnd) = 0) Then ShowWindow hwnd, SW_SHOW
   If (IsIconic(hwnd) <> 0) Then Call SendMessage(hwnd, WM_SYSCOMMAND, SC_RESTORE, ByVal 0&)
   SetForegroundWindow hwnd
End Sub

Private Sub Class_Initialize()
    m_hWnd = CreateWindowEx(0&, "Static", vbNullString, 0&, 0&, 0&, 0&, 0&, 0&, 0&, App.hInstance, 0&)
    If m_hWnd Then Call SetSubclassing(Me, m_hWnd)
End Sub

Private Sub Class_Terminate()
   Clear
   If (m_hWnd <> 0) Then
       Call SetWindowLongA(m_hWnd, GWL_WNDPROC, PrevWndProc)
       DestroyWindow m_hWnd
   End If
End Sub





