Attribute VB_Name = "MdlAutoRun"
Option Explicit
'----------------------------------------------
'Autor: Leandro Ascierto
'Web:   www.leandroascierto.com
'Date:  04/05/2009
'Name:  MdlAutoRun
'----------------------------------------------
Private Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Private Declare Function RegSetValueExString Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal lpValue As String, ByVal cbData As Long) As Long
Private Declare Function RegDeleteKey& Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, ByVal lpSubKey As String)
Private Declare Function RegQueryValueExNULL Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, ByVal lpData As Long, lpcbData As Long) As Long
Private Declare Function RegQueryValueExString Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, ByVal lpData As String, lpcbData As Long) As Long
Private Declare Function RegDeleteValue& Lib "advapi32.dll" Alias "RegDeleteValueA" (ByVal hKey As Long, ByVal lpValueName As String)
 
Private Const RAMA_RUN_WINDOWS As String = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run"
Private Const HKEY_CLASSES_ROOT = &H80000000
Private Const HKEY_CURRENT_USER = &H80000001
Private Const HKEY_LOCAL_MACHINE = &H80000002
Private Const HKEY_USERS = &H80000003
Private Const REG_SZ As Long = 1
Private Const KEY_ALL_ACCESS = &H3F
 
Public Function SetAutoRun(Value As Boolean, Optional sCommand As String) As Boolean
    Dim Path          As String
    Dim Handle        As Long
    Path = Chr(34) & App.Path & "\" & App.EXEName & ".exe" & Chr(34) & IIf(Len(sCommand), " " & sCommand, "")
    RegOpenKeyEx HKEY_CURRENT_USER, RAMA_RUN_WINDOWS, 0, KEY_ALL_ACCESS, Handle
    If Value Then
        SetAutoRun = RegSetValueExString(Handle, App.Title, 0&, REG_SZ, Path, Len(Path)) = 0
    Else
        SetAutoRun = RegDeleteValue(Handle, App.Title) = 0
    End If
    RegCloseKey Handle
End Function
 
Public Function IsAutoRun() As Boolean
    Dim Path          As String
    Dim Handle        As Long
    Dim Data          As String
    Dim cch           As Long
    Path = Chr(34) & App.Path & "\" & App.EXEName & ".exe" & Chr(34)
    RegOpenKeyEx HKEY_CURRENT_USER, RAMA_RUN_WINDOWS, 0, KEY_ALL_ACCESS, Handle
    RegQueryValueExNULL Handle, App.Title, 0&, 0&, 0&, cch
 
    If cch > 0 Then
        Data = String(cch - 1, 0)
        RegQueryValueExString Handle, App.Title, 0&, 0&, Data, cch
        IsAutoRun = InStr(Data, Path) > 0
    End If
    RegCloseKey Handle
 
End Function
