Attribute VB_Name = "MdlAviPreview"
Option Explicit
'----------------------------------------------
'Autor: Leandro Ascierto
'Web:   www.leandroascierto.com
'Date:  20/08/2012
'Name:  MdlAviPreview
'----------------------------------------------
Private Declare Function OleCreatePictureIndirect Lib "olepro32.dll" (PicDesc As PicBmp, RefIID As GUID, ByVal fPictureOwnsHandle As Long, IPic As IPicture) As Long
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal hdc As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function DrawDibDraw Lib "msvfw32.dll" (ByVal hdd As Long, ByVal hdc As Long, ByVal xDst As Long, ByVal yDst As Long, ByVal dxDst As Long, ByVal dyDst As Long, ByRef lpbi As Long, ByRef lpBits As Any, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dxSrc As Long, ByVal dySrc As Long, ByVal wFlags As Long) As Long
Private Declare Function DrawDibOpen Lib "msvfw32.dll" () As Long
Private Declare Function DrawDibClose Lib "msvfw32.dll" (ByVal hdd As Long) As Long
Private Declare Function FillRect Lib "user32.dll" (ByVal hdc As Long, ByRef lpRect As RECT, ByVal hBrush As Long) As Long
Private Declare Function OleTranslateColor Lib "olepro32.dll" (ByVal OLE_COLOR As Long, ByVal hPalette As Long, pccolorref As Long) As Long
Private Declare Function CreateSolidBrush Lib "gdi32.dll" (ByVal crColor As Long) As Long
Private Declare Function DeleteObject Lib "gdi32.dll" (ByVal hObject As Long) As Long
Private Declare Function SetStretchBltMode Lib "gdi32" (ByVal hdc As Long, ByVal nStretchMode As Long) As Long
Private Declare Function ReleaseDC Lib "user32.dll" (ByVal hwnd As Long, ByVal hdc As Long) As Long
Private Declare Function StretchBlt Lib "gdi32.dll" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDst As Any, pSrc As Any, ByVal ByteLen As Long)
Private Declare Sub AVIFileInit Lib "avifil32.dll" ()
Private Declare Sub AVIFileExit Lib "avifil32.dll" ()
Private Declare Function AVIStreamGetFrameOpen Lib "avifil32.dll" (ByVal pAVIStream As Long, ByRef BIH As Any) As Long
Private Declare Function AVIStreamGetFrameClose Lib "avifil32.dll" (ByVal pGetFrameObj As Long) As Long
Private Declare Function AVIStreamRelease Lib "avifil32.dll" (ByVal pavi As Long) As Long
Private Declare Function AVIStreamGetFrame Lib "avifil32.dll" (ByVal pGetFrameObj As Long, ByVal lPos As Long) As Long
Private Declare Function AVIStreamOpenFromFile Lib "avifil32.dll" Alias "AVIStreamOpenFromFileA" (ppavi As Any, ByVal szFile As String, ByVal fccType As Long, ByVal lParam As Long, ByVal mode As Long, pclsidHandler As Any) As Long
Private Declare Function AVIStreamReadFormat Lib "avifil32.dll" (pavi As Any, ByVal lPos As Long, lpFormat As Any, ByRef lpcbFormat As Long) As Long
Private Declare Function AVIStreamStart Lib "avifil32.dll" (ByVal pavi As Long) As Long

Private Type GUID
    Data1 As Long
    Data2 As Integer
    Data3 As Integer
    Data4(7) As Byte
End Type

Private Type PicBmp
    Size As Long
    Type As Long
    hBmp As Long
    hPal As Long
    Reserved As Long
End Type

Private Type Size
    cx As Long
    cy As Long
End Type

Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Private Const STREAM_TYPE_VIDEO = &H73646976
Private Const OF_READ = &H0
Private Const OF_SHARE_EXCLUSIVE = &H10
Private Const AVIGETFRAMEF_BESTDISPLAYFMT As Long = 1

Private Const OF_SHARE_DENY_WRITE As Long = &H20

Private Type AVIFileInfo
    dwMaxBytesPerSec As Long
    dwFlags As Long
    dwCaps As Long
    dwStreams As Long
    dwSuggestedBufferSize As Long
    dwWidth As Long
    dwHeight As Long
    dwScale As Long
    dwRate As Long
    dwLength As Long
    dwEditCount As Long
    szFileType As String * 64
End Type

Private Declare Function AVIFileOpen Lib "avifil32" Alias "AVIFileOpenA" (ppfile As Long, ByVal szFile As String, ByVal mode As Long, pclsidHandler As Any) As Long
Private Declare Function AVIFileRelease Lib "avifil32" (ByVal pfile As Long) As Long
Private Declare Function AVIFileInfo Lib "avifil32" Alias "AVIFileInfoA" (ByVal pfile As Long, pfi As AVIFileInfo, ByVal lSize As Long) As Long


Public Function GetAviDuration(ByVal sPath As String) As Long

    Dim hFile As Long, AviInfo As AVIFileInfo
    Dim framesPerSecond As Long
    
    AVIFileInit

    If AVIFileOpen(hFile, sPath, OF_READ Or OF_SHARE_EXCLUSIVE, ByVal 0&) = 0 Then
        
        If AVIFileInfo(hFile, AviInfo, Len(AviInfo)) = 0 Then
            framesPerSecond = AviInfo.dwRate / AviInfo.dwScale
            GetAviDuration = AviInfo.dwLength \ framesPerSecond
        End If
   
        AVIFileRelease hFile
    End If
    
    AVIFileExit
End Function




Public Function GetAviPreview(FileName As String, ByVal Width As Long, ByVal Height As Long, Optional BackColor As OLE_COLOR = -1, Optional StretchOptimize As Boolean, Optional JustifyRect As Boolean) As StdPicture
    Dim hDCMemory As Long, hBmp As Long, hBmpPrev As Long, hBrush As Long, Rec As RECT, lColor As Long
    Dim Pic As PicBmp, IPic As IPicture, IID_IDispatch As GUID
    Dim PLeft As Long, PTop As Long, ReqWidth As Long, ReqHeight As Long
    Dim HScale As Double, VScale As Double, MyScale As Double
    Dim bBIH() As Byte
    Dim pAVIStream As Long
    Dim pGetFrameObj As Long
    Dim hDrawDib As Long
    Dim lSize As Long
    Dim FrameSize As Size
    Dim pDIB As Long
    Dim lDC As Long
    Dim FirstFrame As Long
    
    Call AVIFileInit
    
    If AVIStreamOpenFromFile(pAVIStream, FileName, STREAM_TYPE_VIDEO, 0, OF_READ Or OF_SHARE_EXCLUSIVE, ByVal 0&) = 0 Then

        pGetFrameObj = AVIStreamGetFrameOpen(pAVIStream, ByVal AVIGETFRAMEF_BESTDISPLAYFMT)

        If pGetFrameObj <> 0 Then
            
            If AVIStreamReadFormat(ByVal pAVIStream, 0, ByVal 0&, lSize) = 0 Then
    
                ReDim bBIH(lSize - 1)
                
                Call AVIStreamReadFormat(ByVal pAVIStream, 0, bBIH(0), lSize)
                
                CopyMemory FrameSize, bBIH(4), 8
                
                FirstFrame = AVIStreamStart(pAVIStream)
                
                If FirstFrame <> -1 Then
                
                    pDIB = AVIStreamGetFrame(ByVal pGetFrameObj, FirstFrame)
            
                    If pDIB <> 0 Then
                    
                    
                        HScale = Width / FrameSize.cx
                        VScale = Height / FrameSize.cy
                    
                        MyScale = IIf(VScale >= HScale, HScale, VScale)
                        
                        ReqWidth = FrameSize.cx * MyScale
                        ReqHeight = FrameSize.cy * MyScale
                        
                    

                     
                        lDC = GetDC(0)
                        
                        hDCMemory = CreateCompatibleDC(lDC)
                        
                        If JustifyRect Then
                            PLeft = (Width - ReqWidth) / 2
                            PTop = (Height - ReqHeight) / 2
                            hBmp = CreateCompatibleBitmap(lDC, Width, Height)
                        Else
                            hBmp = CreateCompatibleBitmap(lDC, ReqWidth, ReqHeight)
                        End If
                        
        
                        hBmpPrev = SelectObject(hDCMemory, hBmp)
                        
                        If BackColor <> -1 Then
                            OleTranslateColor BackColor, 0, lColor
                            hBrush = CreateSolidBrush(lColor)
                            Rec.Right = Width: Rec.Bottom = Height
                            FillRect hDCMemory, Rec, hBrush
                            DeleteObject hBrush
                        End If
                        

        
                        hDrawDib = DrawDibOpen
                    
                        If StretchOptimize Then
                            Dim hDCMemory2 As Long, hBmp2 As Long, hBmpPrev2 As Long
                            hDCMemory2 = CreateCompatibleDC(lDC)
                            hBmp2 = CreateCompatibleBitmap(lDC, FrameSize.cx, FrameSize.cy)
                            hBmpPrev2 = SelectObject(hDCMemory2, hBmp2)
                            Call DrawDibDraw(hDrawDib, hDCMemory2, 0, 0, FrameSize.cx, FrameSize.cy, ByVal pDIB, ByVal 0&, 0, 0, -1, -1, 0)
                          
                            SetStretchBltMode hDCMemory, vbPaletteModeNone
                            StretchBlt hDCMemory, PLeft, PTop, ReqWidth, ReqHeight, hDCMemory2, 0, 0, FrameSize.cx, FrameSize.cy, vbSrcCopy
                        
                            DeleteObject SelectObject(hDCMemory2, hBmpPrev2)
                            DeleteDC hDCMemory2
                        Else
                            Call DrawDibDraw(hDrawDib, hDCMemory, PLeft, PTop, ReqWidth, ReqHeight, ByVal pDIB, ByVal 0&, 0, 0, -1, -1, 0)
                        End If
                        
                        
                        DrawDibClose hDrawDib
                        
                        hBmp = SelectObject(hDCMemory, hBmpPrev)
                        
                        DeleteDC hDCMemory
                        ReleaseDC 0&, lDC
                        
                        With IID_IDispatch
                            .Data1 = &H20400
                            .Data4(0) = &HC0
                            .Data4(7) = &H46
                        End With
                    
                        With Pic
                            .Size = Len(Pic)
                            .Type = vbPicTypeBitmap
                            .hBmp = hBmp
                        End With
                        
                        OleCreatePictureIndirect Pic, IID_IDispatch, 1, IPic
        
                        Set GetAviPreview = IPic
                        
                    End If
                    
                End If
                
            End If
        
            Call AVIStreamGetFrameClose(pGetFrameObj)
        End If
    
        AVIStreamRelease pAVIStream
    
    End If

    Call AVIFileExit

End Function
