Attribute VB_Name = "MdlBrowseFolder"
Option Explicit

Private Declare Sub CoTaskMemFree Lib "ole32.dll" (ByVal hMem As Long)
Private Declare Function SHBrowseForFolder Lib "shell32" (lpbi As BROWSEINFO) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32" (ByVal pidList As Long, ByVal lpBuffer As String) As Long

Private Type BROWSEINFO
    hOwner          As Long
    pidlRoot        As Long
    pszDisplayName  As String
    lpszTitle       As String
    ulFlags         As Long
    lpfn            As Long
    lParam          As Long
    iImage          As Long
End Type

Private Const BIF_RETURNONLYFSDIRS      As Long = 1
Private Const BIF_NEWDIALOGSTYLE        As Long = &H40
Private Const MAX_PATH                  As Long = 260

Public Function ShowBrowseFolder(ByVal hWndOwner As Long, ByVal sTitle As String) As String

    Dim iNull As Integer, lpIDList As Long
    Dim sPath As String, tBI As BROWSEINFO

    With tBI
        .hOwner = hWndOwner
        .lpszTitle = sTitle
        .ulFlags = BIF_RETURNONLYFSDIRS Or BIF_NEWDIALOGSTYLE
    End With

    lpIDList = SHBrowseForFolder(tBI)
    If lpIDList Then
        sPath = String$(MAX_PATH, 0)
        
        SHGetPathFromIDList lpIDList, sPath

        CoTaskMemFree lpIDList
        iNull = InStr(sPath, vbNullChar)
        If iNull Then
            sPath = Left$(sPath, iNull - 1)
        End If
    End If

    ShowBrowseFolder = sPath
End Function
