VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cSkinClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const BITSPIXEL         As Long = 12

Private Const WS_MAXIMIZEBOX    As Long = &H10000
Private Const WS_MINIMIZEBOX    As Long = &H20000
Private Const WS_THICKFRAME     As Long = &H40000
Private Const WS_CAPTION        As Long = &HC00000

Private Const GWL_EXSTYLE       As Long = -20
Private Const GWL_STYLE         As Long = -16

Private Const WS_EX_LAYERED     As Long = &H80000

Private Const LWA_COLORKEY      As Long = &H1
Private Const ULW_ALPHA         As Long = &H2

Private Const AC_SRC_ALPHA      As Long = &H1
Private Const AC_SRC_OVER       As Long = &H0

Private Type POINTAPI
    X                           As Long
    Y                           As Long
End Type

Private Type Size
    cX                          As Long
    cY                          As Long
End Type

Private Type tOSVERSIONINFO
    dwOSVersionInfoSize         As Long
    dwMajorVersion              As Long
    dwMinorVersion              As Long
    dwBuildNumber               As Long
    dwPlatformId                As Long
    szCSDVersion                As String * 128
End Type

Private Declare Function GetDeviceCaps Lib "gdi32" (ByVal hDC As Long, ByVal nIndex As Long) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" (lpVersionInformation As tOSVERSIONINFO) As Long
Private Declare Function GetWindowLong Lib "user32.dll" Alias "GetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function SetWindowLong Lib "user32.dll" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function SetLayeredWindowAttributes Lib "user32.dll" (ByVal hwnd As Long, ByVal crKey As Long, ByVal bAlpha As Byte, ByVal dwFlags As Long) As Long
Private Declare Function IsWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function UpdateLayeredWindow Lib "user32.dll" (ByVal hwnd As Long, ByVal hdcDst As Long, ByRef pptDst As Any, ByRef psize As Any, ByVal hdcSrc As Long, ByRef pptSrc As Any, ByVal crKey As Long, ByRef pblend As Long, ByVal dwFlags As Long) As Long

Private c_lhWnd     As Long
Private c_Rgn     As Long
Private c_lOpacity  As Long

Public Property Let Opacity(ByVal lOpacity As Long)
    If lOpacity > 100 Then lOpacity = 100
    If lOpacity < 0 Then lOpacity = 0
    c_lOpacity = (255 * lOpacity) \ 100
End Property

Public Property Get Opacity() As Long
    Opacity = c_lOpacity
End Property

Public Property Let Client(ByVal hwnd As Long)
    If Not IsWindow(hwnd) = 0 Then
        c_lhWnd = hwnd
        'lClienthWnd = Hwnd
    End If
End Property

Friend Function Rgn() As Long
    Rgn = c_Rgn
End Function

Friend Function hwnd() As Long
    hwnd = c_lhWnd
End Function

Public Function Render(ByVal cDib As c32bppDIB)
    Dim srcPt As POINTAPI
    Dim srcSize As Size
    Dim lBlendFunc As Long

    srcSize.cX = cDib.Width
    srcSize.cY = cDib.Height
    DeleteObject c_Rgn
    c_Rgn = cDib.CreateRegion(regionShaped, 0, 0)
    lBlendFunc = AC_SRC_OVER Or (c_lOpacity * &H10000) _
       Or (AC_SRC_ALPHA * &H1000000)

    UpdateLayeredWindow hwnd, 0&, ByVal 0&, srcSize, _
       cDib.LoadDIBinDC(True), srcPt, 0&, lBlendFunc, ULW_ALPHA
       Set cDib = Nothing
End Function

Public Function ApplyStyle() As Boolean
    Dim lRet As Long
    
    If Not c_lhWnd = 0 Then
        If IsLayeredSupported Then
            lRet = GetWindowLong(c_lhWnd, GWL_STYLE)
            lRet = lRet And Not WS_MAXIMIZEBOX And Not WS_MINIMIZEBOX And Not WS_THICKFRAME And Not WS_CAPTION
            Call SetWindowLong(c_lhWnd, GWL_STYLE, lRet)
        
            lRet = GetWindowLong(c_lhWnd, GWL_EXSTYLE)
            Call SetWindowLong(c_lhWnd, GWL_EXSTYLE, lRet Or WS_EX_LAYERED)
            
            ApplyStyle = True
        End If
    End If
End Function

Private Function IsLayeredSupported() As Boolean
    Dim OSV As tOSVERSIONINFO
  
    With OSV
        .dwOSVersionInfoSize = Len(OSV)
        Call GetVersionEx(OSV)
        If .dwMajorVersion >= 5 Then
            IsLayeredSupported = (GetDeviceCaps(GetDC(0), BITSPIXEL) >= 16)
        End If
    End With
End Function

Private Sub Class_Initialize()
    c_lOpacity = 255
End Sub
