VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cToolBar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const ULW_ALPHA     As Long = &H2
Private Const AC_SRC_ALPHA  As Long = &H1
Private Const AC_SRC_OVER   As Long = &H0
Private Const HIDETIME      As Long = 2

Private Type RECT
    Left                    As Long
    Top                     As Long
    Right                   As Long
    Bottom                  As Long
End Type

Private Type POINTAPI
    X                       As Long
    Y                       As Long
End Type

Private Type Size
    cX                      As Long
    cY                      As Long
End Type

Private Declare Function UpdateLayeredWindow Lib "user32.dll" (ByVal hwnd As Long, ByVal hdcDst As Long, ByRef pptDst As Any, ByRef psize As Any, ByVal hdcSrc As Long, ByRef pptSrc As Any, ByVal crKey As Long, ByRef pblend As Long, ByVal dwFlags As Long) As Long
Private Declare Function MoveWindow Lib "user32" (ByVal hwnd As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long
Private Declare Function GetWindowRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function WindowFromPoint Lib "user32" (ByVal xPoint As Long, ByVal yPoint As Long) As Long
Private Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
Private Declare Function PtInRect Lib "user32" (lpRect As RECT, ByVal X As Long, ByVal Y As Long) As Long
Private Declare Function SetCursor Lib "user32" (ByVal hCursor As Long) As Long
Private Declare Function LoadCursor Lib "user32" Alias "LoadCursorA" (ByVal hInstance As Long, ByVal lpCursorName As Long) As Long
Private Declare Function DestroyCursor Lib "user32" (ByVal hCursor As Long) As Long
Private Declare Function CreateEllipticRgnIndirect Lib "gdi32" (lpRect As RECT) As Long
Private Declare Function SetRect Lib "user32" (lpRect As RECT, ByVal x1 As Long, ByVal y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function PtInRegion Lib "gdi32" (ByVal hRgn As Long, ByVal X As Long, ByVal Y As Long) As Long
Private Declare Function ScreenToClient Lib "user32.dll" (ByVal hwnd As Long, ByRef lpPoint As POINTAPI) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function CreateRoundRectRgn Lib "gdi32" (ByVal x1 As Long, ByVal y1 As Long, ByVal X2 As Long, ByVal Y2 As Long, ByVal X3 As Long, ByVal Y3 As Long) As Long

Private Const IDC_HAND      As Long = 32649
Private Const IDC_ARROW     As Long = 32512&

Implements iWindow

Private c_cWindow           As cWindow
Private c_lhWnd             As Long
Private c_lOpacity          As Long
Private c_lLeft             As Long
Private c_lTop              As Long
Private c_lWidth            As Long
Private c_lHeight           As Long
'Private c_Interface         As IToolBar
Private WithEvents c_cTimer As cTimer
Attribute c_cTimer.VB_VarHelpID = -1
Private c_Back              As c32bppDIB
Private c_Img               As c32bppDIB

Private m_lStartTime        As Long
Private m_ClientHwnd        As Long

Dim RGN1                    As Long
Dim RGN2                    As Long
Dim h_ARROW                 As Long
Dim h_HAND                  As Long
Dim BtnId                   As Integer
Dim m_Visible               As Boolean
Public Event Click(Index As Integer)


'Public Function SetInterface(ByVal Interface As IToolBar)
'    Set c_Interface = Interface
'    c_cWindow.AddMsg -1
'End Function

Public Property Get cDib() As c32bppDIB
    Set cDib = c_Img
End Property


Public Property Get hwnd() As Long
    hwnd = c_lhWnd
End Property


Public Property Let ClientHwnd(Handle As Long)
    m_ClientHwnd = Handle
End Property


Public Property Get ClientHwnd() As Long
    ClientHwnd = m_ClientHwnd
End Property


Public Property Let Left(lLeft As Long)
    c_lLeft = lLeft
    Call MoveToWindow
End Property


Public Property Get Left() As Long
    Left = c_lLeft
End Property


Public Property Let Top(lTop As Long)
    c_lTop = lTop
    Call MoveToWindow
End Property


Public Property Get Top() As Long
    Top = c_lTop
End Property


Public Property Let Opacity(ByVal lOpacity As Long)
    If lOpacity > 100 Then lOpacity = 100
    If lOpacity < 0 Then lOpacity = 0
    c_lOpacity = (255 * lOpacity) \ 100
    Me.Render c_Back
End Property


Public Property Get Opacity() As Long
    Opacity = c_lOpacity
End Property


Private Sub c_cTimer_PulseTimer()
    Dim PT As POINTAPI
    Dim TR As RECT
    Dim hwnd As Long
    
    If m_lStartTime = 0 Then m_lStartTime = Timer
        
    Call GetWindowRect(m_ClientHwnd, TR)
    Call GetCursorPos(PT)
    hwnd = WindowFromPoint(PT.X, PT.Y)
    
    If hwnd = c_lhWnd Then
        m_lStartTime = Timer
    End If
    If Not PtInRect(TR, PT.X, PT.Y) = 0 Then
        m_lStartTime = Timer
    End If
    
    If m_lStartTime + HIDETIME < Timer Then
        Call Hide
    End If
End Sub


Private Sub Class_Initialize()

    c_lOpacity = 255
    Set c_cTimer = New cTimer
    Set c_cWindow = New cWindow
    Set c_Back = New c32bppDIB
    Set c_Img = New c32bppDIB
    
    Dim xLeft As Long
    Dim YTop As Long
    
    c_Back.InitializeDIB 44, 22

    c_Img.LoadPicture_File App.Path & "\Toolbar2.png"
    
    h_ARROW = LoadCursor(ByVal 0&, IDC_ARROW)
    h_HAND = LoadCursor(ByVal 0&, IDC_HAND)
    
    With c_cWindow
        Set .Owner = Me
        .WindowClassRegister "CWL_ToolBar" & ObjPtr(Me)
        c_lhWnd = .WindowCreate(WS_EX_TOOLWINDOW Or WS_EX_LAYERED, WS_POPUP, , , , 100, 100)
        .AddMsg WM_LBUTTONUP
        .AddMsg WM_LBUTTONDOWN
        .AddMsg WM_MOUSEMOVE
    End With

    RGN1 = CreateRoundRectRgn(4, 3, 4 + 16, 3 + 16, 3, 3)
    RGN2 = CreateRoundRectRgn(24, 3, 24 + 16, 3 + 16, 3, 3)
   
    DrawToolbar 0, 0
    
End Sub


Private Sub DrawToolbar(StateBtn1 As Integer, StateBtn2 As Integer)
    c_Back.EraseDIB
    c_Img.Render c_Back.LoadDIBinDC(True), 0, 0, 44, 22, 0, 0, 44, 22
    c_Img.Render c_Back.LoadDIBinDC(True), 4, 3, 16, 16, 44 + (StateBtn1 * 16), 0, 16, 16
    c_Img.Render c_Back.LoadDIBinDC(True), 24, 3, 16, 16, 44 + 48 + (StateBtn2 * 16), 0, 16, 16
    Me.Render c_Back
End Sub


Private Sub Class_Terminate()
    c_cWindow.WindowDestroy c_lhWnd
    Set c_cWindow = Nothing
    Set c_cTimer = Nothing
    Set c_Back = Nothing
    Set c_Img = Nothing
    
    DeleteObject RGN1
    DeleteObject RGN2
    DestroyCursor h_ARROW
    DestroyCursor h_HAND
End Sub


Public Sub Refresh()
    DrawToolbar 0, 0
End Sub


Public Function Render(ByVal cDib As c32bppDIB)
    Dim srcPt As POINTAPI
    Dim srcSize As Size
    Dim lBlendFunc As Long

    srcSize.cX = cDib.Width
    srcSize.cY = cDib.Height
    c_lWidth = cDib.Width
    c_lHeight = cDib.Height
    
    lBlendFunc = AC_SRC_OVER Or (c_lOpacity * &H10000) Or (AC_SRC_ALPHA * &H1000000)
    Call UpdateLayeredWindow(c_lhWnd, 0&, ByVal 0&, srcSize, cDib.LoadDIBinDC(True), srcPt, 0&, lBlendFunc, ULW_ALPHA)
End Function


Public Function Show()
    If Not m_Visible Then
        m_Visible = True
        Me.Refresh
        Call MoveToWindow
        Call ShowWindow(c_lhWnd, SW_SHOW)
        c_cTimer.StartTimer c_lhWnd, 50
        
    End If
End Function


Private Sub MoveToWindow()
    Dim TR As RECT
    Call GetWindowRect(m_ClientHwnd, TR)
    Call MoveWindow(c_lhWnd, TR.Left + c_lLeft, TR.Top + c_lTop, c_lWidth, c_lHeight, 0)
End Sub


Public Function Hide()
    If m_Visible Then
        m_Visible = False
        Call c_cTimer.StopTimer
        m_lStartTime = 0
        Call ShowWindow(c_lhWnd, SW_HIDE)
    End If
End Function


Private Function IsMouseInRgn(hRgn As Long) As Boolean
    Dim PT As POINTAPI
    Call GetCursorPos(PT)
    Call ScreenToClient(c_lhWnd, PT)
    IsMouseInRgn = PtInRegion(hRgn, PT.X, PT.Y)
End Function


Private Sub iWindow_Proc(bHandled As Boolean, lReturn As Long, hwnd As Long, uMsg As WinSubHook2.eMsg, wParam As Long, lParam As Long)

    If uMsg = WM_MOUSEMOVE Then
        If IsMouseInRgn(RGN1) Then
            SetCursor h_HAND
            BtnId = 1
            DrawToolbar 1 + IIf(wParam = 1, 1, 0), 0
        Else
            If IsMouseInRgn(RGN2) Then
                SetCursor h_HAND
                BtnId = 2
                DrawToolbar 0, 1 + IIf(wParam = 1, 1, 0)
            Else
                SetCursor h_ARROW
                BtnId = 0
                DrawToolbar 0, 0
            End If
        End If
    End If
    
    If uMsg = WM_LBUTTONDOWN Then
        If BtnId = 1 Then DrawToolbar 2, 0
        If BtnId = 2 Then DrawToolbar 0, 2
    End If
    
    If uMsg = WM_LBUTTONUP Then
        If BtnId > 0 Then
            c_cTimer.StopTimer
            RaiseEvent Click(BtnId)
            c_cTimer.StartTimer c_lhWnd, 50
        End If
        
        If IsMouseInRgn(RGN1) Then
            DrawToolbar 1, 0
        Else
            If IsMouseInRgn(RGN2) Then
                DrawToolbar 0, 1
            Else
                DrawToolbar 0, 0
            End If
        End If
        
    End If

    'If Not c_Interface Is Nothing Then
        'c_Interface.Proc bHandled, lReturn, hwnd, uMsg, wParam, lParam
    'End If
End Sub
