VERSION 5.00
Begin VB.UserControl ListBoxEx 
   BackColor       =   &H80000005&
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3300
   FillColor       =   &H00FF9999&
   BeginProperty Font 
      Name            =   "Segoe UI"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   KeyPreview      =   -1  'True
   ScaleHeight     =   240
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   220
   Begin VB.VScrollBar VScroll1 
      Height          =   3495
      LargeChange     =   20
      Left            =   2880
      TabIndex        =   2
      Top             =   0
      Visible         =   0   'False
      Width           =   255
   End
   Begin VB.Timer Timer1 
      Left            =   1320
      Top             =   1920
   End
   Begin VB.PictureBox PicScroll 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Webdings"
         Size            =   12
         Charset         =   2
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Index           =   1
      Left            =   0
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   220
      TabIndex        =   1
      Top             =   3345
      Visible         =   0   'False
      Width           =   3300
   End
   Begin VB.PictureBox PicScroll 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Webdings"
         Size            =   12
         Charset         =   2
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Index           =   0
      Left            =   0
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   220
      TabIndex        =   0
      Top             =   0
      Visible         =   0   'False
      Width           =   3300
   End
End
Attribute VB_Name = "ListBoxEx"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'---------------------------------------------------------------
'Autor:         Leandro Ascierto
'Web:           www.leandroascierto.com.ar
'Date:          13/07/09
'Module Name:   ListBoxEx
'---------------------------------------------------------------
Private Declare Function SetRect Lib "user32.dll" (ByRef lpRect As RECT, ByVal x1 As Long, ByVal y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function DrawText Lib "user32.dll" Alias "DrawTextA" (ByVal hDC As Long, ByVal lpStr As String, ByVal nCount As Long, ByRef lpRect As RECT, ByVal wFormat As Long) As Long
Private Declare Function FillRect Lib "user32.dll" (ByVal hDC As Long, ByRef lpRect As RECT, ByVal hBrush As Long) As Long
Private Declare Function CreateSolidBrush Lib "gdi32.dll" (ByVal crColor As Long) As Long
Private Declare Function SelectObject Lib "gdi32.dll" (ByVal hDC As Long, ByVal hObject As Long) As Long
Private Declare Function DeleteObject Lib "gdi32.dll" (ByVal hObject As Long) As Long
Private Declare Function DrawFocusRect Lib "user32.dll" (ByVal hDC As Long, ByRef lpRect As RECT) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hDC As Long) As Long
Private Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal hDC As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hDC As Long) As Long
Private Declare Function CreatePatternBrush Lib "gdi32.dll" (ByVal hBitmap As Long) As Long
Private Declare Function SetPixelV Lib "gdi32.dll" (ByVal hDC As Long, ByVal X As Long, ByVal Y As Long, ByVal crColor As Long) As Long
Private Declare Function RoundRect Lib "gdi32.dll" (ByVal hDC As Long, ByVal x1 As Long, ByVal y1 As Long, ByVal X2 As Long, ByVal Y2 As Long, ByVal X3 As Long, ByVal Y3 As Long) As Long
Private Declare Function CreatePen Lib "gdi32.dll" (ByVal nPenStyle As Long, ByVal nWidth As Long, ByVal crColor As Long) As Long
Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function OleTranslateColor Lib "oleaut32.dll" (ByVal lOleColor As Long, ByVal lHPalette As Long, ByVal lColorRef As Long) As Long
Private Declare Function ImageList_Add Lib "comctl32.dll" (ByVal himl As Long, ByVal hbmImage As Long, ByVal hbmMask As Long) As Long
Private Declare Function ImageList_Create Lib "comctl32.dll" (ByVal cx As Long, ByVal cy As Long, ByVal Flags As Long, ByVal cInitial As Long, ByVal cGrow As Long) As Long
Private Declare Function ImageList_Destroy Lib "comctl32.dll" (ByVal himl As Long) As Long
Private Declare Function ImageList_ReplaceIcon Lib "comctl32.dll" (ByVal himl As Long, ByVal i As Long, ByVal hIcon As Long) As Long
Private Declare Function ImageList_AddIcon Lib "comctl32.dll" (ByVal hImageList As Long, ByVal hIcon As Long) As Long
Private Declare Function ImageList_Remove Lib "comctl32.dll" (ByVal himl As Long, ByVal i As Long) As Long
Private Declare Function ImageList_Draw Lib "comctl32.dll" (ByVal himl As Long, ByVal i As Long, ByVal hdcDst As Long, ByVal X As Long, ByVal Y As Long, ByVal fStyle As Long) As Long
Private Declare Function ImageList_AddMasked Lib "comctl32" (ByVal hImageList As Long, ByVal hbmImage As Long, ByVal crMask As Long) As Long
Private Declare Function GetClientRect Lib "user32.dll" (ByVal hwnd As Long, ByRef lpRect As RECT) As Long
Private Declare Function GetCursorPos Lib "user32.dll" (ByRef lpPoint As POINTAPI) As Long
Private Declare Function ScreenToClient Lib "user32.dll" (ByVal hwnd As Long, ByRef lpPoint As POINTAPI) As Long
Private Declare Function WindowFromPoint Lib "user32.dll" (ByVal xPoint As Long, ByVal yPoint As Long) As Long
Private Declare Function PeekMessage Lib "user32" Alias "PeekMessageA" (lpMsg As Msg, ByVal hwnd As Long, ByVal wMsgFilterMin As Long, ByVal wMsgFilterMax As Long, ByVal wRemoveMsg As Long) As Long
Private Declare Function WaitMessage Lib "user32" () As Long
Private Declare Function Rectangle Lib "gdi32.dll" (ByVal hDC As Long, ByVal x1 As Long, ByVal y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function GetTickCount Lib "kernel32.dll" () As Long
Private Declare Function GetPixel Lib "gdi32.dll" (ByVal hDC As Long, ByVal X As Long, ByVal Y As Long) As Long
Private Declare Function LoadImage Lib "user32" Alias "LoadImageA" (ByVal hInst As Long, ByVal lpsz As String, ByVal dwImageType As Long, ByVal dwDesiredWidth As Long, ByVal dwDesiredHeight As Long, ByVal dwFlags As Long) As Long
Private Declare Function DestroyIcon Lib "user32.dll" (ByVal hIcon As Long) As Long
Private Declare Sub Sleep Lib "kernel32.dll" (ByVal dwMilliseconds As Long)
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (ByVal Destination As Long, ByVal Source As Long, ByVal Length As Long)

Private Const WM_MOUSEWHEEL         As Long = 522
Private Const PM_REMOVE             As Long = &H1
Private Const CLR_NONE              As Long = &HFFFFFFFF

Private Const DT_CENTER             As Long = &H1
Private Const DT_VCENTER            As Long = &H4
Private Const DT_WORD_ELLIPSIS      As Long = &H40000
Private Const DT_LEFT               As Long = &H0
Private Const DT_SINGLELINE         As Long = &H20
Private Const DT_BOTTOM             As Long = &H8
Private Const DT_FLAG               As Long = DT_VCENTER Or DT_SINGLELINE Or DT_WORD_ELLIPSIS

Private Const LR_LOADFROMFILE       As Long = &H10
Private Const LR_LOADMAP3DCOLORS    As Long = &H1000
Private Const LR_SHARED             As Long = &H8000&
Private Const IMAGE_ICON            As Long = 1

Private Const DI_MASK               As Long = &H1
Private Const DI_IMAGE              As Long = &H2
Private Const DI_NORMAL             As Long = DI_MASK Or DI_IMAGE

Private Const ILC_COLOR32           As Long = &H20
Private Const ILC_MASK              As Long = &H1
Private Const ILD_TRANSPARENT       As Long = &H1

Private Const COLOR_NONE             As Long = -1

Private Type UcsRgbQuad
    R                               As Byte
    G                               As Byte
    B                               As Byte
    a                               As Byte
End Type

Private Type RECT
    Left                            As Long
    Top                             As Long
    Right                           As Long
    Bottom                          As Long
End Type


Private Type POINTAPI
    X                               As Long
    Y                               As Long
End Type

Private Type Msg
    hwnd                            As Long
    Message                         As Long
    wParam                          As Long
    lParam                          As Long
    time                            As Long
    PT                              As POINTAPI
End Type

Private Type tItem
    Caption                         As String
    IconIndex                       As Long
    Tag                             As String
    ID                              As String
    ForeColor                       As OLE_COLOR
    'Selected                       As Boolean  'no en esta versin :)
End Type

Public Enum EnuScrollingStyle
    UpDownButton = 0
    ScrollBar = 1
End Enum

Public Enum EnuIconAlign
    AlingLeft = 0
    AlingTop = 1
End Enum

Public Enum EnuSelecionStyle
    Windows_Vista = 0
    Office = 1
    Windows_XP = 2
    Ribbon = 3
End Enum

Public Enum EnuListOrder
    AcendetOrder = 0
    DecendentOrder = 1
End Enum

Public Event Click(Index As Long)
Public Event MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
Public Event MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
Public Event MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
Public Event KeyDown(KeyCode As Integer, Shift As Integer)
Public Event KeyPress(KeyAscii As Integer)
Public Event KeyUp(KeyCode, Shift)
Public Event DblClick()

Private Const VistaDefaultColor     As Long = &HFFBB2F
Private Const RibbonDefaultColor    As Long = &H37C4FF
Private Const OfficeDefaultColor    As Long = &HFF6600

Private Item()                      As tItem
Private mCount                      As Long
Private mItemHeight                 As Long
Private mItemHitText                As Long
Private mItemSelected               As Long
Private mIconSize                   As Long
Private himl                        As Long
Private mScrollPos                  As Long
Private bCancel                     As Boolean
Private mScrollStyle                As EnuScrollingStyle
Private ItemsVisible                As Long
Private TextH                       As Long
Private mSelectionColor             As OLE_COLOR
Private mSelectionStyle             As EnuSelecionStyle
Private mBorderColor                As OLE_COLOR
Private mIconAlign                  As EnuIconAlign
Private InProcessMSG                As Boolean
Private mSelectionWidth             As Long
Private IsIn                        As Boolean

Public Sub About()
Attribute About.VB_UserMemId = -552
    MsgBox "Por Leandro Ascierto" & vbCrLf & "www.leandroascierto.com.ar"
End Sub

Public Function ImageListAddIcon(Icon As Long) As Boolean
    ImageListAddIcon = ImageList_AddIcon(himl, Icon) <> -1
    'Me.Refresh
End Function

Public Function ImageListLoadIconFromFile(ByVal Path As String) As Boolean
    Dim hIcon As Long
    hIcon = LoadImage(App.hInstance, Path, IMAGE_ICON, mIconSize, mIconSize, LR_LOADFROMFILE)
    If hIcon Then
        ImageListLoadIconFromFile = Me.ImageListAddIcon(hIcon)
        DestroyIcon hIcon
    End If
End Function

Public Function ImageListLoadIconFromResource(ByVal Section As String) As Boolean
    Dim hIcon As Long
    hIcon = LoadImage(App.hInstance, Section, IMAGE_ICON, mIconSize, mIconSize, LR_SHARED Or LR_LOADMAP3DCOLORS)
    If hIcon Then
        ImageListLoadIconFromResource = Me.ImageListAddIcon(hIcon)
        DestroyIcon hIcon
    End If
End Function

Public Function ImageListDraw(ByVal Index As Long, ByVal DestHdc As Long, ByVal X As Long, Y As Long) As Boolean
    ImageListDraw = ImageList_Draw(himl, Index, DestHdc, X, Y, ILD_TRANSPARENT) <> -1
End Function

Public Function ImageListRemoveIcon(Index As Long) As Boolean
    ImageListRemoveIcon = ImageList_Remove(himl, Index) <> -1
    Me.Refresh
End Function

Public Function ImageListReplaceIcon(Index As Long, NewIcon As Long) As Boolean
    ImageListReplaceIcon = ImageList_ReplaceIcon(himl, Index, NewIcon) <> -1
    Me.Refresh
End Function

Public Function ImageListAddBitmap(ByVal hBitmap As Long, Optional ByVal MaskColor As Long = CLR_NONE) As Integer
    If (MaskColor <> CLR_NONE) Then
        ImageListAddBitmap = ImageList_AddMasked(himl, hBitmap, MaskColor)
      Else
        ImageListAddBitmap = ImageList_Add(himl, hBitmap, 0)
    End If
End Function

Public Sub ImageListClear()
    ImageList_Remove himl, -1
    Me.Refresh
End Sub

Public Sub SetItemID(ByVal Index As Long, ByVal ID As String)
    Item(Index).ID = ID
End Sub

Public Function GetItemID(ByVal Index As Long) As String
    GetItemID = Item(Index).ID
End Function

Public Sub SetItemForeColor(ByVal Index As Long, ByVal newColor As OLE_COLOR)
    Item(Index).ForeColor = newColor
End Sub

Public Function GetItemForeColor(ByVal Index As Long) As OLE_COLOR
    GetItemForeColor = Item(Index).ForeColor
End Function

Public Sub SetItemTag(ByVal Index As Long, ByVal Tag As String)
    Item(Index).Tag = Tag
End Sub

Public Function GetItemTag(ByVal Index As Long) As String
    GetItemTag = Item(Index).Tag
End Function

Public Sub SetItemIconIndex(ByVal Index As Long, ByVal IconIndex As Long)
    Item(Index).IconIndex = IconIndex
    Me.Refresh
End Sub

Public Function GetItemIconIndex(ByVal Index As Long) As Long
    GetItemIconIndex = Item(Index).IconIndex
End Function

Public Sub SetItemCaption(ByVal Index As Long, ByVal Caption As String)
    Item(Index).Caption = Caption
    Me.Refresh
End Sub

Public Function GetItemCaption(ByVal Index As Long) As String
    GetItemCaption = Item(Index).Caption
End Function

Public Sub AddItems(ByVal Caption As String, ByVal IconIndex As Long, Optional ByVal Tag As String, Optional ByVal ID As String, Optional NoRedraw As Boolean = False, Optional ByVal oForeColor As OLE_COLOR = COLOR_NONE)

    Dim lTop As Long
    
    mCount = UBound(Item)
    
    With Item(mCount)
        .Caption = Caption
        .IconIndex = IconIndex
        .Tag = Tag
        .ID = ID
        .ForeColor = oForeColor
    End With
           
    mCount = mCount + 1
    ReDim Preserve Item(mCount)
    If Extender.Visible And Not NoRedraw Then Me.Refresh
    
End Sub

Public Sub DeleteItem(ByVal Index As Long)

    Dim i As Long
    
    'If Index <= mCount And Index > -1 Then
        For i = Index To mCount - 1
            Item(i) = Item(i + 1)
        Next
        If mItemSelected > -1 Then mItemSelected = mItemSelected - 1
        If mItemSelected = Index Then mItemSelected = -1
        
        mCount = mCount - 1
        
        If mCount - 1 < ItemsVisible Then
            mScrollPos = 0
        End If
        
        If mScrollPos Then mScrollPos = mScrollPos - 1
        
        If mCount > 0 Then
            ReDim Preserve Item(mCount)
        End If

        Me.Refresh
    'Else
    '    Debug.Print "Error"
    'End If

End Sub

Public Property Get Enabled() As Boolean
    Enabled = UserControl.Enabled
End Property


Public Property Let Enabled(ByVal blnEnabled As Boolean)
    UserControl.Enabled = blnEnabled
    PropertyChanged "Enabled"
    Refresh
End Property


Public Property Get Font() As Font
    Set Font = UserControl.Font
End Property

Public Property Set Font(ByVal objFont As Font)
    Set UserControl.Font = objFont
    PropertyChanged "Font"
    Me.Refresh
End Property

Public Property Get ForeColor() As OLE_COLOR
    ForeColor = UserControl.ForeColor
End Property

Public Property Let ForeColor(ByVal lngForeColor As OLE_COLOR)
    UserControl.ForeColor = lngForeColor
    PropertyChanged "ForeColor"
    Me.Refresh
End Property

Public Property Get SelectionColor() As OLE_COLOR
    SelectionColor = mSelectionColor
End Property

Public Property Let SelectionColor(ByVal newColor As OLE_COLOR)
    mSelectionColor = newColor
    PropertyChanged "SelectionColor"
    Me.Refresh
End Property

Public Property Get BackColor() As OLE_COLOR
    BackColor = UserControl.BackColor
End Property

Public Property Let BackColor(ByVal lngBackColor As OLE_COLOR)
    UserControl.BackColor = lngBackColor
    PicScroll(0).BackColor = lngBackColor
    PicScroll(1).BackColor = lngBackColor
    DrawArrow
    PropertyChanged "BackColor"
    Me.Refresh
End Property

Public Property Get BorderColor() As OLE_COLOR
    BorderColor = mBorderColor
End Property

Public Property Let BorderColor(ByVal NewBorderColor As OLE_COLOR)
    mBorderColor = NewBorderColor
    PropertyChanged "BorderColor"
    Me.Refresh
End Property

Public Property Get ListCount() As Long
    ListCount = mCount
End Property

Public Property Get SelectedIndex() As Long
Attribute SelectedIndex.VB_MemberFlags = "400"
    SelectedIndex = mItemSelected
End Property

Public Property Let SelectedIndex(Index As Long)
    mItemSelected = Index
    
    If Index >= mCount Then Call Err.Raise(1, , "El index no existe"): Exit Property
    
    ItemsVisible = (UserControl.ScaleHeight \ mItemHeight) - IIf(PicScroll(0).Visible, 1, 0)
    
    If mScrollPos + ItemsVisible < Index Or Index < mScrollPos Then
        If Index - 1 >= 0 Then
            mScrollPos = Index - 1
        Else
            mScrollPos = Index
        End If
    End If
    Me.Refresh
End Property

Public Property Get ScrollStyle() As EnuScrollingStyle
    ScrollStyle = mScrollStyle
End Property

Public Property Let ScrollStyle(ByVal NewStyle As EnuScrollingStyle)
    mScrollStyle = NewStyle
    If mScrollStyle = ScrollBar Then
        PicScroll(0).Visible = False
        PicScroll(1).Visible = False
    Else
        VScroll1.Visible = False
    End If
 
    PropertyChanged "ScrollStyle"
    Me.Refresh
End Property

Public Property Get IconAlign() As EnuIconAlign
    IconAlign = mIconAlign
End Property

Public Property Let IconAlign(ByVal NewAlign As EnuIconAlign)
    mIconAlign = NewAlign
    PropertyChanged "IconAlign"
    DrawItems
    CheckScroll
End Property

Public Property Get IconsSize() As Long
    IconsSize = mIconSize
End Property

Public Property Let IconsSize(ByVal NewSize As Long)
    mIconSize = NewSize
    If mIconSize < 1 Then mIconSize = 16
    PropertyChanged "IconsSize"
    If Ambient.UserMode Then
        InitImageList mIconSize
    End If
End Property

Public Property Get SelectionStyle() As EnuSelecionStyle
    SelectionStyle = mSelectionStyle
End Property

Public Property Let SelectionStyle(ByVal NewStyle As EnuSelecionStyle)
    mSelectionStyle = NewStyle
    PropertyChanged "SelectionStyle"
    Select Case NewStyle
        Case Windows_Vista
            Me.SelectionColor = VistaDefaultColor
        Case Office
            Me.SelectionColor = OfficeDefaultColor
        Case Windows_XP
            Me.SelectionColor = vbHighlight
        Case Ribbon
            Me.SelectionColor = RibbonDefaultColor
    End Select
    Me.Refresh
End Property

Public Sub Refresh()
    CheckScroll
    DrawItems
End Sub

Public Property Get hwnd() As Long
Attribute hwnd.VB_MemberFlags = "400"
    hwnd = UserControl.hwnd
End Property

Private Sub ProcessMessages()

    Dim Message As Msg
    bCancel = False
    InProcessMSG = True
    Do While bCancel = False
        If PeekMessage(Message, UserControl.hwnd, WM_MOUSEWHEEL, WM_MOUSEWHEEL, PM_REMOVE) Then
            If ItemsVisible < mCount Then
                If Message.wParam < 0 Then
                    mScrollPos = mScrollPos + 1
                Else
                    mScrollPos = mScrollPos - 1
                End If
                CheckScroll
                mItemHitText = GetHitTest
                DrawItems
            End If
        End If
        DoEvents
        Sleep 20
    Loop
    InProcessMSG = False
    
End Sub

Public Function GetHitTest() As Long

    Dim PT As POINTAPI
    Dim TopPos As Long
    Dim TextH As Long
    Dim AreaItem As Long
    
    TopPos = (mItemHeight * mScrollPos) - IIf(PicScroll(0).Visible, PicScroll(0).Height, 0)
    GetCursorPos PT
    
    If WindowFromPoint(PT.X, PT.Y) = UserControl.hwnd Then
        ScreenToClient UserControl.hwnd, PT
        AreaItem = (UserControl.ScaleWidth / 2) - (mSelectionWidth / 2)
        If PT.X > AreaItem And PT.X < AreaItem + mSelectionWidth Then
            GetHitTest = (PT.Y + TopPos) \ mItemHeight
        Else
            GetHitTest = -1
        End If
        If GetHitTest > mCount - 1 Then GetHitTest = -1
    Else
        GetHitTest = -1
    End If
    
End Function


Private Sub PicScroll_MouseMove(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)

    Dim PT As POINTAPI
    Dim ScrollVelociti As Long

    
    If Not IsIn Then
        IsIn = True
        
        DrawArrow Index, True
        Select Case mCount
            Case Is < 20
                ScrollVelociti = 500
            Case Is < 40
                ScrollVelociti = 250
            Case Is < 100
                ScrollVelociti = 100
            Case Else
                ScrollVelociti = 50
        End Select
        
        DoEvents
        Sleep 120
            
        GetCursorPos PT
    
        Do While WindowFromPoint(PT.X, PT.Y) = PicScroll(Index).hwnd
        
            DoEvents
            Sleep ScrollVelociti
            If ScrollVelociti > 1 Then ScrollVelociti = ScrollVelociti - 1
            
            If Index = 0 Then
                mScrollPos = mScrollPos - 1
            Else
                mScrollPos = mScrollPos + 1
            End If
                
            Me.Refresh
            GetCursorPos PT
            
        Loop
        
        DrawArrow Index
        IsIn = False
        
    End If
    
End Sub

Private Sub CheckScroll()
   
    Dim Max As Long
   
    Max = mCount - ItemsVisible
    If Max < 1 Then Max = 1
    
    If mScrollPos < 0 Then mScrollPos = 0
    If mScrollPos >= Max Then mScrollPos = Max

    
    If mScrollStyle = UpDownButton Then
        PicScroll(0).Visible = mScrollPos > 0
        PicScroll(1).Visible = mCount - mScrollPos > ItemsVisible
    Else
        If mScrollPos > 0 Or mCount - mScrollPos > ItemsVisible Then
            VScroll1.Visible = True
            VScroll1.Max = Max
            VScroll1.Value = mScrollPos
        Else
            VScroll1.Visible = False
        End If
    End If
    
End Sub

Private Sub Timer1_Timer()

    Dim HT As Long
    Dim PT As POINTAPI
    Dim hWin As Long
        
    GetCursorPos PT
    hWin = WindowFromPoint(PT.X, PT.Y)
      
    If hWin <> UserControl.hwnd Then
        mItemHitText = -1
        Timer1.Interval = 0
        DrawItems
    End If

End Sub

Private Sub UserControl_Click()
    RaiseEvent Click(GetHitTest)
    If InProcessMSG = False Then
        ProcessMessages
    End If
End Sub

Private Sub UserControl_DblClick()
    RaiseEvent DblClick
End Sub
    
Private Sub UserControl_EnterFocus()
    IsIn = False
    ProcessMessages
End Sub

Private Sub UserControl_ExitFocus()
    bCancel = True
End Sub

Private Sub UserControl_Initialize()
    mItemHitText = -1
    mItemSelected = -1
    ReDim Item(0)
End Sub

Private Function InitImageList(Size) As Boolean
    If himl Then ImageList_Destroy himl
    mIconSize = Size
    himl = ImageList_Create(mIconSize, mIconSize, ILC_COLOR32 Or ILC_MASK, 1, 1)
    InitImageList = himl <> 0
End Function

Public Sub Sorted(Order As EnuListOrder)
    Dim Itm As tItem
    Dim J As Long
    Dim i As Long

    If Order = AcendetOrder Then
        For J = 0 To mCount - 2
            For i = 0 To mCount - 2
                If Item(i).Caption > Item(i + 1).Caption Then
                    Itm = Item(i + 1)
                    Item(i + 1) = Item(i)
                    Item(i) = Itm
                End If
            Next i
        Next J
    Else
        For J = 0 To mCount - 2
            For i = 0 To mCount - 2
                If Item(i).Caption < Item(i + 1).Caption Then
                    Itm = Item(i + 1)
                    Item(i + 1) = Item(i)
                    Item(i) = Itm
                End If
            Next i
        Next J
    End If
    
    Me.Refresh
    
End Sub

Private Sub DrawItems()

    On Error GoTo ErrOut
    Dim LastItemVisible     As Long
    Dim i                   As Long
    Dim TextRect            As RECT
    Dim hBrush              As Long
    Dim TopPos              As Long
    Dim MaxTextWidth        As Long
    Dim TextW               As Long
    Dim xLeft               As Long
    Dim AreaWidth           As Long
    Dim OldForeColor        As OLE_COLOR
    
    
    
    If Extender.Visible = False Then Exit Sub
        
    'If mCount = 0 Then Exit Sub
    OldForeColor = COLOR_NONE
    TextH = UserControl.TextHeight("j")

    If mIconAlign = AlingLeft Then
        If TextH > mIconSize Then
            mItemHeight = TextH + 4
        Else
            mItemHeight = mIconSize + 8
        End If
    Else
        mItemHeight = mIconSize + 16 + TextH + 4
        MaxTextWidth = mItemHeight
    End If

    ItemsVisible = (UserControl.ScaleHeight \ mItemHeight) - IIf(PicScroll(0).Visible, 1, 0)
        
    TopPos = (mItemHeight * mScrollPos) - IIf(PicScroll(0).Visible, PicScroll(0).Height, 0)
    LastItemVisible = mScrollPos + (UserControl.ScaleHeight \ mItemHeight)
    If LastItemVisible > mCount - 1 Then LastItemVisible = mCount - 1
    AreaWidth = UserControl.ScaleWidth - IIf(VScroll1.Visible, VScroll1.Width, 0) - 1

    If mIconAlign = AlingLeft Then
        mSelectionWidth = AreaWidth - 1
        xLeft = 1
    Else
        For i = mScrollPos To LastItemVisible
            TextW = UserControl.TextWidth(Item(i).Caption)
            If TextW > MaxTextWidth - 16 Then
                MaxTextWidth = TextW + 16
            End If
        Next
        If MaxTextWidth > AreaWidth Then MaxTextWidth = AreaWidth
        xLeft = (UserControl.ScaleWidth / 2) - (MaxTextWidth / 2) + 0.5
        mSelectionWidth = MaxTextWidth
    End If
    
    UserControl.AutoRedraw = True
    UserControl.Cls
    
    For i = mScrollPos To LastItemVisible
               
        If i = mItemHitText And i = mItemSelected Then
            DrawSelection xLeft, (mItemHeight * i) - TopPos + 1, mSelectionWidth, mItemHeight, 150
        Else
            If i = mItemHitText Then
                DrawSelection xLeft, (mItemHeight * i) - TopPos + 1, mSelectionWidth, mItemHeight, 50
            End If
            If i = mItemSelected Then
                DrawSelection xLeft, (mItemHeight * i) - TopPos + 1, mSelectionWidth, mItemHeight, 100
            End If
        End If
        
        If Item(i).ForeColor <> COLOR_NONE Then
            OldForeColor = UserControl.ForeColor
            UserControl.ForeColor = Item(i).ForeColor
        End If
        
        If mIconAlign = AlingLeft Then
            ImageList_Draw himl, Item(i).IconIndex, UserControl.hDC, 4, (mItemHeight / 2) - (mIconSize / 2) + (mItemHeight * i) - TopPos, ILD_TRANSPARENT
            SetRect TextRect, mIconSize + 8, (mItemHeight * i) - TopPos, mSelectionWidth, (mItemHeight * (i + 1)) - TopPos
            DrawText UserControl.hDC, Item(i).Caption, Len(Item(i).Caption), TextRect, DT_FLAG
        Else
            ImageList_Draw himl, Item(i).IconIndex, UserControl.hDC, xLeft + (mSelectionWidth / 2) - (mIconSize / 2), (mItemHeight * i) + 8 - TopPos, ILD_TRANSPARENT
            SetRect TextRect, xLeft, (mItemHeight * i) - TopPos, xLeft + mSelectionWidth, (mItemHeight * (i + 1)) - TopPos - 8
            DrawText UserControl.hDC, Item(i).Caption, Len(Item(i).Caption), TextRect, DT_SINGLELINE Or DT_WORD_ELLIPSIS Or DT_CENTER Or DT_BOTTOM
        End If
        
        If OldForeColor <> COLOR_NONE Then
            UserControl.ForeColor = OldForeColor
            OldForeColor = COLOR_NONE
        End If
            
    Next
    UserControl.AutoRedraw = True
    UserControl.Line (0, 0)-(UserControl.ScaleWidth - 1, UserControl.ScaleHeight - 1), mBorderColor, B
    UserControl.AutoRedraw = False
    UserControl.Refresh
ErrOut:

End Sub

Private Sub DrawSelection(X As Long, Y As Long, W As Long, H As Long, Intenc As Long)

    Select Case mSelectionStyle
        Case Windows_Vista
            DrawVistaSelection UserControl.hDC, X, Y, W, H, vbWhite, pvAlphaBlend(mSelectionColor, Me.BackColor, Intenc)
        Case Office
            DrawOfficeSelection UserControl.hDC, X, Y, W, H, pvAlphaBlend(mSelectionColor, Me.BackColor, Intenc)
        Case Windows_XP
            Dim hBrush As Long
            Dim Rec As RECT
            SetRect Rec, X, Y, X + W, Y + H
            hBrush = CreateSolidBrush(pvAlphaBlend(mSelectionColor, Me.BackColor, Intenc))
            FillRect UserControl.hDC, Rec, hBrush
            If Intenc <> 50 Then DrawFocusRect UserControl.hDC, Rec
            DeleteObject hBrush
        Case Ribbon
            DrawRibbonSelection UserControl.hDC, X, Y, W, H, vbWhite, pvAlphaBlend(mSelectionColor, Me.BackColor, Intenc + 100)
    End Select

End Sub


Public Sub Clear()
    ReDim Item(0)
    mCount = 0
    mItemSelected = -1
    mItemHitText = -1
    mScrollPos = 0
    UserControl.AutoRedraw = True
    UserControl.Cls
    UserControl.AutoRedraw = False
    PicScroll(0).Visible = False
    PicScroll(1).Visible = False
    VScroll1.Visible = False
End Sub

Private Sub UserControl_InitProperties()
    mSelectionColor = &HE0D080
    mScrollStyle = UpDownButton
    mBorderColor = &HC8D0D4
    mIconSize = 16
End Sub

Private Sub UserControl_KeyDown(KeyCode As Integer, Shift As Integer)
   
    Dim StarPos             As Long
    Dim i                   As Long
    Dim sChar               As String
    Dim ItemIsSeleted       As Boolean

    
    If mCount = 0 Then
        RaiseEvent KeyDown(KeyCode, Shift)
        Exit Sub
    End If

    ItemsVisible = (UserControl.ScaleHeight \ mItemHeight) - IIf(PicScroll(0).Visible Or PicScroll(1).Visible, 1, 0)
    
    Select Case KeyCode
        Case vbKeyDown
            mItemSelected = mItemSelected + 1
            If mItemSelected >= mCount Then mItemSelected = mCount - 1
            ItemIsSeleted = True

        Case vbKeyUp
            mItemSelected = mItemSelected - 1
            If mItemSelected < 0 Then mItemSelected = 0
            ItemIsSeleted = True
    
        Case vbKeyEnd
            mScrollPos = mCount - ItemsVisible
            
        Case vbKeyHome
            mScrollPos = 0
            
        Case vbKeyPageDown
            mScrollPos = mScrollPos + ItemsVisible
            If mScrollPos > mCount - ItemsVisible Then mScrollPos = mCount - ItemsVisible
        
        Case vbKeyPageUp
            mScrollPos = mScrollPos - ItemsVisible
            If mScrollPos < 0 Then mScrollPos = 0
            
        Case Else

            StarPos = IIf(mItemSelected > -1, mItemSelected + 1, 0)
            
            For i = StarPos To mCount - 1
                If Item(i).Caption <> "" Then
                    sChar = Asc(UCase(Left(Item(i).Caption, 1)))
                    If sChar = KeyCode Then
                        mItemSelected = i
                        ItemIsSeleted = True
                        Exit For
                    End If
                End If
            Next
            
            If Not ItemIsSeleted Then
                For i = 0 To StarPos
                    If Item(i).Caption <> "" Then
                        sChar = Asc(UCase(Left(Item(i).Caption, 1)))
                        If sChar = KeyCode Then
                            mItemSelected = i
                            ItemIsSeleted = True
                            Exit For
                        End If
                    End If
                Next
            End If
    End Select
    
    If ItemIsSeleted Then
        If mScrollPos >= mItemSelected Then mScrollPos = mItemSelected   '- 1
        If mScrollPos + ItemsVisible < mItemSelected + 1 Then mScrollPos = mItemSelected - ItemsVisible + 1
    End If
    
    
    mItemHitText = GetHitTest
    Me.Refresh
    
    RaiseEvent KeyDown(KeyCode, Shift)
End Sub

Private Sub UserControl_KeyPress(KeyAscii As Integer)
    RaiseEvent KeyPress(KeyAscii)
End Sub

Private Sub UserControl_KeyUp(KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyUp(KeyCode, Shift)
End Sub

Private Sub UserControl_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim HT As Long
    If mCount = 0 Then Exit Sub
    HT = GetHitTest
    If HT <> -1 Then
        mItemSelected = HT
        DrawItems
    End If
    RaiseEvent MouseDown(Button, Shift, X, Y)
End Sub


Private Sub UserControl_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    Dim HT As Long
    Dim AreaText As Long
    
    If mCount > 0 Then
    
        HT = GetHitTest
        If HT <> -1 Then
            AreaText = UserControl.ScaleWidth - IIf(VScroll1.Visible, VScroll1.Width, 0) - 1 - IIf(mIconAlign = AlingLeft, mIconSize + 8, 0)
            If UserControl.TextWidth(Item(HT).Caption) > AreaText Then
                Extender.ToolTipText = Item(HT).Caption
            Else
                Extender.ToolTipText = ""
            End If
        Else
            Extender.ToolTipText = ""
        End If
        If HT <> mItemHitText Then
            mItemHitText = HT
            DrawItems
        End If
        
        Timer1.Interval = 50
        
    End If
    RaiseEvent MouseMove(Button, Shift, X, Y)
    
End Sub


Private Sub DrawRibbonSelection(DestDC As Long, destX As Long, destY As Long, destWidth As Long, destHeight As Long, oColorStar As Long, oColorEnd As Long)

    Dim DC As Long, hDCMemory As Long, hBmp As Long
    Dim hPen1 As Long, hPen2 As Long, hBrush As Long
    Dim DivValue    As Double
    Dim i           As Long
    Dim Alpha1      As Long
    Dim Alpha2      As Long

    hPen1 = CreatePen(0, 1, pvAlphaBlend(vbBlack, oColorEnd, 10))
    hPen2 = CreatePen(0, 1, pvAlphaBlend(oColorStar, vbWhite, 10))
 
    DC = GetDC(0)
    hDCMemory = CreateCompatibleDC(0)
    hBmp = CreateCompatibleBitmap(DC, 1, destHeight)
    Call SelectObject(hDCMemory, hBmp)
 
    Alpha1 = pvAlphaBlend(oColorEnd, oColorStar, 25)
    Alpha2 = pvAlphaBlend(oColorEnd, oColorStar, 155)

    For i = 2 To destHeight / 3
        DivValue = ((i * 255) / (destHeight / 3))
        
        SetPixelV hDCMemory, 0, i, pvAlphaBlend(Alpha2, Alpha1, DivValue)
    Next

    
    For i = destHeight / 3 To destHeight - 3
        DivValue = ((i * 255) / (destHeight - (destHeight / 3)))
        SetPixelV hDCMemory, 0, i, pvAlphaBlend(Alpha2, oColorEnd, DivValue)
    Next

    hBrush = CreatePatternBrush(hBmp)
    
    DeleteObject hBmp
    hBmp = CreateCompatibleBitmap(DC, destWidth, destHeight)
    Call SelectObject(hDCMemory, hBmp)
    Call SelectObject(hDCMemory, hPen1)

    RoundRect hDCMemory, 0, 0, destWidth, destHeight, 3, 3

    SelectObject hDCMemory, hPen2

    Call SelectObject(hDCMemory, hBrush)

    RoundRect hDCMemory, 1, 1, destWidth - 1, destHeight - 1, 3, 3
    
    SetPixelV hDCMemory, 0, 0, GetPixel(DestDC, destX, destY)
    SetPixelV hDCMemory, destWidth - 1, 0, GetPixel(DestDC, destX + destWidth, destY)
    SetPixelV hDCMemory, destWidth - 1, destHeight - 1, GetPixel(DestDC, destX + destWidth, destY + destHeight)
    SetPixelV hDCMemory, 0, destHeight - 1, GetPixel(DestDC, destX, destY + destHeight)
    SetPixelV hDCMemory, 1, 1, oColorEnd
    SetPixelV hDCMemory, destWidth - 2, 1, oColorEnd
    SetPixelV hDCMemory, destWidth - 2, destHeight - 2, oColorEnd
    SetPixelV hDCMemory, 1, destHeight - 2, oColorEnd
    
    BitBlt DestDC, destX, destY, destWidth, destHeight, hDCMemory, 0, 0, vbSrcCopy

    DeleteObject hPen1
    DeleteObject hPen2
    DeleteObject hBrush
    DeleteObject hBmp
    DeleteDC DC
    DeleteDC hDCMemory
    
End Sub


Private Sub DrawVistaSelection(DestDC As Long, destX As Long, destY As Long, destWidth As Long, destHeight As Long, oColorStar As Long, oColorEnd As Long)

    Dim DC As Long, hDCMemory As Long, hBmp As Long
    Dim hPen1 As Long, hPen2 As Long, hBrush As Long
    Dim DivValue    As Double
    Dim i           As Long
    Dim Alpha1      As Long
    
    hPen1 = CreatePen(0, 1, pvAlphaBlend(vbBlack, oColorEnd, 10))
    hPen2 = CreatePen(0, 1, pvAlphaBlend(oColorStar, vbWhite, 10))

    DC = GetDC(0)
    hDCMemory = CreateCompatibleDC(0)
    hBmp = CreateCompatibleBitmap(DC, 1, destHeight)
    Call SelectObject(hDCMemory, hBmp)
    
    Alpha1 = pvAlphaBlend(oColorEnd, oColorStar, 25)
    
    For i = 1 To destHeight
        DivValue = ((i * 255) / destHeight)
        SetPixelV hDCMemory, 0, i, pvAlphaBlend(oColorEnd, Alpha1, DivValue)
    Next

    hBrush = CreatePatternBrush(hBmp)
    
    DeleteObject hBmp
    hBmp = CreateCompatibleBitmap(DC, destWidth, destHeight)
    Call SelectObject(hDCMemory, hBmp)
 
    BitBlt hDCMemory, 0, 0, destWidth, destHeight, DestDC, destX, destY, vbSrcCopy

    Call SelectObject(hDCMemory, hPen1)
    
    RoundRect hDCMemory, 0, 0, destWidth, destHeight, 9, 9
    
    SelectObject hDCMemory, hPen2
    
    Call SelectObject(hDCMemory, hBrush)
    
    RoundRect hDCMemory, 1, 1, destWidth - 1, destHeight - 1, 8, 8
    
    BitBlt DestDC, destX, destY, destWidth, destHeight, hDCMemory, 0, 0, vbSrcCopy
    
    DeleteObject hPen1
    DeleteObject hPen2
    DeleteObject hBrush
    DeleteObject hBmp
    DeleteDC DC
    DeleteDC hDCMemory
    
End Sub


Private Sub DrawOfficeSelection(hDC As Long, ByVal X As Long, ByVal Y As Long, ByVal Width As Long, ByVal Height As Long, ByVal Color As OLE_COLOR)

    Dim hPen        As Long
    Dim hBrush      As Long
    Dim OldBrush    As Long
    Dim OldPen      As Long
    
    hPen = CreatePen(0, 1, Color)
    hBrush = CreateSolidBrush(pvAlphaBlend(Color, vbWhite, 100))
    
    OldBrush = SelectObject(hDC, hBrush)
    OldPen = SelectObject(hDC, hPen)
    
    Rectangle hDC, X, Y, X + Width, Y + Height
    
    Call SelectObject(hDC, OldPen)
    Call SelectObject(hDC, OldBrush)
    
    DeleteObject hPen
    DeleteObject hBrush
    
End Sub


'Funcin para trasladar un color a otro en porcentaje lAlpha(0 A 255)
Private Function pvAlphaBlend(ByVal clrFirst As Long, ByVal clrSecond As Long, ByVal lAlpha As Long) As Long

    Dim clrFore         As UcsRgbQuad
    Dim clrBack         As UcsRgbQuad
    
    OleTranslateColor clrFirst, 0, VarPtr(clrFore)
    OleTranslateColor clrSecond, 0, VarPtr(clrBack)
    With clrFore
        .R = (.R * lAlpha + clrBack.R * (255 - lAlpha)) / 255
        .G = (.G * lAlpha + clrBack.G * (255 - lAlpha)) / 255
        .B = (.B * lAlpha + clrBack.B * (255 - lAlpha)) / 255
    End With
    CopyMemory VarPtr(pvAlphaBlend), VarPtr(clrFore), 4
    
End Function


Private Sub UserControl_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseUp(Button, Shift, X, Y)
End Sub


Private Sub UserControl_Resize()
    VScroll1.Move UserControl.ScaleWidth - VScroll1.Width - 1, 1, VScroll1.Width, UserControl.ScaleHeight - 2
    PicScroll(0).Move 1, 1, UserControl.ScaleWidth - 2, PicScroll(0).Height
    PicScroll(1).Move 1, UserControl.ScaleHeight - PicScroll(1).ScaleHeight - 1, UserControl.ScaleWidth - 2, PicScroll(1).Height
    
    If Ambient.UserMode Then
        DrawArrow
        Me.Refresh
    Else
        UserControl.AutoRedraw = True
        UserControl.Cls
        UserControl.Line (0, 0)-(UserControl.ScaleWidth - 1, UserControl.ScaleHeight - 1), mBorderColor, B
        UserControl.AutoRedraw = False
    End If

End Sub


Private Sub UserControl_Show()
    If Ambient.UserMode Then
        DrawArrow
        DrawItems
        CheckScroll
    End If
End Sub

Private Sub DrawArrow(Optional ByVal Index As Long = -1, Optional Preced As Boolean)

    Dim i               As Integer
    Dim TextRect        As RECT
    Dim lStar           As Long
    Dim lEND            As Long
    
    If Index <> -1 Then
        lStar = Index
        lEND = Index
    Else
        lEND = 1
    End If
    
    For i = lStar To lEND
        PicScroll(i).AutoRedraw = True
        PicScroll(i).Cls
        GetClientRect PicScroll(i).hwnd, TextRect
        If Index <> -1 And Preced Then
            DrawVistaSelection PicScroll(i).hDC, 0, 0, PicScroll(i).ScaleWidth, PicScroll(i).Height, RGB(231, 231, 231), RGB(251, 251, 251)
        Else
            DrawVistaSelection PicScroll(i).hDC, 0, 0, PicScroll(i).ScaleWidth, PicScroll(i).Height, RGB(251, 251, 251), RGB(231, 231, 231)
        End If
        DrawText PicScroll(i).hDC, 5 + i, 1, TextRect, DT_FLAG Or DT_CENTER
        PicScroll(i).AutoRedraw = False
        PicScroll(i).Refresh
    Next
    
End Sub

Private Sub UserControl_Terminate()
    ImageList_Destroy himl
End Sub

Private Sub VScroll1_Change()
    mScrollPos = VScroll1.Value
    DrawItems
End Sub

Private Sub VScroll1_GotFocus()
    bCancel = True
End Sub

Private Sub VScroll1_Scroll()
    VScroll1_Change
End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    With PropBag
        UserControl.BackColor = .ReadProperty("BackColor", &H80000005)
        UserControl.Enabled = .ReadProperty("Enabled", True)
        Set UserControl.Font = .ReadProperty("Font", Ambient.Font)
        UserControl.ForeColor = .ReadProperty("ForeColor", &H80000008)
        mSelectionColor = .ReadProperty("SelectionColor", &HE0D080)
        mSelectionStyle = .ReadProperty("SelectionStyle", 0)
        mScrollStyle = .ReadProperty("ScrollStyle", 0)
        mBorderColor = .ReadProperty("BorderColor", &HC8D0D4)
        mIconSize = .ReadProperty("IconsSize", 16)
        mIconAlign = .ReadProperty("IconAlign", 0)
        PicScroll(0).BackColor = UserControl.BackColor
        PicScroll(1).BackColor = UserControl.BackColor
        InitImageList mIconSize
        UserControl.AutoRedraw = True
        UserControl.Cls
        UserControl.Line (0, 0)-(UserControl.ScaleWidth - 1, UserControl.ScaleHeight - 1), mBorderColor, B
        UserControl.AutoRedraw = False
        UserControl.Refresh
    End With
End Sub


Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    With PropBag
        .WriteProperty "BackColor", UserControl.BackColor, &H80000005
        .WriteProperty "Enabled", UserControl.Enabled, True
        .WriteProperty "Font", UserControl.Font, Ambient.Font
        .WriteProperty "ForeColor", UserControl.ForeColor, &H80000008
        .WriteProperty "SelectionColor", mSelectionColor, &HE0D080
        .WriteProperty "SelectionStyle", mSelectionStyle, 0
        .WriteProperty "ScrollStyle", mScrollStyle, 0
        .WriteProperty "BorderColor", mBorderColor, &HC8D0D4
        .WriteProperty "IconsSize", mIconSize, 16
        .WriteProperty "IconAlign", mIconAlign, 0
    End With
End Sub



