Attribute VB_Name = "MdlGlobal"
Option Explicit

' ---------------------------------------------------------------------------------
' Autor:        Leandro I. Ascierto
' Web:          www.leandroascierto.com.ar
' Fecha:        01 de Diciembre de 2009
' ---------------------------------------------------------------------------------

Private Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Private Declare Function RegSetValueExString Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal lpValue As String, ByVal cbData As Long) As Long
Private Declare Function RegDeleteKey& Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, ByVal lpSubKey As String)
Private Declare Function RegQueryValueExNULL Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, ByVal lpData As Long, lpcbData As Long) As Long
Private Declare Function RegQueryValueExString Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, ByVal lpData As String, lpcbData As Long) As Long
Private Declare Function RegDeleteValue& Lib "advapi32.dll" Alias "RegDeleteValueA" (ByVal hKey As Long, ByVal lpValueName As String)
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lpFileName As String) As Long
Private Declare Function Shell_NotifyIcon Lib "Shell32" Alias "Shell_NotifyIconA" (ByVal dwMessage As Long, pnid As NOTIFYICONDATA) As Boolean
Private Declare Function InternetGetConnectedState Lib "wininet.dll" (ByRef lpdwFlags As Long, ByVal dwReserved As Long) As Long
Private Declare Function PathFileExists Lib "shlwapi.dll" Alias "PathFileExistsA" (ByVal pszPath As String) As Long
Public Declare Function CreatePopupMenu Lib "user32" () As Long
Public Declare Function AppendMenu Lib "user32" Alias "AppendMenuA" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal wIDNewItem As Long, ByVal lpNewItem As Any) As Long
Public Declare Function DestroyMenu Lib "user32" (ByVal hMenu As Long) As Long
Public Declare Function TrackPopupMenuEx Lib "user32" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal X As Long, ByVal Y As Long, ByVal hwnd As Long, ByVal lptpm As Any) As Long
Public Declare Function CheckMenuRadioItem Lib "user32" (ByVal hMenu As Long, ByVal un1 As Long, ByVal un2 As Long, ByVal un3 As Long, ByVal un4 As Long) As Long
Public Declare Function SetMenuDefaultItem Lib "user32.dll" (ByVal hMenu As Long, ByVal uItem As Long, ByVal fByPos As Long) As Long
Public Declare Function GetCursorPos Lib "user32.dll" (ByRef lpPoint As POINTAPI) As Long
Public Declare Function SetMenuItemBitmaps Lib "user32.dll" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long, ByVal hBitmapUnchecked As Long, ByVal hBitmapChecked As Long) As Long
Public Declare Function SetCursor Lib "user32" (ByVal hCursor As Long) As Long
Public Declare Function LoadCursor Lib "user32" Alias "LoadCursorA" (ByVal hInstance As Long, ByVal lpCursorName As Long) As Long
Public Declare Function DestroyCursor Lib "user32" (ByVal hCursor As Long) As Long
Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public Declare Sub InitCommonControls Lib "comctl32.dll" ()

Public Const SW_SHOWNORMAL = 1

Public Const TPM_RETURNCMD      As Long = &H100&
Public Const MF_STRING          As Long = &H0&
Public Const MF_POPUP           As Long = &H10&
Public Const MF_SEPARATOR       As Long = &H800&
Public Const MF_BYPOSITION      As Long = &H400&
Public Const MF_CHECKED         As Long = &H8&
Public Const MF_BYCOMMAND       As Long = &H0&
Public Const MF_BITMAP          As Long = &H4&

Public Type POINTAPI
    X As Long
    Y As Long
End Type

Private Type NOTIFYICONDATA
   cbSize                       As Long
   hwnd                         As Long
   uId                          As Long
   uFlags                       As Long
   uCallbackMessage             As Long
   hIcon                        As Long
   szTip                        As String * 128
   dwState                      As Long
   dwStateMask                  As Long
   szInfo                       As String * 256
   uTimeout                     As Long
   szInfoTitle                  As String * 64
   dwInfoFlags                  As Long
End Type

Private Const NIM_ADD           As Long = &H0
Private Const NIF_MESSAGE       As Long = &H1
Private Const NIF_ICON          As Long = &H2
Private Const NIM_DELETE        As Long = &H2
Private Const NIF_TIP           As Long = &H4

Public Const WM_MOUSEMOVE       As Long = &H200
Public Const WM_LBUTTONDOWN     As Long = &H201
Public Const WM_LBUTTONUP       As Long = &H202
Public Const WM_LBUTTONDBLCLK   As Long = &H203
Public Const WM_RBUTTONDOWN     As Long = &H204
Public Const WM_RBUTTONUP       As Long = &H205
Public Const WM_RBUTTONDBLCLK   As Long = &H206

Private Const RAMA_RUN_WINDOWS  As String = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run"
Private Const HKEY_CLASSES_ROOT = &H80000000
Private Const HKEY_CURRENT_USER = &H80000001
Private Const HKEY_LOCAL_MACHINE = &H80000002
Private Const HKEY_USERS = &H80000003
Private Const REG_SZ As Long = 1
Private Const KEY_ALL_ACCESS = &H3F


Public Declare Sub SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long)
Public Const HWND_TOPMOST = -1
Public Const HWND_NOTOPMOST = -2
Public Const SWP_NOSIZE = &H1
Public Const SWP_NOMOVE = &H2
Public Const SWP_NOACTIVATE = &H10
Public Const SWP_SHOWWINDOW = &H40

Public Const CatTaringa         As String = ":-1:7:18:4:25:17:19:16:9:23:29:24:26:1:12:0:2:15:22:32:30:8:10:5:21:27:20:28:31:13:3:14"
Public Const CatPoringa         As String = ":-1:7:9:8:1:12:2:10:5:14:4:0:13:3"

Public m_IDMenuCategoria        As Long
Public m_IDCat                  As Long
Public m_Server                 As Byte
Public m_Transparencity         As Byte
Public m_OnTop                  As Boolean
Public m_TimeRefresh            As Long
Public m_CurrentPostID          As String
Public m_IconInSysTray          As Boolean
Public m_collapsed              As Boolean
Public m_Width                  As Long
Public m_Height                 As Long
Public h_IconHAND                   As Long
Dim nf_IconData                 As NOTIFYICONDATA


Public Sub AddIconToSysTray(hwnd As Long, hIcon As Long)
    With nf_IconData
        .cbSize = Len(nf_IconData)
        .hwnd = hwnd
        .uFlags = NIF_ICON Or NIF_MESSAGE Or NIF_TIP
        .uCallbackMessage = WM_MOUSEMOVE
        .hIcon = hIcon
        .szTip = App.EXEName & vbNullChar
    End With
    Shell_NotifyIcon NIM_ADD, nf_IconData
End Sub

Public Sub DeleteFile(Path As String)
On Local Error Resume Next
    If PathFileExists(Path) Then
        Kill Path
    End If
End Sub


Public Sub DeleteSysTrayIcon()
    Shell_NotifyIcon NIM_DELETE, nf_IconData
End Sub


Public Function IDCatFromIDMenu(ByVal IDMenu As Long) As Long
    Dim ArrCat As Long
    If m_Server = 0 Then
        IDCatFromIDMenu = Split(CatTaringa, ":")(IDMenu)
    Else
        IDCatFromIDMenu = Split(CatPoringa, ":")(IDMenu)
    End If
End Function


Public Function GetServer() As String
    If m_Server = 0 Then
        GetServer = "http://www.taringa.net"
    Else
        GetServer = "http://www.poringa.net"
    End If
End Function


Public Function SetAutoRun(Value As Boolean) As Boolean

    Dim Path          As String
    Dim Handle        As Long
 
    Path = App.Path & "\" & App.EXEName & ".exe"

    RegOpenKeyEx HKEY_CURRENT_USER, RAMA_RUN_WINDOWS, 0, KEY_ALL_ACCESS, Handle
    If Value Then
        SetAutoRun = RegSetValueExString(Handle, App.Title, 0&, REG_SZ, Path, Len(Path)) = 0
    Else
        SetAutoRun = RegDeleteValue(Handle, App.Title) = 0
    End If
    RegCloseKey Handle
    
End Function


Public Function IsAutoRun() As Boolean

    Dim Path          As String
    Dim Handle        As Long
    Dim Data          As String
    Dim cch           As Long
    
    Path = App.Path & "\" & App.EXEName & ".exe"
    
    RegOpenKeyEx HKEY_CURRENT_USER, RAMA_RUN_WINDOWS, 0, KEY_ALL_ACCESS, Handle
    RegQueryValueExNULL Handle, App.Title, 0&, 0&, 0&, cch
    
    If cch > 0 Then
        Data = String(cch - 1, 0)
        RegQueryValueExString Handle, App.Title, 0&, 0&, Data, cch
        IsAutoRun = Path = Data
    End If
    
    RegCloseKey Handle

End Function


Public Function ReadIni(Key As String, Default As Variant) As String
    Dim Buffer As String * 256
    ReadIni = Left$(Buffer, GetPrivateProfileString(App.EXEName, Key, Default, Buffer, Len(Buffer), App.Path & "\Conf.Ini"))
End Function


Public Function SaveIni(Key As String, Value As Variant) As String
    WritePrivateProfileString App.EXEName, Key, Value, App.Path & "\Conf.Ini"
End Function


Public Function IsOnline() As Boolean
   IsOnline = InternetGetConnectedState(0&, 0&)
End Function
