VERSION 5.00
Begin VB.UserControl cSlider 
   ClientHeight    =   525
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2265
   ScaleHeight     =   525
   ScaleWidth      =   2265
End
Attribute VB_Name = "cSlider"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' ======================================================================
' Class:    cSlider
' Filename: cSlider.Ctl
' Author:   SP McMahon
' Date:     14 July 1998
' ----------------------
' Algunas correcciones e implementacion de nuevas propiedades
' By        Leandro Ascierto
' Date:     30 Marzo 2009
' ======================================================================

Private Declare Function InitCommonControlsEx Lib "comctl32.dll" (iccex As tagInitCommonControlsEx) As Boolean
Private Declare Function CreateWindowEX Lib "user32" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hwndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Private Declare Function DestroyWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function SendMessageLong Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function ShowWindow Lib "user32" (ByVal hwnd As Long, ByVal nCmdShow As Long) As Long
Private Declare Function MoveWindow Lib "user32" (ByVal hwnd As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long

Private Type tagInitCommonControlsEx
    lngSize As Long
    lngICC As Long
End Type
 
Private Const TRACKBAR_CLASSA = "msctls_trackbar32"

Private Const ICC_BAR_CLASSES = &H20

'Window Style Mesage
Private Const WM_VSCROLL = &H115
Private Const WM_HSCROLL = &H114
Private Const WM_USER = &H400
 
'Show Window constants
Private Const SW_HIDE = 0
Private Const SW_SHOWNORMAL = 1
 
'Window Style constants
Private Const WS_VISIBLE = &H10000000
Private Const WS_CHILD = &H40000000

Private Const TBS_AUTOTICKS = &H1
Private Const TBS_VERT = &H2
Private Const TBS_HORZ = &H0
Private Const TBS_TOP = &H4
Private Const TBS_BOTTOM = &H0
Private Const TBS_LEFT = &H4
Private Const TBS_RIGHT = &H0
Private Const TBS_BOTH = &H8
Private Const TBS_NOTICKS = &H10
Private Const TBS_ENABLESELRANGE = &H20
Private Const TBS_FIXEDLENGTH = &H40
Private Const TBS_NOTHUMB = &H80
Private Const TBS_TOOLTIPS = &H100

'"TB_THUMPOSITION"
Private Const TBM_GETPOS = (WM_USER)
Private Const TBM_GETRANGEMIN = (WM_USER + 1)
Private Const TBM_GETRANGEMAX = (WM_USER + 2)
Private Const TBM_GETTIC = (WM_USER + 3)
Private Const TBM_SETTIC = (WM_USER + 4)
Private Const TBM_SETPOS = (WM_USER + 5)
Private Const TBM_SETRANGE = (WM_USER + 6)
Private Const TBM_SETRANGEMIN = (WM_USER + 7)
Private Const TBM_SETRANGEMAX = (WM_USER + 8)
Private Const TBM_CLEARTICS = (WM_USER + 9)
Private Const TBM_SETSEL = (WM_USER + 10)
Private Const TBM_SETSELSTART = (WM_USER + 11)
Private Const TBM_SETSELEND = (WM_USER + 12)
Private Const TBM_GETPTICS = (WM_USER + 14)
Private Const TBM_GETTICPOS = (WM_USER + 15)
Private Const TBM_GETNUMTICS = (WM_USER + 16)
Private Const TBM_GETSELSTART = (WM_USER + 17)
Private Const TBM_GETSELEND = (WM_USER + 18)
Private Const TBM_CLEARSEL = (WM_USER + 19)
Private Const TBM_SETTICFREQ = (WM_USER + 20)
Private Const TBM_SETPAGESIZE = (WM_USER + 21)
Private Const TBM_GETPAGESIZE = (WM_USER + 22)
Private Const TBM_SETLINESIZE = (WM_USER + 23)
Private Const TBM_GETLINESIZE = (WM_USER + 24)
Private Const TBM_GETTHUMBRECT = (WM_USER + 25)
Private Const TBM_GETCHANNELRECT = (WM_USER + 26)
Private Const TBM_SETTHUMBLENGTH = (WM_USER + 27)
Private Const TBM_GETTHUMBLENGTH = (WM_USER + 28)
Private Const TBM_SETTOOLTIPS = (WM_USER + 29)
Private Const TBM_GETTOOLTIPS = (WM_USER + 30)
Private Const TBM_SETTIPSIDE = (WM_USER + 31)

'// TrackBar Tip Side flags
Private Const TBTS_TOP = 0
Private Const TBTS_LEFT = 1
Private Const TBTS_BOTTOM = 2
Private Const TBTS_RIGHT = 3

Private Const TBM_SETBUDDY = (WM_USER + 32) ' // wparam = BOOL fLeft; (or right)
Private Const TBM_GETBUDDY = (WM_USER + 33) ' // wparam = BOOL fLeft; (or right)


Private Const TB_LINEUP = 0
Private Const TB_LINEDOWN = 1
Private Const TB_PAGEUP = 2
Private Const TB_PAGEDOWN = 3
Private Const TB_THUMBPOSITION = 4
Private Const TB_THUMBTRACK = 5
Private Const TB_TOP = 6
Private Const TB_BOTTOM = 7
Private Const TB_ENDTRACK = 8


'// custom draw item specs
Private Const TBCD_TICS = &H1
Private Const TBCD_THUMB = &H2
Private Const TBCD_CHANNEL = &H3


Public Enum ESliderOrientation
    eslHorizontal = TBS_HORZ
    eslVertical = TBS_VERT
End Enum

Implements iSubclass

Private m_eOrientation As ESliderOrientation
Private m_hWNd              As Long
Private m_bSubClass         As Boolean
Private m_lMin              As Long
Private m_lMax              As Long
Private m_lValue            As Long
Private m_TopLeft           As Boolean
Private m_StyleBoth         As Boolean
Private m_UseToolTips       As Boolean
Private m_BackColor         As OLE_COLOR
Private c_SubClass          As cSubclass
Attribute c_SubClass.VB_VarHelpID = -1

Public Event Scroll(ByVal lPos As Long)


Public Property Get Min() As Long
    Min = m_lMin
End Property


Public Property Let Min(ByVal lMin As Long)
    If (m_lMin <> lMin) Then
        m_lMin = lMin
        If (m_lMax < m_lMin) Then
            m_lMax = m_lMin + 1
        End If
        SetRange m_lMin, m_lMax
    End If
End Property

Public Property Get Max() As Long
    Max = m_lMax
End Property

Public Property Let Max(ByVal lMax As Long)
    If (m_lMax <> lMax) Then
        m_lMax = lMax
        If (m_lMin > m_lMax) Then
            m_lMin = m_lMax - 1
        End If
        SetRange m_lMin, m_lMax
    End If
End Property

Public Property Get Value() As Long
Attribute Value.VB_UserMemId = 0
Attribute Value.VB_MemberFlags = "200"
    If (m_hWNd <> 0) Then
        Value = SendMessageLong(m_hWNd, TBM_GETPOS, 0, 0)
    Else
        Value = m_lValue
    End If
End Property

Public Property Let Value(ByVal lValue As Long)
    If (m_lValue <> lValue) Then
        m_lValue = lValue
        If (m_hWNd <> 0) Then
            SendMessageLong m_hWNd, TBM_SETPOS, 1, lValue
        End If
    End If
End Property

Public Sub SetRange(ByVal lMin As Long, ByVal lMax As Long)
    SendMessageLong m_hWNd, TBM_SETRANGEMIN, True, lMin
    SendMessageLong m_hWNd, TBM_SETRANGEMAX, True, lMax
End Sub

Public Property Get Orientation() As ESliderOrientation
    Orientation = m_eOrientation
End Property

Public Property Let Orientation(ByVal eOrientation As ESliderOrientation)
    m_eOrientation = eOrientation
End Property

Public Property Get TopLeft() As Boolean
    TopLeft = m_TopLeft
End Property

Public Property Let TopLeft(ByVal NewValue As Boolean)
    m_TopLeft = NewValue
End Property

Public Property Get StyleBoth() As Boolean
    StyleBoth = m_StyleBoth
End Property

Public Property Let StyleBoth(ByVal NewValue As Boolean)
    m_StyleBoth = NewValue
End Property

Public Property Get UseToolTips() As Boolean
    UseToolTips = m_UseToolTips
End Property

Public Property Let UseToolTips(ByVal NewValue As Boolean)
    m_UseToolTips = NewValue
End Property

Private Sub pInitialise()

    Dim dwStyle As Long
    Dim iccex As tagInitCommonControlsEx

    With iccex
        .lngSize = LenB(iccex)
        .lngICC = ICC_BAR_CLASSES
    End With
    
    InitCommonControlsEx iccex

    dwStyle = WS_CHILD Or WS_VISIBLE Or TBTS_LEFT Or TBS_RIGHT
    
    If (m_eOrientation = eslHorizontal) Then
        dwStyle = dwStyle Or TBS_HORZ
    Else
        dwStyle = dwStyle Or TBS_VERT
    End If
    
    If m_StyleBoth Then
        dwStyle = dwStyle Or TBS_BOTH
    End If
    
    If m_TopLeft Then
        dwStyle = dwStyle Or TBS_TOP
    End If
    
    If m_UseToolTips Then
        dwStyle = dwStyle Or TBS_TOOLTIPS
    End If
    
    m_hWNd = CreateWindowEX(0, TRACKBAR_CLASSA, "", dwStyle, 0, 0, 0, 0, UserControl.hwnd, 0&, App.hInstance, 0&)
    If (m_hWNd <> 0) Then
        SendMessageLong m_hWNd, TBM_SETTICFREQ, 10, 0
        ' (Minimum range = low word, Maximum range = high word)
        SendMessageLong m_hWNd, TBM_SETRANGE, True, 100 * &H10000
                
        UserControl_Resize
        ShowWindow m_hWNd, SW_SHOWNORMAL
        
        If (UserControl.Ambient.UserMode) Then
            If c_SubClass.Subclass(UserControl.hwnd, Me) Then
                c_SubClass.AddMsg WM_HSCROLL, MSG_BEFORE
                c_SubClass.AddMsg WM_VSCROLL, MSG_BEFORE
                m_bSubClass = True
            End If
        End If
    End If
End Sub

Private Sub pTerminate()
    If (m_hWNd <> 0) Then
        ShowWindow m_hWNd, SW_HIDE
        DestroyWindow m_hWNd
    End If
End Sub

Private Sub UserControl_Initialize()
    m_lMin = 1
    m_lMax = 100
    Set c_SubClass = New cSubclass
End Sub

Private Sub UserControl_InitProperties()
    m_BackColor = vbButtonFace
    pInitialise
End Sub

Public Property Get BackColor() As OLE_COLOR
    BackColor = m_BackColor
End Property

Public Property Let BackColor(ByVal New_BackColor As OLE_COLOR)
    m_BackColor = New_BackColor
    UserControl.BackColor = New_BackColor
    PropertyChanged "BackColor"
End Property

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    Orientation = PropBag.ReadProperty("Orientation", TBS_HORZ)
    m_StyleBoth = PropBag.ReadProperty("StyleBoth", False)
    m_TopLeft = PropBag.ReadProperty("TopLeft", False)
    m_UseToolTips = PropBag.ReadProperty("UseToolTips", False)
    Me.BackColor = PropBag.ReadProperty("BackColor", vbButtonFace)
    
    pInitialise
    Min = PropBag.ReadProperty("Min", 1)
    Max = PropBag.ReadProperty("Max", 100)
    Value = PropBag.ReadProperty("Value", 1)
End Sub

Private Sub UserControl_Resize()
    If (m_hWNd <> 0) Then
        MoveWindow m_hWNd, 0, 0, UserControl.ScaleWidth \ Screen.TwipsPerPixelX, UserControl.ScaleHeight \ Screen.TwipsPerPixelY, 1
    End If
End Sub

Private Sub UserControl_Terminate()
    If (m_bSubClass) Then
        'c_SubClass.DelMsg WM_HSCROLL, MSG_BEFORE
        'c_SubClass.DelMsg WM_VSCROLL, MSG_BEFORE
        'c_SubClass.UnSubclass
    End If
    'Set c_SubClass = Nothing
    pTerminate
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    PropBag.WriteProperty "Orientation", Orientation, eslHorizontal
    PropBag.WriteProperty "Min", Min, 1
    PropBag.WriteProperty "Max", Max, 100
    PropBag.WriteProperty "Value", Value, 1
    PropBag.WriteProperty "Value", Value, 1
    PropBag.WriteProperty "StyleBoth", m_StyleBoth, False
    PropBag.WriteProperty "TopLeft", m_TopLeft, False
    PropBag.WriteProperty "UseToolTips", m_UseToolTips, False
    PropBag.WriteProperty "BackColor", m_BackColor, vbButtonFace
End Sub

'- ordinal #1
Private Sub iSubclass_Proc(ByVal bBefore As Boolean, bHandled As Boolean, lReturn As Long, hwnd As Long, uMsg As WinSubHook2.eMsg, wParam As Long, lParam As Long)



    RaiseEvent Scroll(Value)

End Sub

