VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsXML"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Enum xmlParserError
    [xmlExpected] = 42
    [xmlMismatchedTag]
End Enum

Public Enum xmlIdentType
    [xmlSpace] = 0
    [xmlTab]
End Enum

Private m_parent        As clsXML
Private m_look          As String * 1
Private m_pos           As Long
Private m_line          As Long
Private m_col           As Long
Private m_hasxml        As Boolean
Private m_xmlnode       As clsXML
Private m_filenum       As Integer
Private m_name          As String
Private m_child()       As clsXML
Private m_attrib()      As String
Private m_value()       As String
Private m_text          As String
'''''' PROPERTY ''''''''''''''''''''''''''''''''''''''''''
Public Property Get ParentNode() As clsXML
    Set ParentNode = m_parent
End Property

Public Property Let ParentNode(Node As clsXML)
    Set m_parent = Node
End Property

Public Property Get XMLNode() As clsXML
    Set XMLNode = m_xmlnode
End Property

Public Property Let XMLNode(Node As clsXML)
    Set m_xmlnode = Node
End Property
Public Property Let name(n As String)
    m_name = n
End Property
Public Property Get name() As String
    name = m_name
End Property

Public Property Let Text(T As String)
    m_text = T
End Property
Public Property Get Text() As String
    Text = m_text
End Property

Public Property Get AttribCount() As Long
    AttribCount = UBound(m_attrib)
End Property

Public Property Get ChildrenCount() As Long
    ChildrenCount = UBound(m_child)
End Property
'''''''''''''''''''''''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''


Public Sub Parse(FileName As String)
Call OpenFile(FileName)
Set m_parent = parseParentNode
Call CloseFile
End Sub

Public Sub Save(FileName As String, Optional PrettyPrint As Boolean = False, Optional IdentType As xmlIdentType = xmlTab)
    Call OpenFile(FileName)
    Call writeXML(PrettyPrint, IdentType)
    Call CloseFile
End Sub

'printing functions (used by Save)
Private Sub writeXML(pp As Boolean, it As xmlIdentType)
    Dim i   As Long
    
    If m_hasxml Then 'print <?xml ... ?>
        Call WriteString("<?xml")
        For i = 1 To m_xmlnode.AttribCount
            Call WriteString(" " & m_xmlnode.AttributeName(i) & "=" & _
              Chr$(34) & m_xmlnode.getAttribute(m_xmlnode.AttributeName(i)) _
              & Chr$(34))
        Next
        Call WriteString("?>" & IIf(pp, vbNewLine, vbNullString))
    End If
    
    Call printNode(m_parent, pp, 0, it)
End Sub

Private Sub printNode(Node As clsXML, pp As Boolean, ident As Long, it As xmlIdentType)
Dim i   As Long
Dim B   As String
Dim e   As String
    
    B = IIf(pp, String$(ident, IIf(it = xmlSpace, " ", vbTab)), vbNullString)
    e = IIf(pp, vbNewLine, vbNullString)
    
    Call WriteString(B & "<")
    Call WriteString(Node.name)
    
    If Node.AttribCount > 0 Then
        For i = 1 To Node.AttribCount
            Call WriteString(" " & Node.AttributeName(i) & "=")
            Call WriteString(Chr$(34) & _
                             Node.getAttribute(Node.AttributeName(i)) & _
                             Chr$(34))
        Next
    End If
    
    
    If Node.ChildrenCount > 0 Then
        Call WriteString(">" & e)
        For i = 1 To Node.ChildrenCount
            Call printNode(Node.enumChild(i), pp, _
                IIf(it = xmlSpace, ident + 4, ident + 1), it)
        Next
        
        Call WriteString(B & "</" & Node.name & ">" & e)
        
    Else
        If Node.Text = "" Then
            Call WriteString("/>" & e)
        Else
            Call WriteString(">" & Node.Text & "</" & Node.name & ">" & e)
        End If
    End If
    
End Sub

'parse functions (used by Parse)
Private Sub Abort(errType As xmlParserError, Optional info As String = "")
Dim Description As String
    
    Select Case errType
        Case xmlExpected
            Description = "Expected: " & info & " at line " & m_line & " [" & m_col & "]"
        
        Case xmlMismatchedTag
            Description = "Mismatched tag: '" & info & "' at line " & m_line & " [" & m_col - 2 & "]"
            
        Case Else 'never happens :)
            Description = "Unknown"
    End Select
    
    Call Err.Clear
    Call Err.Raise(errType, "XMLParser", Description)
End Sub

Private Sub getChar()
    m_look = ReadString
End Sub

Private Sub Match(What As String)
    If m_look = What Then
        Call getChar
    Else
        Call Abort(xmlExpected, What)
    End If
End Sub

Private Sub skipWhite()
    While InStr(1, " " & vbTab & vbCr & vbLf, m_look) > 0
        If m_look = vbCr Then
            m_line = m_line + 1
            m_col = 0
        End If
        Call getChar
    Wend
End Sub

Private Sub skipComment()
    If m_look = "<" Then
        If ReadString(3) = "!--" Then

            Do
                Call getChar

                If m_look = "-" Then
                    If ReadString(2) = "->" Then
                        Call getChar
                        Call skipWhite
                        Call skipComment
                        Exit Do
                    Else
                        Call SeekFile(m_pos - 1)
                    End If
                Else
                    If m_look = vbCr Then
                        m_line = m_line + 1
                        m_col = 0
                    End If
                End If
            Loop Until EOF(m_filenum)
        Else
            Call SeekFile(m_pos - 2)
        End If
    End If
    
    Call skipWhite
End Sub

Private Function isAlpha() As Boolean
isAlpha = InStr(1, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", UCase$(m_look)) > 0
End Function

Private Function isDigit() As Boolean
    isDigit = IsNumeric(m_look)
End Function

Private Function isValidName() As Boolean
    isValidName = isAlpha Or isDigit Or (InStr(1, "`!@#$^_-:", m_look) > 0)
End Function

Private Function getName() As String
    Dim n   As String
    
    n = vbNullString
    While isValidName() And Not EOF(m_filenum)
        n = n & m_look
        Call getChar
    Wend
    
    Call skipWhite
    
    getName = n
End Function

Private Function getValue(Terminator As String) As String
    Dim v   As String
    
    v = vbNullString
    While m_look <> Terminator And Not EOF(m_filenum)
        v = v & m_look
        Call getChar
    Wend
    
    Call skipWhite
    
    getValue = v
End Function

Private Function parseParentNode() As clsXML
    Dim name As String
    
    Call getChar
    Call skipWhite
    Call skipComment
    
    Call Match("<")
    
    m_hasxml = False
    If m_look = "?" Then '<?xml ... ?>
        Call Match("?")
        name = getName
        
        If LCase$(name) <> "xml" Then
            Call Abort(xmlExpected, "xml")
        End If
        
        m_hasxml = True
        
        Set m_xmlnode = New clsXML
        m_xmlnode.name = "xml"
        
        Call readAttributes(m_xmlnode)
        Call getChar
        Call skipWhite
        Call skipComment
        Call Match("<")
        Call SeekFile(m_pos - 2)
        Call getChar
    End If
    name = getName
    Set parseParentNode = parseNode(name)
End Function

Private Sub readAttributes(ByRef Node As clsXML)
Dim name    As String
Dim Value   As String

    While m_look <> "/" And m_look <> ">" And Not EOF(m_filenum)
        Call skipWhite
       
        name = getName
        
        Call Match("=")
        Call Match("""")
        Value = getValue("""")
        Call Node.setAttribute(name, Value)
        Call Match("""")

        Call skipWhite

        If m_hasxml And m_look = "?" Then
            Call Match("?")
        End If
    Wend
    
End Sub
'

Private Function parseNode(NodeName As String) As clsXML
    Dim ret     As clsXML
    Dim name    As String
    Dim Child   As clsXML
    Dim closed  As Boolean
    
    Set ret = New clsXML
    ret.name = NodeName
    closed = False
    
    Call skipWhite
    
    Call readAttributes(ret)
    
    If m_look = ">" Then
        Call Match(">")
        Call skipWhite
        Call skipComment
        
        If m_look = "<" Then
            
            Do
                Call Match("<")
                Call SeekFile(m_pos - 2)
                Call getChar
                Call skipWhite
                
                If m_look = "/" Then
                    Call Match("/")
                    name = getName
                        
                    If LCase$(name) = LCase$(NodeName) Then
                        Call Match(">")
                        closed = True
                        Exit Do
                    Else
                        Call Abort(xmlMismatchedTag, NodeName)
                    End If
                End If
                
                name = getName
                Set Child = parseNode(name)
                
                Call ret.addChild(Child)

                Call skipWhite
                Call skipComment
                
            Loop Until EOF(m_filenum)
            
        Else
            ret.Text = getValue("<")
        End If
        
        If Not closed Then
            Call Match("<")
            Call Match("/")
            
            name = getName
            
            If LCase$(name) = LCase$(NodeName) Then
                Call Match(">")
            Else
                Call Abort(xmlMismatchedTag, NodeName)
            End If
        End If
    Else
        Call Match("/")
        Call Match(">")
    End If
    
    Call skipWhite
    
    Set parseNode = ret
    
End Function

'file I/O functions (used by print and parse functions)
Private Sub OpenFile(FileName As String)
    m_filenum = FreeFile()
    m_pos = 0
    m_line = 1
    m_col = 0
    Open FileName For Binary As #m_filenum
End Sub

Private Sub CloseFile()
    Close #m_filenum
End Sub

Private Sub SeekFile(Pos As Long)
    m_pos = Pos
    Seek #m_filenum, m_pos
End Sub

Private Function ReadString(Optional Length As Long = 1) As String
    Dim sBuff   As String
    sBuff = Space(Length)
    Get #m_filenum, , sBuff
    ReadString = RTrim$(sBuff)
    m_pos = m_pos + Length
    m_col = m_col + Length
End Function

Private Sub WriteString(str As String)
    Put #m_filenum, , str
End Sub

Private Sub Class_Initialize()
    ReDim m_attrib(0)
    ReDim m_value(0)
    ReDim m_child(0)
End Sub



Public Function getAttribute(attribName As String, Optional Default As String = vbNullString) As String
    Dim i As Long
    
    i = attribLookup(attribName)
    
    If (i > 0) Then
        getAttribute = m_value(i)
    Else
        getAttribute = Default
    End If
End Function

Public Sub setAttribute(attribName As String, Value As String)
    On Error Resume Next
    
    Dim i   As Long
    
    i = attribLookup(attribName)
    
    If (i > 0) Then
        m_value(i) = Value
    Else
        i = UBound(m_attrib) + 1
        
        ReDim Preserve m_attrib(i)
        ReDim Preserve m_value(i)
        
        m_attrib(i) = attribName
        m_value(i) = Value
        
    End If
    
End Sub


'
Public Sub addChild(Child As clsXML)
    On Error Resume Next
    
    Dim i   As Long
    
    i = UBound(m_child) + 1
    
    ReDim Preserve m_child(i)
    
    Set m_child(i) = Child
    'Debug.Print "Added Node '" & Child.Name & "' into '" & m_name & "'"
End Sub

Public Function enumChild(ByVal Index As Long) As clsXML
    Set enumChild = m_child(Index)
End Function

Public Function AttributeName(Index As Long) As String
    AttributeName = m_attrib(Index)
End Function

Private Function attribLookup(attribName As String) As Long
    On Error GoTo notFound
    
    Dim i   As Long
    
    For i = 1 To UBound(m_attrib)
        If (LCase$(m_attrib(i)) = LCase$(attribName)) Then
            attribLookup = i
            Exit Function
        End If
    Next
    
notFound:
    Call Err.Clear
    attribLookup = 0
End Function

Private Sub Class_Terminate()
    Set m_parent = Nothing
    Set m_xmlnode = Nothing

End Sub
