VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MsComCtl.ocx"
Begin VB.Form Form1 
   Caption         =   "Cliente"
   ClientHeight    =   2070
   ClientLeft      =   18135
   ClientTop       =   1935
   ClientWidth     =   7590
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   2070
   ScaleWidth      =   7590
   StartUpPosition =   3  'Windows Default
   Begin MSComctlLib.ProgressBar ProgressBar1 
      Height          =   375
      Left            =   240
      TabIndex        =   6
      Top             =   1440
      Width           =   6015
      _ExtentX        =   10610
      _ExtentY        =   661
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.CommandButton CmdBuscar 
      Caption         =   "Buscar"
      Enabled         =   0   'False
      Height          =   375
      Left            =   5160
      TabIndex        =   5
      Top             =   840
      Width           =   1095
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   4800
      Top             =   120
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton CmdCancelar 
      Caption         =   "Cancelar"
      Enabled         =   0   'False
      Height          =   375
      Left            =   6360
      TabIndex        =   4
      Top             =   1440
      Width           =   1095
   End
   Begin VB.TextBox TxtArchivo 
      Height          =   375
      Left            =   240
      TabIndex        =   3
      Top             =   840
      Width           =   4815
   End
   Begin VB.CommandButton CmdEnviar 
      Caption         =   "Enviar"
      Enabled         =   0   'False
      Height          =   375
      Left            =   6360
      TabIndex        =   2
      Top             =   840
      Width           =   1095
   End
   Begin VB.TextBox TxtIP 
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Text            =   "TxtIP"
      Top             =   240
      Width           =   2175
   End
   Begin VB.CommandButton CmdConectar 
      Caption         =   "Conectar"
      Height          =   375
      Left            =   2520
      TabIndex        =   0
      Top             =   240
      Width           =   1095
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' ----------------------------------------------------
' Autor: Leandro Ascierto
' Web: www.leandroascierto.com.ar
' Fecha: 09/07/2009
' Ejemplo para utilizar el mdulo WinSock32 - Transferencia de Archivos
' ----------------------------------------------------

Private Const DELIMITADOR               As String = "|"             'Este es un delimitador que utilizaremos para dividir los datos.
Private Const MSG_ARCHIVO               As String = "FILE"          'Mensaje que enva el Cliente para indicar que va a enviar un archivo.
Private Const MSG_TRANSFERIR            As String = "OK"            'Mensaje que responde el Servidor al Cliente para decirle que envie el archivo.
Private Const MSG_CANCELAR              As String = "CANCEL"        'Comando que enva el Servidor al Cliente para indicarle que cancel la transferencia.
Private Const PUERTO                    As Integer = 1000           'Puerto en el que escucha el Servidor.

Private NombreArchivo                   As String
Private TamaoArchivo                   As Long
Private RutaArchivo                     As String
Private bCancelarTransferencia          As Boolean

Private Sub Form_Load()
    WinSock32.InitWinSock Me                                        'El parmetro 'Me' se refiere a este formulario que es donde llegarn los eventos.
    TxtIP = GetLocalIp                                              'Devuelve la IP local.
    TamaoArchivo = -1
End Sub

Private Sub Form_Unload(Cancel As Integer)
    WinSock32.TerminateWinSock                                      'Importante!!!
End Sub

Private Sub CmdConectar_Click()
    If WinSock32.WsConnect(TxtIP, PUERTO) Then
        Me.Caption = "Cliente - Conectado con " & TxtIP & " en el puerto " & PUERTO
        Beep
        CmdConectar.Enabled = False
        CmdBuscar.Enabled = True
    Else
        MsgBox "Error al conectar."
    End If
End Sub

Private Sub CmdBuscar_Click()
    On Error GoTo ErrOut
    CommonDialog1.CancelError = True
    CommonDialog1.ShowOpen
    TxtArchivo = CommonDialog1.FileName
    CmdEnviar.Enabled = True
    Exit Sub
ErrOut:
End Sub

Private Sub CmdEnviar_Click()
    Dim Cadena As String
    
    CmdEnviar.Enabled = False
    
    RutaArchivo = TxtArchivo
    
    NombreArchivo = Right(RutaArchivo, Len(RutaArchivo) - InStrRev(RutaArchivo, "\"))
    
    TamaoArchivo = FileLen(RutaArchivo)
    
    Cadena = MSG_ARCHIVO & DELIMITADOR & NombreArchivo & DELIMITADOR & TamaoArchivo   'FILE|Foto1.bmp|1256

    Call WinSock32.SendData(CurrentSocketHandle, Cadena)
    
End Sub

Private Sub CmdCancelar_Click()
    CmdCancelar.Enabled = False
    bCancelarTransferencia = True
End Sub

Public Sub Socket_DataArrival(ID As Long, IP As String, PUERTO As String, Data As String)

    If Data = MSG_CANCELAR Then
        bCancelarTransferencia = True
    End If


    If Data = MSG_TRANSFERIR Then                               'Mensaje que enva el Server para que se comience con la transferencia.
        Dim ArrArchivo() As Byte
        Dim CantidadTrozos As Long
        Dim Resto As Long
        Dim Pos As Long
        Dim i As Long
        
        '*------------------------------------------------------------------------------------------*
        'Es importante no enviar el archivo entero, hay que partirlo en trozos de aproximadamente 1Kb
        '*------------------------------------------------------------------------------------------*
        
        ReDim ArrArchivo(1 To 1024)                             '1Kb = 1024 bits.
        CantidadTrozos = TamaoArchivo \ 1024                   'Usar la barra invertida '\' para dividir, hace que el resultado sea un entero.
        Resto = TamaoArchivo - CantidadTrozos * 1024           'Resto siempre va a ser un valor menor a 1Kb.
        ProgressBar1.Max = TamaoArchivo
        bCancelarTransferencia = False
        CmdCancelar.Enabled = True
        Open RutaArchivo For Binary As #1                       'Abrimos el archivo para la lectura
        
        For i = 1 To CantidadTrozos                             'Hacemos un bucle para ir enviando fragmentos del archivo de 1Kb.

            If bCancelarTransferencia Then                      'Si se cancela la transferencia, cerramos todo y salimos.
                Close #1
                WinSock32.WsClose ID
                ProgressBar1.Value = 0
                CmdConectar.Enabled = True
                Exit Sub
            Else
                Get #1, , ArrArchivo                            'Leemos parte del archivo
                If WinSock32.SendData(ID, ArrArchivo) Then      'Si el paquete es envia correctamente entonces
                    Pos = Pos + 1024
                    ProgressBar1.Value = Pos                    'Mostramos el progreso.
                Else
                    MsgBox "Hubo un error al transferir el archivo.", vbCritical
                    Close #1
                    WinSock32.WsClose ID
                    ProgressBar1.Value = 0
                    CmdConectar.Enabled = True
                    Exit Sub
                End If
            End If
            
        Next
        
        If Resto > 0 Then
            ReDim ArrArchivo(1 To Resto)
            Get #1, , ArrArchivo                                'Leemos el resto del archivo
            If WinSock32.SendData(ID, ArrArchivo) Then          'Si el paquete es envia correctamente entonces
                ProgressBar1.Value = TamaoArchivo
            Else
                MsgBox "Hubo un error al transferir el archivo.", vbCritical
                Close #1
                WinSock32.WsClose ID
                ProgressBar1.Value = 0
                CmdConectar.Enabled = True
                Exit Sub
            End If
        End If
        
        Close #1
        CmdEnviar.Enabled = True
        CmdCancelar.Enabled = False
        MsgBox "Transferencia completa"
        ProgressBar1.Value = 0
        TamaoArchivo = -1

    End If
    
End Sub

Public Sub Socket_Close(ID As Long, IP As String, PUERTO As String)
    
    If TamaoArchivo <> -1 Then                                     'Si el TamaoArchivo es <> -1, entonces significa que la conexin se cort mientras se transfera el archivo.
        bCancelarTransferencia = True
        MsgBox "La conexin se cort mientras se transfera el archivo"
    End If
    
    Me.Caption = "Cliente - Desconectado"
    CmdEnviar.Enabled = False
    CmdCancelar.Enabled = False
    CmdBuscar.Enabled = False
    CmdConectar.Enabled = True
End Sub

Public Sub Socket_Conect(ID As Long, IP As String, PUERTO As String)
'
End Sub

