VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MsComCtl.ocx"
Begin VB.Form Form1 
   Caption         =   "Servidor"
   ClientHeight    =   855
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   6225
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   855
   ScaleWidth      =   6225
   StartUpPosition =   3  'Windows Default
   Begin MSComctlLib.ProgressBar ProgressBar1 
      Height          =   375
      Left            =   120
      TabIndex        =   1
      Top             =   240
      Width           =   4935
      _ExtentX        =   8705
      _ExtentY        =   661
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.CommandButton CmdCancelar 
      Caption         =   "Cancelar"
      Enabled         =   0   'False
      Height          =   375
      Left            =   5160
      TabIndex        =   0
      Top             =   240
      Width           =   975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' ----------------------------------------------------
' Autor: Leandro Ascierto
' Web: www.leandroascierto.com.ar
' Fecha: 09/07/2009
' Ejemplo para utilizar el mdulo WinSock32 - Transferencia de Archivos
' ----------------------------------------------------

Private Const DELIMITADOR               As String = "|"             'Este es un delimitador que utilizaremos para dividir los datos.
Private Const MSG_ARCHIVO               As String = "FILE"          'Mensaje que enva el Cliente para indicar que va a enviar un archivo.
Private Const MSG_TRANSFERIR            As String = "OK"            'Mensaje que responde el Servidor al Cliente para decirle que envie el archivo.
Private Const MSG_CANCELAR              As String = "CANCEL"        'Comando que enva el Servidor al Cliente para indicarle que cancel la transferencia.
Private Const PUERTO                    As Integer = 1000           'Puerto que asignamos por defecto.

Private NombreArchivo                   As String
Private DestionArchivo                  As String
Private TamaoArchivo                   As Long
Private LenBuff                         As Long
Private bYaHayUnaConexion               As Boolean

Private Sub CmdCancelar_Click()
    On Error Resume Next
    TamaoArchivo = -1
    CmdCancelar.Enabled = False
    Call WinSock32.SendData(CurrentSocketHandle, MSG_CANCELAR)
    Close #1
    Kill DestionArchivo
End Sub

Private Sub Form_Load()
    InitWinSock Me                                                  'El parmetro 'Me' se refiere a este formulario que es donde llegarn los eventos.
    If WinSock32.WsListenInPort(PUERTO) Then
        TamaoArchivo = -1
        Me.Caption = "Servidor, escuchando en el puerto " & PUERTO
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Close #1
    TerminateWinSock                                                'Importante!!!
End Sub


Public Sub Socket_DataArrival(ID As Long, IP As String, PUERTO As String, Data As String)

    If TamaoArchivo = -1 Then                                      'Si TamaoArchivo = -1 significa que aun no se especifico ningun archivo
        Dim Datos() As String
            
        Datos = Split(Data, DELIMITADOR)                            'Partimos los datos.

        If UBound(Datos) = 2 Then                                   'Si los datos son tres, entonces...
            If Datos(0) = MSG_ARCHIVO Then                          'Si el primer dato es el comando de que se va a recibir un archivo entonces...
                NombreArchivo = Datos(1)                            'El segundo dato es el nombre del archivo
                TamaoArchivo = Datos(2)                            'El tercer dato es el tamao del archivo
                DestionArchivo = "C:\" & NombreArchivo              'La carpeta de descarga por defecto es el disco C:\
                ProgressBar1.Max = TamaoArchivo                    'Esto no sera muy conveniente, lo recomendado sera poner la cantidad de trozos a enviar
                ProgressBar1.Value = 0
                LenBuff = 0
                If MsgBox("Desea recibir un archivo llamado " & NombreArchivo & " con un tamao de " & TamaoArchivo & " bits?", vbYesNo) = vbYes Then
                    CmdCancelar.Enabled = True
                    Close #1
                    If Dir(DestionArchivo, vbArchive Or vbHidden Or vbNormal Or vbSystem) <> "" Then Kill DestionArchivo  'si el archivo ya existe lo eliminamos
                    Open DestionArchivo For Binary As #1            'Abrimos el archivo para comenzar a escribirlo
                    Call WinSock32.SendData(ID, MSG_TRANSFERIR)     'Enviamos un mensaje al cliente que ya puede comenzar a enviar el archivo.
                End If
            End If
        End If
    Else
        Put #1, , Data                                              'Vamos escribiendo el archivo.
        LenBuff = LenBuff + Len(Data)                               'Vamos contando los bits arrivados.

        ProgressBar1.Value = LenBuff                                'Mostramos el progreso.

        If LenBuff >= TamaoArchivo Then                            'Si los bits arrivados coinciden con los de TamaoArchivo significa que la transferencia finaliz.
            Close #1
            TamaoArchivo = -1                                      'Cerramos el archivo y reseteamos todo a 0.
            CmdCancelar.Enabled = False
            MsgBox "Transferencia finalizada, el archivo se ha guardado en " & DestionArchivo
            ProgressBar1.Value = 0
        End If
    End If

End Sub

Public Sub Socket_Conect(ID As Long, IP As String, PUERTO As String)
    If bYaHayUnaConexion Then                                       'Esto es para asegurarnos de que slo se pueda realizar una conexin.
        WinSock32.WsClose ID
    Else
        Me.Caption = "Servidor - Conectado con " & IP & " en el Puerto " & PUERTO
        bYaHayUnaConexion = True
    End If
End Sub

Public Sub Socket_Close(ID As Long, IP As String, PUERTO As String)
    If TamaoArchivo <> -1 Then                                     'Esto significa que la transferencia est en progreso y se cort la conexin.
        MsgBox "Se cort la Conexin, transferencia fallida"
        Close #1
        Kill DestionArchivo
        ProgressBar1.Value = 0
        TamaoArchivo = -1
    End If
    Me.Caption = "En escucha en el puerto " & PUERTO
    bYaHayUnaConexion = False
End Sub
