VERSION 5.00
Begin VB.UserControl ucPalette 
   BackStyle       =   0  'Transparent
   ClientHeight    =   4365
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   5265
   ClipBehavior    =   0  'None
   BeginProperty Font 
      Name            =   "Segoe UI"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ScaleHeight     =   291
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   351
   ToolboxBitmap   =   "ucPalette.ctx":0000
   Windowless      =   -1  'True
   Begin VB.Timer Timer1 
      Left            =   240
      Top             =   240
   End
End
Attribute VB_Name = "ucPalette"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Declare Function GdipCreateFromHDC Lib "GdiPlus.dll" (ByVal mhDC As Long, ByRef mGraphics As Long) As Long
Private Declare Function GdipSetInterpolationMode Lib "gdiplus" (ByVal graphics As Long, ByVal InterpolationMode As Long) As Long
Private Declare Function GdipGetImageDimension Lib "gdiplus" (ByVal Image As Long, ByRef Width As Single, ByRef Height As Single) As Long
Private Declare Function GdipDeleteGraphics Lib "GdiPlus.dll" (ByVal mGraphics As Long) As Long
Private Declare Function GdipDisposeImage Lib "gdiplus" (ByVal Image As Long) As Long
Private Declare Function GdipDrawImageRect Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mImage As Long, ByVal mX As Single, ByVal mY As Single, ByVal mWidth As Single, ByVal mHeight As Single) As Long
Private Declare Function GdipLoadImageFromStream Lib "gdiplus" (ByVal Stream As Any, ByRef Image As Long) As Long
Private Declare Function GdiplusStartup Lib "gdiplus" (Token As Long, inputbuf As GdiplusStartupInput, Optional ByVal outputbuf As Long = 0) As Long
Private Declare Sub GdiplusShutdown Lib "gdiplus" (ByVal Token As Long)
Private Declare Function GdipBitmapGetPixel Lib "GdiPlus.dll" (ByVal mBitmap As Long, ByVal mX As Long, ByVal mY As Long, ByRef ARGB As COLORBYTES) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal length As Long)
Private Declare Sub CreateStreamOnHGlobal Lib "ole32.dll" (ByRef hGlobal As Any, ByVal fDeleteOnRelease As Long, ByRef ppstm As Any)
Private Declare Sub RtlMoveMemory Lib "kernel32" (ByVal Destination As Long, ByVal Source As Long, ByVal length As Long)
Private Declare Function VirtualAlloc Lib "kernel32" (ByVal lpAddress As Long, ByVal dwSize As Long, ByVal flAllocationType As Long, ByVal flProtect As Long) As Long
Private Declare Function VirtualFree Lib "kernel32" (ByVal lpAddress As Long, ByVal dwSize As Long, ByVal dwFreeType As Long) As Long
Private Declare Function GetModuleHandleA Lib "kernel32" (ByVal lpModuleName As String) As Long
Private Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long
Private Declare Function LoadLibrary Lib "kernel32.dll" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Private Declare Function SetWindowLong Lib "user32.dll" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function GetParent Lib "user32.dll" (ByVal hwnd As Long) As Long
Private Declare Function GetWindow Lib "user32.dll" (ByVal hwnd As Long, ByVal wCmd As Long) As Long
Private Declare Function FindWindowEx Lib "user32.dll" Alias "FindWindowExA" (ByVal hWnd1 As Long, ByVal hWnd2 As Long, ByVal lpsz1 As String, ByVal lpsz2 As String) As Long
Private Declare Function VarPtrArray Lib "msvbvm60.dll" Alias "VarPtr" (ptr() As Any) As Long
Private Declare Function CreateWindowExA Lib "user32.dll" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByRef lpParam As Any) As Long
Private Declare Function GetCursorPos Lib "user32.dll" (ByRef lpPoint As POINTAPI) As Long
Private Declare Function ClientToScreen Lib "user32.dll" (ByVal hwnd As Long, ByRef lpPoint As POINTAPI) As Long
Private Declare Function SetRect Lib "user32.dll" (ByRef lpRect As RECT, ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Function WindowFromPoint Lib "user32.dll" (ByVal xPoint As Long, ByVal yPoint As Long) As Long
Private Declare Function PtInRect Lib "user32.dll" (ByRef lpRect As RECT, ByVal X As Long, ByVal Y As Long) As Long
Private Declare Function GdipFillPolygon2I Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mBrush As Long, ByRef mPoints As POINTL, ByVal mCount As Long) As Long
Private Declare Function GdipCreatePen1 Lib "GdiPlus.dll" (ByVal mColor As Long, ByVal mWidth As Single, ByVal mUnit As Long, ByRef mPen As Long) As Long
Private Declare Function GdipDeletePen Lib "GdiPlus.dll" (ByVal mPen As Long) As Long
Private Declare Function GdipDrawPolygonI Lib "GdiPlus.dll" (ByVal mGraphics As Long, ByVal mPen As Long, ByRef mPoints As POINTL, ByVal mCount As Long) As Long

Private Type COLORBYTES
    BlueByte As Byte
    GreenByte As Byte
    RedByte As Byte
    AlphaByte As Byte
End Type


Private Type RECT
    Left       As Long
    Top        As Long
    Right      As Long
    Bottom     As Long
End Type

Private Type POINTAPI
    X                       As Long
    Y                       As Long
End Type

Private Type POINTL
    X As Long
    Y As Long
End Type

Private Type GdiplusStartupInput
    GDIplusVersion           As Long
    DebugEventCallback       As Long
    SuppressBackgroundThread As Long
    SuppressExternalCodecs   As Long
End Type
  
Private Const GWL_WNDPROC       As Long = -4
Private Const GW_OWNER          As Long = 4
Private Const WS_CHILD          As Long = &H40000000

Public Event MouseExit()
Public Event ColorSelect(oColor As OLE_COLOR)
Public Event MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single, oColor As Long)

Private ImgWidth            As Single
Private ImgHeight           As Single
Private hImage              As Long
Private hParentWnd          As Long
Private c_tPT               As POINTAPI
Private m_X As Long
Private m_Y As Long
Private Const PS As Long = 3


Public Function SetImagePaletteFromStream(ByRef bvStream() As Byte) As Boolean
    
    If hImage <> 0 Then GdipDisposeImage hImage: hImage = 0
   
    If LoadImageFromStream(bvStream, hImage) Then
        GdipGetImageDimension hImage, ImgWidth, ImgHeight
        SetImagePaletteFromStream = True
    End If
    
    UserControl.Refresh
End Function

Public Function LoadImagePaletteFromFile(ByRef sFileName As String) As Boolean
    On Error Resume Next
    Dim FF As Integer, ReadFile() As Byte
    FF = FreeFile
    Open sFileName For Binary As #FF
        ReDim ReadFile(LOF(FF) - 1)
        Get #FF, , ReadFile
    Close #FF
    If Err.Number = 0 Then
        LoadImagePaletteFromFile = SetImagePaletteFromStream(ReadFile)
    End If
End Function

Private Sub Draw()
    Dim hGraphics As Long
    Dim i As Long, j As Long, n As Long
    Dim W As Long, H As Long, X As Long, Y As Long
    Dim PT(3) As POINTL
    Dim hPen As Long
    
    If Ambient.UserMode = 0 Then
        W = UserControl.ScaleWidth / 4
        H = UserControl.ScaleHeight / 4
        For i = 0 To 3
            For j = 0 To 3
                X = i * W
                Y = j * H
                UserControl.Line (X, Y)-(X + W, Y + H), QBColor(n), BF
                n = n + 1
            Next
        Next
    Else
    
        If hImage = 0 Then Exit Sub
    
        If GdipCreateFromHDC(UserControl.hDC, hGraphics) = 0 Then
            Call GdipSetInterpolationMode(hGraphics, &H2) 'InterpolationModeHighQuality = &H2
            GdipDrawImageRect hGraphics, hImage, 0, 0, UserControl.ScaleWidth, UserControl.ScaleHeight
            If m_X > -1 And m_Y > -1 Then
                PT(0).X = m_X:   PT(0).Y = m_Y - PS
                PT(1).X = m_X + PS: PT(1).Y = m_Y
                PT(2).X = m_X: PT(2).Y = m_Y + PS
                PT(3).X = m_X - PS: PT(3).Y = m_Y
                
                GdipCreatePen1 &HFF000000, 1, &H2, hPen
                GdipDrawPolygonI hGraphics, hPen, PT(0), 4
                GdipDeletePen hPen
            End If
            Call GdipDeleteGraphics(hGraphics)
        End If
    End If
End Sub

Private Sub Timer1_Timer()
    If IsMouseInArea = False Then
        Timer1.Interval = 0
        RaiseEvent MouseExit
    End If
End Sub

Private Sub UserControl_Initialize()
    m_X = -1
    m_Y = -1
End Sub

Private Sub Usercontrol_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    Dim XX As Long, YY As Long
    Dim oColor As Long
    Dim ARGB As COLORBYTES
    
    If hImage = 0 Then
        RaiseEvent MouseMove(Button, Shift, X, Y, -1)
    Else
        XX = ImgWidth * 100 / UserControl.ScaleWidth
        YY = ImgHeight * 100 / UserControl.ScaleHeight
        If GdipBitmapGetPixel(hImage, X * XX / 100, Y * YY / 100, ARGB) = 0 Then
           If ARGB.AlphaByte > 0 Then
               If Timer1.Interval = 0 Then Timer1.Interval = 10
               oColor = RGB(ARGB.RedByte, ARGB.GreenByte, ARGB.BlueByte)
               RaiseEvent MouseMove(Button, Shift, X, Y, oColor)
           Else
               RaiseEvent MouseMove(Button, Shift, X, Y, -1)
           End If
        End If
    End If

End Sub

Public Sub ResetColor()
    m_X = -1
    m_Y = -1
    Refresh
End Sub

Private Sub UserControl_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim XX As Long, YY As Long
    Dim oColor As Long
    Dim ARGB As COLORBYTES
    
    If hImage Then
        XX = ImgWidth * 100 / UserControl.ScaleWidth
        YY = ImgHeight * 100 / UserControl.ScaleHeight
        If GdipBitmapGetPixel(hImage, X * XX / 100, Y * YY / 100, ARGB) = 0 Then
           If ARGB.AlphaByte > 0 Then
               oColor = RGB(ARGB.RedByte, ARGB.GreenByte, ARGB.BlueByte)
               m_X = X
               m_Y = Y
               Refresh
               RaiseEvent ColorSelect(oColor)
           End If
        End If
    End If

End Sub


Private Sub UserControl_Paint()
    Call Draw
End Sub

Private Sub UserControl_HitTest(X As Single, Y As Single, HitResult As Integer)
    HitResult = vbHitResultHit
    If Ambient.UserMode Then
        Dim PT  As POINTAPI
        Call GetCursorPos(c_tPT)
        Call ClientToScreen(hParentWnd, PT)
        c_tPT.X = c_tPT.X - PT.X - X
        c_tPT.Y = c_tPT.Y - PT.Y - Y
    End If
End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    hParentWnd = UserControl.ContainerHwnd
    Call ManageGDIToken(hParentWnd)
End Sub

Private Function LoadImageFromStream(ByRef bvData() As Byte, ByRef hImage As Long) As Boolean
    On Local Error GoTo LoadImageFromStream_Error
    Dim IStream     As IUnknown
    
    If Not IsArrayDim(VarPtrArray(bvData)) Then Exit Function
    Call CreateStreamOnHGlobal(bvData(0), 0&, IStream)
    If Not IStream Is Nothing Then
        If GdipLoadImageFromStream(IStream, hImage) = 0 Then
            LoadImageFromStream = True
        End If
    End If
    Set IStream = Nothing
    
LoadImageFromStream_Error:

End Function

Private Function IsMouseInArea() As Boolean
    Dim PT As POINTAPI
    Dim CPT As POINTAPI
    Dim TR As RECT
    Dim bArea As Boolean
    Dim XX As Long, YY As Long
    Dim oColor As Long
    Dim ARGB As COLORBYTES
    
    Call GetCursorPos(PT)
    Call ClientToScreen(hParentWnd, CPT)
    
    CPT.X = PT.X - CPT.X - c_tPT.X
    CPT.Y = PT.Y - CPT.Y - c_tPT.Y


    Call SetRect(TR, 0, 0, UserControl.Width / 15, UserControl.Height / 15)
    bArea = PtInRect(TR, CPT.X, CPT.Y)

    If bArea And WindowFromPoint(PT.X, PT.Y) = hParentWnd Then
        If hImage <> 0 Then
            XX = ImgWidth * 100 / UserControl.ScaleWidth
            YY = ImgHeight * 100 / UserControl.ScaleHeight
            
            If GdipBitmapGetPixel(hImage, CPT.X * XX / 100, CPT.Y * YY / 100, ARGB) = 0 Then
               If ARGB.AlphaByte > 0 Then
                   IsMouseInArea = True
               End If
            End If
        End If
    End If

End Function

'By Lavolpe
Private Function ManageGDIToken(ByVal projectHwnd As Long) As Long
    If projectHwnd = 0& Then Exit Function
    
    Dim hwndGDIsafe     As Long                 'API window to monitor IDE shutdown
    
    Do
        hwndGDIsafe = GetParent(projectHwnd)
        If Not hwndGDIsafe = 0& Then projectHwnd = hwndGDIsafe
    Loop Until hwndGDIsafe = 0&
    ' ok, got the highest level parent, now find highest level owner
    Do
        hwndGDIsafe = GetWindow(projectHwnd, GW_OWNER)
        If Not hwndGDIsafe = 0& Then projectHwnd = hwndGDIsafe
    Loop Until hwndGDIsafe = 0&
    
    hwndGDIsafe = FindWindowEx(projectHwnd, 0&, "Static", "GDI+Safe Patch")
    If hwndGDIsafe Then
        ManageGDIToken = hwndGDIsafe    ' we already have a manager running for this VB instance
        Exit Function                   ' can abort
    End If
    
    Dim GDIsi           As GdiplusStartupInput  'GDI+ startup info
    Dim gToken          As Long                 'GDI+ instance token
    
    On Error Resume Next
    GDIsi.GDIplusVersion = 1                    ' attempt to start GDI+
    GdiplusStartup gToken, GDIsi
    If gToken = 0& Then                         ' failed to start
        If Err Then Err.Clear
        Exit Function
    End If
    On Error GoTo 0

    Dim z_ScMem         As Long                 'Thunk base address
    Dim z_Code()        As Long                 'Thunk machine-code initialised here
    Dim nAddr           As Long                 'hwndGDIsafe prev window procedure

    Const WNDPROC_OFF   As Long = &H30          'Offset where window proc starts from z_ScMem
    Const PAGE_RWX      As Long = &H40&         'Allocate executable memory
    Const MEM_COMMIT    As Long = &H1000&       'Commit allocated memory
    Const MEM_RELEASE   As Long = &H8000&       'Release allocated memory flag
    Const MEM_LEN       As Long = &HD4          'Byte length of thunk
        
    z_ScMem = VirtualAlloc(0, MEM_LEN, MEM_COMMIT, PAGE_RWX) 'Allocate executable memory
    If z_ScMem <> 0 Then                                     'Ensure the allocation succeeded
        ' we make the api window a child so we can use FindWindowEx to locate it easily
        hwndGDIsafe = CreateWindowExA(0&, "Static", "GDI+Safe Patch", WS_CHILD, 0&, 0&, 0&, 0&, projectHwnd, 0&, App.hInstance, ByVal 0&)
        If hwndGDIsafe <> 0 Then
        
            ReDim z_Code(0 To MEM_LEN \ 4 - 1)
        
            z_Code(12) = &HD231C031: z_Code(13) = &HBBE58960: z_Code(14) = &H12345678: z_Code(15) = &H3FFF631: z_Code(16) = &H74247539: z_Code(17) = &H3075FF5B: z_Code(18) = &HFF2C75FF: z_Code(19) = &H75FF2875
            z_Code(20) = &H2C73FF24: z_Code(21) = &H890853FF: z_Code(22) = &HBFF1C45: z_Code(23) = &H2287D81: z_Code(24) = &H75000000: z_Code(25) = &H443C707: z_Code(26) = &H2&: z_Code(27) = &H2C753339: z_Code(28) = &H2047B81: z_Code(29) = &H75000000
            z_Code(30) = &H2C73FF23: z_Code(31) = &HFFFFFC68: z_Code(32) = &H2475FFFF: z_Code(33) = &H681C53FF: z_Code(34) = &H12345678: z_Code(35) = &H3268&: z_Code(36) = &HFF565600: z_Code(37) = &H43892053: z_Code(38) = &H90909020: z_Code(39) = &H10C261
            z_Code(40) = &H562073FF: z_Code(41) = &HFF2453FF: z_Code(42) = &H53FF1473: z_Code(43) = &H2873FF18: z_Code(44) = &H581053FF: z_Code(45) = &H89285D89: z_Code(46) = &H45C72C75: z_Code(47) = &H800030: z_Code(48) = &H20458B00: z_Code(49) = &H89145D89
            z_Code(50) = &H81612445: z_Code(51) = &H4C4&: z_Code(52) = &HC63FF00

            z_Code(1) = 0                                                   ' shutDown mode; used internally by ASM
            z_Code(2) = zFnAddr("user32", "CallWindowProcA")                ' function pointer CallWindowProc
            z_Code(3) = zFnAddr("kernel32", "VirtualFree")                  ' function pointer VirtualFree
            z_Code(4) = zFnAddr("kernel32", "FreeLibrary")                  ' function pointer FreeLibrary
            z_Code(5) = gToken                                              ' Gdi+ token
            z_Code(10) = LoadLibrary("gdiplus")                             ' library pointer (add reference)
            z_Code(6) = GetProcAddress(z_Code(10), "GdiplusShutdown")       ' function pointer GdiplusShutdown
            z_Code(7) = zFnAddr("user32", "SetWindowLongA")                 ' function pointer SetWindowLong
            z_Code(8) = zFnAddr("user32", "SetTimer")                       ' function pointer SetTimer
            z_Code(9) = zFnAddr("user32", "KillTimer")                      ' function pointer KillTimer
        
            z_Code(14) = z_ScMem                                            ' ASM ebx start point
            z_Code(34) = z_ScMem + WNDPROC_OFF                              ' subclass window procedure location
        
            RtlMoveMemory z_ScMem, VarPtr(z_Code(0)), MEM_LEN               'Copy the thunk code/data to the allocated memory
        
            nAddr = SetWindowLong(hwndGDIsafe, GWL_WNDPROC, z_ScMem + WNDPROC_OFF) 'Subclass our API window
            RtlMoveMemory z_ScMem + 44, VarPtr(nAddr), 4& ' Add prev window procedure to the thunk
            gToken = 0& ' zeroize so final check below does not release it
            
            ManageGDIToken = hwndGDIsafe    ' return handle of our GDI+ manager
        Else
            VirtualFree z_ScMem, 0, MEM_RELEASE     ' failure - release memory
            z_ScMem = 0&
        End If
    Else
        VirtualFree z_ScMem, 0, MEM_RELEASE           ' failure - release memory
        z_ScMem = 0&
    End If
    
    If gToken Then GdiplusShutdown gToken       ' release token if error occurred
    
End Function

Private Function zFnAddr(ByVal sDLL As String, ByVal sProc As String) As Long
    zFnAddr = GetProcAddress(GetModuleHandleA(sDLL), sProc)  'Get the specified procedure address
End Function

Private Function IsArrayDim(ByVal lpArray As Long) As Boolean
    Dim lAddress As Long
    Call CopyMemory(lAddress, ByVal lpArray, &H4)
    IsArrayDim = Not (lAddress = 0)
End Function

Private Sub UserControl_Terminate()
    If hImage <> 0 Then GdipDisposeImage hImage
End Sub
